<?php if( ! defined('BASEPATH') ) exit('No direct script access allowed');
/**
 * Community Auth - Self Update View
 *
 * Community Auth is an open source authentication application for CodeIgniter 2.1.3
 *
 * @package     Community Auth
 * @author      Robert B Gottier
 * @copyright   Copyright (c) 2011 - 2013, Robert B Gottier. (http://brianswebdesign.com/)
 * @license     BSD - http://http://www.opensource.org/licenses/BSD-3-Clause
 * @link        http://community-auth.com
 */
?>

<h1>My Profile</h1>

<?php

	if( isset( $validation_errors ) )
	{
		echo '
			<div class="feedback error_message" style="margin-bottom:10px;">
				<p class="feedback_header">'.lang('profile_update').'
					
				</p>
				<ul>
					' . $validation_errors . '
				</ul>
				<p>
				'.lang('no_update').'
				</p>
			</div>
		';
	}
	else if( isset( $validation_passed ) )
	{
		echo '
			<div class="feedback confirmation" style="margin-bottom:10px;">
				<p class="feedback_header">
					'.lang('update_success').'
				</p>
			</div>
		';
	}

	if( $user_data !== FALSE )
	{

?>
<div class="profile_image">
	<?php
		// PROFILE IMAGE
		echo img(
			( ! empty( $user_data->profile_image ) ) ? $user_data->profile_image : 'assets/img/default-profile-image.jpg',
			FALSE,
			( $upload_destination == 'database' && ! empty( $user_data->profile_image ) ) ? TRUE : FALSE
		);
	?>
</div>
<div id="user_info">
	<h3><?php echo $user_data->user_name; ?></h3>
	<ul class="std-list">
		<li>
			<?php echo lang('reg_date')?>: <?php echo  date('F j, Y, g:i a',$user_data->user_date); ?>
		</li>
		<li>
			<?php echo lang('last_modified')?>: <?php echo  date('F j, Y, g:i a',$user_data->user_modified); ?>
		</li>
		<li>
			<?php echo lang('last_login')?>: <?php echo ($user_data->user_last_login != FALSE)? date('F j, Y, g:i a',$user_data->user_last_login) : '<span class="redfield">NEVER LOGGED IN</span>'; ?>
		</li>
	</ul>
</div>

<?php 
	echo form_open_multipart( 'user/self_update', array( 'class' => 'std-form' ) ); 

	echo $role_specific_form;

	echo form_close();

	}
	else
	{
		echo lang('no_user_data');
	}

/* End of file self_update.php */
/* Location: /application/views/self_update.php */