<!DOCTYPE html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7"> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8"> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9"> <![endif]-->
<!--[if gt IE 8]><!-->
<html class="no-js">
	<!--<![endif]-->
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
		<title><?php if(isset($item['item_name'])) { echo $item['item_name']; } else{ echo $lang['settings']['meta_title']; }?></title>
		<meta name="description" content="<?php if(isset($item['item_content'])) { echo strip_tags(character_limiter(html_entity_decode($item['item_content']), 300)); } else{ echo $lang['settings']['meta_description']; } ?>">
		<meta name="viewport" content="user-scalable = yes">
		<link rel="apple-touch-icon" href="<?php echo base_url(); ?>assets/ico/touch-icon-iphone.png">
		<link rel="apple-touch-icon" sizes="76x76" href="<?php echo base_url(); ?>assets/ico/touch-icon-ipad.png">
		<link rel="apple-touch-icon" sizes="120x120" href="<?php echo base_url(); ?>assets/ico/touch-icon-iphone-retina.png">
		<link rel="apple-touch-icon" sizes="152x152" href="<?php echo base_url(); ?>assets/ico/touch-icon-ipad-retina.png">
		<link rel="icon" href="<?php echo base_url(); ?>assets/ico/favicon.ico" type="image/x-icon">
		<?php if(isset($item['item_name'])) {
			if(!empty($images)){
				if($img_data=json_decode($images[0]['paths'])){
					$og_image =  base_url().$img_data->medium2_image;
				}}
				else{
					$cat_paths = $this->menu->getkeypath($menu_items, $item['item_category']);
					$item_top_cat=$cat_paths[0];
					$item_cat_info=$this->menu->all_cats[$item_top_cat];
					$cat_data = $this->menu->all_cats[$item['item_category']];
					$og_image =  base_url()."assets/img/category_icons/".$item_cat_info['ref_name'].".png";
				}				
		?>	
		<meta property="og:image" content="<?php echo $og_image; ?>"/>
		<meta property="og:title" content="<?php echo $item['item_name']; ?>"/>
		<meta property="og:description" content="<?php echo strip_tags(html_entity_decode($item['item_content'])); ?>"/>
		<meta property="og:url" content="<?php echo current_url(); ?>"/>
		<meta property="og:site_name" content="<?php if(isset($item['item_name'])) { echo $item['item_name']; } else{ echo $lang['settings']['meta_title']; } ?>"/>
		<meta property="og:type" content="article"/>
		<?php } ?>
		<link href='http://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=latin,latin-ext' rel='stylesheet' type='text/css'>
		<link href="//netdna.bootstrapcdn.com/font-awesome/4.0.3/css/font-awesome.css" rel="stylesheet">
		<link rel="stylesheet" href="<?php echo base_url(); ?>assets/css/normalize.min.css">
		<link rel="stylesheet" href="<?php echo base_url(); ?>assets/css/main.css">
		
		<script src="//ajax.googleapis.com/ajax/libs/jquery/1.10.1/jquery.min.js"></script>
		<script src="<?php echo base_url(); ?>assets/js/vendor/modernizr-2.6.2.min.js"></script>
		<script src="<?php echo base_url(); ?>assets/js/jquery.sticky.js"></script>
		<script>window.jQuery || document.write('<script src="<?php echo base_url(); ?>assets/js/vendor/jquery-1.10.1.min.js"><\/script>')</script>
		<script>
    $(window).load(function(){
      $("#sticker").sticky({ topSpacing: 0, center:true, className:"hey" });
    });
  </script>
  <?php echo $lang['settings']['ga_code']; ?>
	</head>
	<body>
		
		<?php if($lang['country_id']=='56'){ ?>
			<!-- Google Tag Manager -->
			<noscript><iframe src="//www.googletagmanager.com/ns.html?id=GTM-NS5J9L"
			height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
			<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
			new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
			j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
			'//www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
			})(window,document,'script','dataLayer','GTM-NS5J9L');</script>
			<!-- End Google Tag Manager -->

		<?php } ?>
		
		<div id="fb-root"></div>
		<script>(function(d, s, id) {
		  var js, fjs = d.getElementsByTagName(s)[0];
		  if (d.getElementById(id)) return;
		  js = d.createElement(s); js.id = id;
		  js.src = "//connect.facebook.net/en_GB/all.js#xfbml=1&appId=610719735681219";
		  fjs.parentNode.insertBefore(js, fjs);
		}(document, 'script', 'facebook-jssdk'));</script>
		<!--[if lt IE 7]>
		<p class="chromeframe">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> or <a href="http://www.google.com/chromeframe/?redirect=true">activate Google Chrome Frame</a> to improve your experience.</p>
		<![endif]-->
		<div class="wrapper">
			
			<?php echo ( isset( $content ) ) ? $content : ''; ?>
			<div class="push"></div>
		</div>
		<footer class="footer">
			<div class="main_wrap">
				
				<?php
				$main_pages=$this->main_model->get_pages(0,$lang['country_id']);
				foreach($main_pages as $mp){ ?>
					<div class="footer_menu">
					<h5><?php echo $mp['title'];?></h5>
					<ul>
						<?php
						$sub_pages=$this->main_model->get_pages($mp['id'],$lang['country_id']);
						foreach($sub_pages as $sp){
							$page_link = base_url() . 'page/' . url_title($sp['title'], 'dash', TRUE) . '/' . $sp['id'];
						?>
						<li>
							<a href="<?php echo $page_link;?>"><?php echo $sp['title'];?></a>
						</li>
						<?php } ?>
						
					</ul>
				</div>
				<?php } ?>


				<div class="footer_support">
					<div class="footer_social">
						<?php 
						$social_links = json_decode($lang['settings']['social_links']); 
						if(!empty($social_links)){
							foreach ($social_links as $link) {
						?>
						<a href="<?php echo $link->link; ?>" target="_blank" class="<?php echo strtolower($link->title); ?>"></a>
						<?php }} ?>				
						</div>
					<a href="mailto:<?php echo $lang['settings']['support_email']; ?>" class="online_support"><?php echo lang('online_support'); ?></a>
					
				</div>
				
				

            
            <ul class="footer_country">
            	<li>
                    <a href="http://www.buybooy.com"><i class="icon-g"></i></a>
                </li>
                <li>
                    <a href="http://www.buybooy.com.hr"><i class="icon-hr"></i></a>
                </li>
                <li>
                    <a href="http://www.buybooy.si"><i class="icon-si"></i></a>
                </li>
                <li>
                    <a href="http://www.buybooy.ba"><i class="icon-ba"></i></a>
                </li>
                <li>
                    <a href="http://www.buybooy.it"><i class="icon-it"></i></a>
                </li>
                <li>
                    <a href="http://www.buybooy.co.uk"><i class="icon-uk"></i></a>
                </li>
                <li>
                    <a href="http://www.buybooy.us"><i class="icon-us"></i></a>
                </li>
                <li>
                    <a href="http://www.buybooy.ca"><i class="icon-ca"></i></a>
                </li>
            </ul>
        

			</div>
		</footer>

		<?php if(!isset($_COOKIE['notification'])){ setcookie("notification", "1", time()+3600*24*30, "/"); ?>
		<div id="notification">
			<span id="close_notification"></span>
			<span id="terms_agree"><?php echo lang('cookie_agree'); ?></span>
			<div class="main_wrap">
				<p class="cookie_policy">
					
					<?php 
					$cookie_link = base_url() . "page/cookie/14";
					echo str_replace('%link%', $cookie_link, lang('cookie_policy')); ?>
				</p>
			</div>
		</div>	
		</div>
		<?php } ?>
		<div id="notification-green">
			<span id="close_notification_green" class="close_notification"></span>
			<div class="main_wrap">
				<p class="message_wrap_green"></p>
			</div>
		</div>
		<div id="notification-red">
			<span id="close_notification_red" class="close_notification"></span>
			<div class="main_wrap">
				<p class="message_wrap_red"></p>
			</div>
		</div>
		<div class="loader"></div>
		<a id="go_top"><i class="fa fa-arrow-up"></i></a>
		<script src="<?php echo base_url(); ?>assets/js/plugins.js"></script>
		<script src="<?php echo base_url(); ?>assets/js/main.js"></script>
		<?php if($lang['country_id'] == 29){
		    
            if (!isset($_COOKIE["bih"])){
		    setcookie("bih", 1, time() + 432000); 

		?>
		 <div class="popup">
		     <div class="popup_ad">
		         <span class="close_ad">Zatvori</span>
		         <a href="<?php echo base_url(); ?>page/kontakt/7">
		         <img src="<?php echo base_url(); ?>bih/franchise_banner_popup.jpg" alt="BuyBooy" />
		         </a>
		     </div>
		 </div>
		 <script type="text/javascript">
		     $(document).ready(function() {
		         $(".close_ad").click(function(e) {
		             $(".popup").fadeOut("fast", "linear");
		         });
		         
		         setTimeout(function(){ $(".popup").fadeOut("fast", "linear"); }, 10000 ); 
  
  
		     });
		 </script>
		  
		<?php } } ?>
	</body>
</html>