<header>
    <?php $this->load->view('include/header'); ?>
    <?php $this->load->view('include/search'); ?>
</header>

<section class="main_content padding_top_50">
    <div class="main_wrap">
        <aside>
            <?php $this->load->view('include/user_menu'); ?>
        </aside>

        <section class="listing_wrap" id="listing_wrap">
         <?php echo form_open( 'listing/process', array( 'class' => '', 'style' => '','role'=>'form', 'id'=>'listing_form' ) ); ?> 
           <?php echo $filters;?>
            <div class="l_title">
                <h3><span><?php echo lang('listing_title'); ?></span> <span class="l_info tip" data-tip="<?php echo lang('tooltip_listing_title'); ?>"><img src="<?php echo base_url(); ?>assets/img/info.png" alt="Information" /></span></h3>
                <input type="text" name="listing_title" placeholder="<?php echo lang('listing_title'); ?>" value="<?php echo (isset($listing))?htmlentities($listing['item_name']):null;?>"/>
            </div>
            
            <div class="l_content">
                <h3><span><?php echo lang('listing_content'); ?></span> <span class="l_info tip" data-tip="<?php echo lang('tooltip_listing_content'); ?>"><img src="<?php echo base_url(); ?>assets/img/info.png" alt="Information" /></span></h3>
                <textarea name="listing_content" placeholder="<?php echo lang('listing_content'); ?>"><?php echo (isset($listing))?strip_tags($listing['item_content'], '<br>'):null;?></textarea>
            </div>
            <div class="l_budget">
                <h3><span><?php echo lang('listing_budget'); ?></span><span class="l_info tip" data-tip="<?php echo lang('tooltip_listing_budget'); ?>"><img src="<?php echo base_url(); ?>assets/img/info.png" alt="Information" /></span></h3>
                <input type="text" name="listing_budget" placeholder="<?php echo lang('listing_budget'); ?>" value="<?php echo (isset($listing))?$listing['item_budget']:null;?>"/>
            </div>
             <div class="l_currency">
             	
                <h3><span><?php echo lang('listing_currency'); ?></span> <span class="l_info tip" data-tip="<?php echo lang('tooltip_listing_currency'); ?>"><img src="<?php echo base_url(); ?>assets/img/info.png" alt="Information" /></span></h3>
                <select name="listing_budget_currency">
                	 <?php foreach($currencies as $cr){ ?>
                    <option value="<?php echo $cr['id'];?>" <?php if(isset($listing) && $listing['item_budget_currency']==$cr['id']) { echo 'selected="selected"'; } else if($lang['currency_id']==$cr['id']) { echo 'selected="selected"'; } ?>><?php echo $cr['name'];?></option>
               		 <?php } ?>
                </select>
            </div>
            <div class="l_active">
                <h3><span><?php echo lang('listing_time'); ?></span> <span class="l_info tip" data-tip="<?php echo lang('tooltip_listing_time'); ?>"><img src="<?php echo base_url(); ?>assets/img/info.png" alt="Information" /></span></h3>
                <select name="listing_time">
                    <option value="5">5 <?php echo lang('days'); ?></option>
                    <option value="15">15 <?php echo lang('days'); ?></option>
                    <option value="30">30 <?php echo lang('days'); ?></option>
                    <option value="60">60 <?php echo lang('days'); ?></option>
                </select>
            </div>
            <div class="l_language">
                <h3><span><?php echo lang('listing_language'); ?></span> <span class="l_info tip" data-tip="<?php echo lang('tooltip_listing_language'); ?>"><img src="<?php echo base_url(); ?>assets/img/info.png" alt="Information" /></span></h3>
                <select name="listing language">
                <?php foreach($sys_languages as $sl){ ?>
                    <option value="<?php echo $sl['id'];?>" <?php if(isset($listing) && $listing['lang_id']==$sl['id']){ echo 'selected="selected"'; } else if($lang['id']==$sl['id']) { echo 'selected="selected"'; } ?>><?php echo $sl['name'];?></option>
                 <?php } ?>
                </select>
            </div>
            <input type="hidden" name="listing_id" value="<?php echo $listing_id;?>" /> 
            <div class="l_save">
            </div>
            <div class="listing_filter_wrap">
            	<div class="listing_filter">
            		<h4><span><?php echo lang('listing_countries'); ?></span></h4>
            		<ul>
                <?php
                //PREP FOR CHECK
                $tmp_countries=array();
				if(isset($listing_countries)){
				foreach((array)$listing_countries as $lc){
					$tmp_countries[]=$lc['country_id'];
				}
				}
                 foreach($sys_countries as $sc){ ?>
                	<li class="listing_filter_line">
					<input id="c_<?php echo $sc['id']; ?>" type="checkbox" name="listing_countries[]" value="<?php echo $sc['id']; ?>" <?php echo (isset($listing_countries) && in_array($sc['id'],$tmp_countries))?'checked="checked"':null;?>/>
					<label for="c_<?php echo $sc['id']; ?>"><span></span><?php echo $sc['country_name']; ?></label>
			       </li>
                <?php } ?>
                </ul>
            </div>
        </form>  
        <form action="<?php echo base_url(); ?>listing/upload?listing_id=<?php echo $listing_id;?>" class="custom_dropzone dropzone_add_<?php echo $lang['abbr'];?>"></form>
        <section id="attachments"></section>
		 <a href="#" class="save_listing" id="save_listing"><?php echo lang('listing_publish'); ?></a>
</section>

</div>
</section>
<link href="<?php echo base_url(); ?>assets/dropzone/css/custom_dropzone.css" type="text/css" rel="stylesheet" />
<script src="<?php echo base_url(); ?>assets/dropzone/dropzone.js"></script>
<script src="<?php echo base_url();?>assets/jquery_validation/dist/jquery.validate.js"></script>
<script>
load_attachments();

$(function() {
  // Now that the DOM is fully loaded, create the dropzone, and setup the 
  // event listeners

  var myDropzone = new Dropzone(".custom_dropzone");

  myDropzone.on("complete", function(file) {
  	load_attachments();
    /* Maybe display some more file information on your page */
  });

})

$('#attachments').on('click','.delete_attachment',function(e){
	$(".loader").fadeIn('fast');
	e.preventDefault();
	var type=$(this).data('type');
	var id=$(this).data('id');
	var hash=$(this).data('hash');
	$.get( "<?php echo base_url().'listing/delete_file';?>", {listing_id:id,type:type,hash:hash}, function( data ) {
		var obj = jQuery.parseJSON(data);
		if(obj.status==1){
			$('.message_wrap_green').html(obj.message);
			$('#notification-green').fadeIn().delay(4000).fadeOut();
			load_attachments();
		}
		else{
			$('.message_wrap_red').fadeIn().html(obj.message).delay(4000).fadeOut();
			load_attachments();
		}
		$(".loader").fadeOut('fast');
	});
	
});

$('#save_listing').on('click',function(e){
	e.preventDefault();
	$("#listing_form").submit();
	});
	
	$("#listing_form").validate({
		rules: {
                listing_title: {
                    required: true
                },
                listing_content: {
                    required: true
                }
            },
            messages: {
                listing_title: {
                    required: "<?php echo lang('listing_title_error'); ?>"
                },
                listing_content: {
                    required: "<?php echo lang('listing_content_error'); ?>"
                }
                
                
            },
	  submitHandler: function(form) {
	  	$(".loader").fadeIn('fast');
	    var data=$(form).serialize();
	    $.post( "<?php echo base_url().'listing/process';?>", data, function( data ) {
	    	
  				var obj = jQuery.parseJSON(data);
  				if(obj.status==1){
  					$('.message_wrap_green').html(obj.message);
					$('#notification-green').fadeIn().delay(4000).fadeOut();
  					setTimeout(function(){window.location.replace('<?php echo base_url();?>user');},5000);
  				}
  				else{
  					$('.message_wrap_red').fadeIn().html(obj.message).delay(4000).fadeOut();
  				}
  				$(".loader").fadeOut('fast');
  			});
	  }
	 });

function load_attachments(){
	$(".loader").fadeIn('fast');
	var listing_id=<?php echo $listing_id;?>;
	$.get( "<?php echo base_url().'listing/list_attachments';?>", {listing_id:listing_id}, function( data ) {
		$('#attachments').html(data);
		$(".loader").fadeOut('fast');
	});
}
</script>