<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Offers extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model('main_model');
		$this->load->model('offers_model');
		$this->load->model('credits_model');
		$this->load->model('user_model');
		$this->load->helper('language');
		$this->load->helper('url');
		$this->load->helper('links');
		$this->load->helper('text');
		$this->load->helper('cookie');
		//$this->output->enable_profiler(TRUE);
		$this->load->library('multilang', array(
			'default_lang' => 'hr',
			'multilang' => true,
			'segment' => 3
		));
	}

	public function index() {
	}

	//SHOW DIALOG FOR ADD/EDIT OFFER
	public function add_dialog() {

		$this->is_logged_in();

		//POSTAVLJANJE JEZIKA
		$data['lang'] = $this->multilang->get_current();
		//INICIJALIZIRAMO MENU LIB
		$this->load->library('menu', array('lang' => $data['lang']));
		//DOHVATIMO MENU ARRAY
		$data['menu_items'] = $this->menu->generate_categories_paths(NULL);

		if (isset($this->auth_user_id)) {

			if ($listing_id = $this->input->get('listing_id', true)) {
				//CHECK IF USER HAS ALREADY APPLIED
				if ($offer = $this->offers_model->has_applied($this->auth_user_id, $listing_id)) {
					$data['listing_id'] = $listing_id;
					$data['offer'] = $offer;
					$data['message'] = lang('offer_applied');
					$data['content'] = $this->load->view('offers/add_dialog_view', $data);
				} else {
					$data['user_credits']=$this->main_model->get_user_credits($this->auth_user_id);	
					$data['listing_id'] = $listing_id;
					$data['content'] = $this->load->view('offers/add_dialog_view', $data);
				}
			}
		} else {
			$listing_id = $this->input->get('listing_id', true);
			$item=$this->main_model->get_item($listing_id);
			$url=base_url().'item/'.url_title($item['item_name'], 'dash', TRUE).'/'.$item['item_id'].'?offer=true';
			$data['dialog_message'] = str_replace('%link%',$url,lang('dialog_login_submit'));
			$data['content'] = $this->load->view('include/messages_view', $data);
		}
	}

	//SERVE OFFER DETAILS FORM VIA AJAX
	public function add_offer() {
		if ($this->require_min_level(1)) {
			//POSTAVLJANJE JEZIKA
			$data['lang'] = $this->multilang->get_current();

			$data['listing_id'] = $this->input->get('listing_id', true);
			$data['offer_id'] = $this->input->get('offer_id', true);
			$data['offer'] = $this->offers_model->get_offer($data['offer_id'], $this->auth_user_id);
			$this->load->view('offers/add_offer', $data);
		}
	}

	//CREATE BLANK OFFER
	public function save() {
		if ($this->require_min_level(1)) {
			//POSTAVLJANJE JEZIKA
			if ($this->input->post('listing_id') && !$this->offers_model->has_applied($this->auth_user_id, $this->input->post('listing_id'))) {
				$listing_id = $this->input->post('listing_id', true);
				//WE INSERT BLANK LISTING
				$basic_data = array(
					'item_id' => $listing_id,
					'user_id' => $this->auth_user_id,
					'offer_datetime' => date('Y-m-d H:i:s'),
				);
				//CHECK IF USER HAS ENOUGH CREDITS
				$user_credits=$this->main_model->get_user_credits($this->auth_user_id);
				//SET OFFER PRICE
				$offer_price=1;
				//KILL APP IF NOT ENOUGH CREDITS
				if(empty($user_credits) || ($user_credits['credits']-$offer_price)<=0){
					$response = array(
					'status' => 0,
					'offer_id' => 0,
					'message' => lang('offer_no_credit')
					);
					echo json_encode($response);
					die();
				}
				
				if ($id = $this->offers_model->insert($basic_data)) {
					//REMOVE CREDIT
					if($this->credits_model->charge_credits($this->auth_user_id,$offer_price)){
						$log_data=array(
							'event_type'=>2,
							'user_id'=>$this->auth_user_id,
							'data'=>json_encode(array(
								'status'=>'1',
								'listing_id'=>$listing_id,
								'offer_id'=>$id,
								'price'=>$offer_price
							))
						);
						$this->main_model->add_credit_log($log_data);
					}
					else{
						$log_data=array(
							'event_type'=>2,
							'user_id'=>$this->auth_user_id,
							'data'=>json_encode(array(
								'status'=>'0',
								'listing_id'=>$listing_id,
								'offer_id'=>$id,
								'price'=>$offer_price
							))
						);
						$this->main_model->add_credit_log($log_data);
					}
					
					//IF INSERT WAS SUCCESSFUL
					$response = array(
						'status' => 1,
						'offer_id' => $id,
						'message' => lang('offer_created')
					);
				} else {
					//IF INSERT FAILED
					$response = array(
						'status' => 0,
						'offer_id' => 0,
						'message' => lang('offer_not_created')
					);
				}

			} else {
				//IF CATEGORY ID WASNT POSTED
				$response = array(
					'status' => 0,
					'offer_id' => 0,
					'message' => lang('offer_not_created')
				);
			}

			echo json_encode($response);

		}
	}

	//UPDATE OFFER DETAILS AND EDIT OFFER
	public function add_process() {
		if ($this->require_min_level(1)) {

			$lang = $this->multilang->get_current();
			//IF CURRENT USER IS OWNER OF OFFER
			if ($this->offers_model->is_owner($this->auth_user_id, $this->input->post('offer_id', true)))
				$this->load->library('form_validation');
			$offer_data = array(
				'title' => $this->input->post('offer_title', true),
				'content' => $this->input->post('offer_content', true),
				'budget' => $this->input->post('offer_budget', true),
				'budget_currency' => $this->input->post('offer_budget_currency', true),
				'delivery_time' => $this->input->post('offer_delivery_time', true),
				'published' => '1'
			);
			$offer_id = $this->input->post('offer_id', true);
			if ($this->offers_model->update($offer_id, $offer_data)) {
				/**ADD NOTIFICATION AND SEND MAIL**/
				$this->load->library('email');
				$this->config->load('email');
				//BASIC DATA ABOUT ITEM
				$base_data = $this->offers_model->get_base_data($offer_id);
				//GENERATE LINK TO ITEM
				$item_link = base_url() . 'item/' . url_title($base_data['item_name'], 'dash', TRUE) . '/' . $base_data['item_id'] . '?login=true&o_id=' . $offer_id.'#offer_'.$offer_id;
				//GET USER DATA FOR EMAIL
				$user_data = $this->user_model->view_user_record($base_data['item_owner']);
				$user_settings=$this->user_model->get_user_settings($base_data['item_owner']);
				//GET MESSAGE AND SET LINK
				$message = str_replace('%link%', $item_link, lang('not_offer_updated'));
				$notif_data = array(
					'user_id' => $base_data['item_owner'],
					'type_id' => 3,
					'message' => $message,
					'item_id'=>$base_data['item_id']
				);
				//SAVE NOTIFICATION
				$this->main_model->add_notification($notif_data);
				if(!isset($user_settings['not_new_offer']) || $user_settings['not_new_offer']=='1'){
					//SEND MAIL
					$sent = $this->email->quick_email(array(
						'subject' => lang('not_mail_title'),
						'email_template' => 'email_templates/notification',
						'from_name' => 'no_reply_email_config',
						'template_data' => array('message' => $message),
						'to' => $user_data->user_email
					));
				}
				
				/**END NOTIFICATION**/

				$response = array(
					'status' => '1',
					'message' => lang('offer_saved')
				);
			} else {
				$response = array(
					'status' => '0',
					'message' => lang('offer_not_saved')
				);
			}
		} else {
			$response = array(
				'status' => '0',
				'message' => lang('offer_not_owner_2')
			);
		}
		echo json_encode($response);
	}

	function upload() {
		//IF LOGGED IN
		if ($this->require_min_level(1)) {
			$listing_id = $this->input->get('listing_id', true);
			$offer_id = $this->input->get('offer_id', true);
			//IF OWNER OF LISTING
			if ($this->offers_model->is_owner($this->auth_user_id, $listing_id)) {
				if (!empty($_FILES)) {
					$file = $_FILES['file'];
					$tempFile = $file['tmp_name'];

					$path = $this->check_folder($listing_id . '/' . $this->auth_user_id . '/of');
					//GENERATE INDEX.HTML TO PREVENT DIRECT ACCESS
					$security_index = $path . '/index.html';
					if (!file_exists($security_index)) {
						$msg = "You don't have premissions to access this location.";
						file_put_contents($security_index, $msg);
					}
					$original_name = $file['name'];
					$fn = $this->safeName($file['name']);
					$file_path = $path . '/' . $fn;
					//FILE CHECK
					if (file_exists($file_path)) {
						$rand = rand(100, 999);
						$file_path = $path . '/' . $rand . $fn;
					}

					if (move_uploaded_file($file['tmp_name'], $file_path)) {
						//ONLY READ PREMISSIONS
						chmod($file_path, 0644);
						//DISTINCT DOCUMENTS AND PHOTOS
						$file_info = pathinfo($file_path);
						$extension = $file_info['extension'];
						$photos = array(
							'jpeg',
							'jpg',
							'png',
							'JPG',
							'JPEG'
						);
						$documents = array(
							'doc',
							'docx',
							'xls',
							'xlsx',
							'pdf',
							'txt'
						);
						if (is_int(array_search($extension, $photos))) {

							//RESIZE
							//BASIC CONF
							$img_config = array(
								'image_path' => $file_path,
								'delete_orig' => true,
								'quality' => 90,
							);
							//OUTPUT IMAGES
							$images = array(
								'large' => array('w' => 1000),
								'medium' => array(
									'w' => 227,
									'h' => 211
								),
								'medium2' => array(
									'w' => 558,
									'h' => 393
								),
								'small' => array(
									'w' => 86,
									'h' => 86
								)
							);
							//OSTAVLJAMO ORGINAL
							$paths = $this->resize_image($img_config, $images);
							//SAVE AS PHOTO
							$img_data = array(
								'offer_id' => $offer_id,
								'name_hash' => $file_info['filename'],
								'paths' => json_encode($paths),
								'extension' => $extension,
								'upload_datetime' => date('Y-m-d H:i:s')
							);
							$this->offers_model->insert_image($img_data);

							//GENERAL RESPONSE
							$response = array(
								'status' => 1,
								'message' => 'File uploaded',
								'file_type' => 'image',
								'listing_id' => $listing_id,
								'file_path' => $paths,
								'file_info' => $file_info
							);
						} else if (is_int(array_search($extension, $documents))) {

							//SAVE AS DOCUMENT
							$doc_data = array(
								'offer_id' => $offer_id,
								'name_hash' => $file_info['filename'],
								'document_name' => $original_name,
								'extension' => $extension,
								'upload_datetime' => date('Y-m-d H:i:s')
							);
							$this->offers_model->insert_document($doc_data);
							//GENERAL RESPONSE
							$response = array(
								'status' => 1,
								'message' => 'File uploaded',
								'file_type' => 'document',
								'listing_id' => $listing_id,
								'file_path' => $file_path,
								'file_info' => $file_info
							);
						}
						//IF NOT ALLOWED IMAGE OR DOCUMENT
						else {
							$response = array(
								'status' => 0,
								'message' => 'File type not allowed',
							);
							echo json_encode($response);
							die();
						}

					} else {
						$response = array(
							'status' => 0,
							'message' => 'Upload failed'
						);
					}
				}
			} else {
				$response = array(
					'status' => 0,
					'message' => "You don't have premission to upload"
				);
			}
		} else {
			$response = array(
				'status' => 0,
				'message' => "You don't have premission to upload"
			);
		}

		echo json_encode($response);
	}

	function delete_file() {
		if ($this->require_min_level(1)) {
			$listing_id = $this->input->get('listing_id', true);
			$hash = $this->input->get('hash', true);
			//IF OWNER OF LISTING
			if ($this->offers_model->is_owner($this->auth_user_id, $listing_id)) {
				$type = $this->input->get('type');
				if ($type == 'image') {
					$image = $this->offers_model->get_image($listing_id, $hash);
					$files = json_decode($image['paths']);
					if (!empty($files)) {
						foreach ($files as $f) {
							if (file_exists(FCPATH . $f))
								unlink(FCPATH . $f);
						}
					}
					if ($this->offers_model->delete_image($listing_id, $hash)) {
						$response = array(
							'status' => 1,
							'message' => "Image deleted"
						);
					}
				} else if ($type == 'document') {
					$document = $this->listing_model->get_document($listing_id, $hash);
					$document_path = '/upload/' . $listing_id . '/' . $document['name_hash'] . '.' . $document['extension'];
					if (file_exists(FCPATH . $document_path)) {
						if (unlink(FCPATH . $document_path)) {
							if ($this->offers_model->delete_document($listing_id, $hash)) {
								$response = array(
									'status' => 1,
									'message' => "Document deleted"
								);
							}
						}
					}
				}
			} else {
				$response = array(
					'status' => 0,
					'message' => "You don't have premission to upload"
				);
			}

		} else {
			$response = array(
				'status' => 0,
				'message' => "You don't have premission to upload"
			);
		}

		echo json_encode($response);
	}

	//PRIVATE FUNCTIONS

	//UPLOAD
	private function check_folder($path) {
		$real_path = 'upload/' . $path;
		if (is_dir($real_path)) {
			return $real_path;
		} else {
			//ONLY WEB SERVER CAN ACCESS 0700
			if (mkdir($real_path, 0755, true))
				return $real_path;
			else
				return FALSE;
		}

	}

	private function safeName($string) {
		$path_info = pathinfo($string);
		$extension = $path_info['extension'];
		$name = $path_info['filename'];
		$not_allowed = array(
			'php',
			'html',
			'js',
			'jsp'
		);
		if (is_int(array_search($extension, $not_allowed))) {
			die('FILE TYPE NOT ALLOWED');
		}
		// $string = preg_replace('/[^\\pL\d]+/u', '_', $name);
		// $string = trim($string, '_');
		// $string = iconv('utf-8', 'us-ascii//TRANSLIT', $string);
		// $string = strtolower($string);
		// $string = preg_replace('/[^-\w]+/', '', $string);4
		$stamp = time();
		$string = md5($name . $stamp);
		return $string . '.' . $extension;
	}

	private function resize_image($img_config = array(), $images = array()) {
		$this->load->library('image_moo');
		//DEFAULT CONFIG
		$image_path = $img_config['image_path'];
		unset($img_config['image_path']);

		if (empty($img_config)) {
			$img_config = array(
				'delete_orig' => true,
				'quality' => 90
			);
		}
		if (empty($images)) {
			$images = array(
				'large' => array('w' => 1000),
				'medium' => array('w' => 600),
				'small' => array('w' => 200)
			);
		}

		//GET IMAGE INFO
		$file_info = pathinfo($image_path);

		foreach ($images as $key => $image) {
			if (!isset($image['quality']))
				$quality = $img_config['quality'];
			else
				$quality = $image['quality'];

			//AKO JE POSTAVLJENA SAMO SIRINA SAMO RADI RESIZE
			if (isset($image['w']) && !isset($image['h']))
				$this->image_moo->set_jpeg_quality($quality)->load($image_path)->resize($image['w'])->save_pa('', '_' . $key, TRUE);
			//AKO SU POSTAVLJENI I SIRINA I VISINA RADI RESIZE CROP
			if (isset($image['w']) && isset($image['h']))
				$this->image_moo->set_jpeg_quality($quality)->load($image_path)->resize_crop($image['w'], $image['h'])->save_pa('', '_' . $key, TRUE);

			$paths[$key . '_image'] = $file_info['dirname'] . '/' . $file_info['filename'] . '_' . $key . '.' . $file_info['extension'];
		}

		//DELETE ORIGINAL IMAGE
		if ($img_config['delete_orig'])
			unlink($image_path);
		else
			$paths['original'] = $image_path;

		return $paths;
	}

}
