<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Listing extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model('main_model');
		$this->load->helper('language');
		$this->load->model('listing_model');
		$this->load->helper('text');
		$this->load->helper('url');
		$this->load->library('multilang', array(
			'default_lang' => 'hr',
			'multilang' => true,
			'segment' => 3
		));
	}

	public function index() {
		if ($this->require_min_level(1)) {
			//IF PROFILE IS NOT FILLED YOU MAY NOT CREATE LISTING
			if($this->_check_profile($this->auth_user_id)){
				//POSTAVLJANJE JEZIKA
				$data['lang'] = $this->multilang->get_current();
				//INICIJALIZIRAMO MENU LIB
				$this->load->library('menu', array('lang' => $data['lang']));
				//DOHVATIMO MENU ARRAY
				$data['menu_items'] = $this->menu->generate_categories_paths();
				$data['my_offers']=$this->listing_model->get_user_offers($this->auth_user_id);
				$data['my_listings']=$this->listing_model->get_user_items($this->auth_user_id); 		   
		        $data['notifications']=$this->main_model->get_notifications($this->auth_user_id); 
				$data['watched_items']=$this->listing_model->get_user_watchlist($this->auth_user_id);
				$data = array('content' => $this->load->view('listing/add_listing', $data, TRUE), );
				$this->load->view($this->template, $data);
			}
			else{
				redirect('user/profile/update');
			}


		}

	}

	public function save() {
		if ($this->require_min_level(1)) {
			//POSTAVLJANJE JEZIKA
			$data['lang'] = $this->multilang->get_current();
			//INICIJALIZIRAMO MENU LIB
			$this->load->library('menu', array('lang' => $data['lang']));
			//DOHVATIMO MENU ARRAY
			$data['menu_items'] = $this->menu->generate_categories_paths();
			$data['sys_countries'] = $this->main_model->get_sys_countries();
			$data['sys_languages'] = $this->main_model->list_languages();
			$data['currencies']=$this->main_model->list_currencies();
			$data['my_offers']=$this->listing_model->get_user_offers($this->auth_user_id);
			$data['my_listings']=$this->listing_model->get_user_items($this->auth_user_id); 		   
	        $data['notifications']=$this->main_model->get_notifications($this->auth_user_id); 
			$data['watched_items']=$this->listing_model->get_user_watchlist($this->auth_user_id);
			if ($this->input->post('current_cat')) {
				$current_cat = $this->input->post('current_cat', true);
				//WE INSERT BLANK LISTING
				$basic_data = array(
					'user_id' => $this->auth_user_id,
					'item_category' => $current_cat,
					'item_insert_datetime' => date('Y-m-d H:i:s'),
					'item_status' => '0'
				);
				if ($id = $this->listing_model->insert($basic_data)) {
					//INSERT FILTERS
					if ($this->input->post('filter')) {
						$filters = $this->input->post('filter', true);
						foreach ($filters as $f) {
							$filter_data = array(
								'item_id' => $id,
								'property_id' => $f
							);
							$this->listing_model->insert_filter($filter_data);
						}
					}

					//IF INSERT WAS SUCCESSFUL
					$data['listing_id'] = $id;
					$data = array('content' => $this->load->view('listing/save_listing', $data, TRUE), );
				} else {
					//IF INSERT FAILED
					$data = array('content' => $this->load->view('listing/add_error', $data, TRUE), );
				}

			}
			//EDIT
			else if ($this->input->get('listing_id',true) && $this->listing_model->is_owner($this->auth_user_id,$this->input->get('listing_id',true))) {
				$data['listing_id'] = $this->input->get('listing_id',true);
				$data['listing']=$this->main_model->get_item($data['listing_id']);
				$data['listing_countries']=$this->main_model->get_item_countries($data['listing_id']);
				$data = array('content' => $this->load->view('listing/save_listing', $data, TRUE), );
			} else {
				//IF CATEGORY ID WASNT POSTED
				$data = array('content' => $this->load->view('listing/add_error', $data, TRUE), );
			}

			$this->load->view($this->template, $data);

		}

	}

	public function process() {
		if ($this->require_min_level(1)) {

			$lang = $this->multilang->get_current();
			$this->load->model('user_model');
			//IF CURRENT USER IS OWNER
			if ($this->listing_model->is_owner($this->auth_user_id, $this->input->post('listing_id', true)))
				$this->load->library('form_validation');
			//DATES
			$interval = $this->input->post('listing_time');
			$date = new DateTime();
			$start_date = $date->format('Y-m-d H:i:s');
			$date->add(new DateInterval('P' . (int)$interval . 'D'));
			$end_date = $date->format('Y-m-d H:i:s');
			//USER DATA
			$user_data = $this->user_model->view_user_record($this->auth_user_id);
			$user_extended_data=json_decode($user_data->user_data);
			$listing_data = array(
				'item_name' => $this->input->post('listing_title', true),
				'item_content' => $this->input->post('listing_content', true),
				'item_budget' => $this->input->post('listing_budget', true),
				'item_budget_currency' => $this->input->post('listing_budget_currency', true),
				'lang_id' => $this->input->post('listing_language', true),
				'item_origin_id' => (isset($user_extended_data->user_country) && $user_extended_data->user_country>0)?$user_extended_data->user_country:'0',
				'item_portal'=>$lang['country_id'],
				'item_edit_datetime' => $start_date,
				'item_publish_datetime' => $start_date,
				'item_expired_datetime' => $end_date,
				'last_edit_by' => $this->auth_user_id,
				'item_published' => '0',
				'item_status' => '1'
			);
			$item_id = $this->input->post('listing_id', true);

			if ($this->listing_model->update($item_id, $listing_data)) {
				
				//SAVE COUNTRIES
				if(!$this->input->post('listing_countries')){
					$countries_data=array(
						'item_id'=>$item_id,
						'country_id'=>$this->input->post('listing_origin', true)
					);
					$this->listing_model->insert_country($countries_data);
				}
				else{
					//PURGE COUNTRIES FIRST
					$this->listing_model->purge_countries($item_id);
					//INSERT NEW
					$listing_countries=$this->input->post('listing_countries',true);
					foreach($listing_countries as $lc){
						$countries_data=array(
							'item_id'=>$item_id,
							'country_id'=>$lc
						);
						$this->listing_model->insert_country($countries_data);
					}
				}
				/**ADD NOTIFICATION AND SEND MAIL**/
            	$this->load->library('email');
				$this->config->load('email');
				//GENERATE LINK TO ITEM
				$item_link=base_url().'item/'.url_title($listing_data['item_name'], 'dash', TRUE).'/'.$item_id;
				//GET USER DATA FOR EMAIL
				$this->load->model('user_model');
            	$user_data=$this->user_model->view_user_record($this->auth_user_id);
				//GET MESSAGE AND SET LINK
				$message=str_replace('%link%',$item_link,lang('not_listing_created'));
            	$notif_data=array(
					'user_id'=>$this->auth_user_id,
					'type_id'=>2,
					'message'=>$message,
					'item_id'=>$item_id
				);
				//SAVE NOTIFICATION
				$this->main_model->add_notification($notif_data);
				//SEND MAIL
				$sent=$this->email->quick_email( array(
							'subject'        => lang('not_mail_title'),
							'email_template' => 'email_templates/notification',
							'from_name'      => 'no_reply_email_config',
							'template_data'  => array( 'message' => $message ),
							'to'             => $user_data->user_email
						) );
						
				//ADMIN MAIL
				$this->email->quick_email( array(
							'subject'        => 'Novi oglas na Buybooy portalu',
							'email_template' => 'email_templates/admin_notification',
							'from_name'      => 'no_reply_email_config',
							'template_data'  => array( 'message' => $message, 'user'=>$user_data,'listing'=>$listing_data, 'listing_id'=>$item_id),
							'to'             => 'davor@emicca.com,aleksandar@emicca.com,malavilarebeka@gmail.com'
						) );
				/**END NOTIFICATION**/
				
				
				$response = array(
					'status' => '1',
					'message' => lang('listing_updated')
				);
			} else {
				$response = array(
					'status' => '0',
					'message' => lang('listing_update_fail')
				);
			}

		} else {
			$response = array(
				'status' => '0',
				'message' => lang('listing_user_error')
			);
		}
		echo json_encode($response);
	}

	public function get_subcategories() {
		if ($this->require_min_level(1)) {

			$parent_id = $this->input->get('parent_id', true);
			//POSTAVLJANJE JEZIKA
			$data['lang'] = $this->multilang->get_current();
			$this->load->library('menu', array('lang' => $data['lang']));
			$data['subcats'] = $this->main_model->get_subcats($parent_id, $data['lang']['id']);
			$menu_items = $this->menu->generate_categories_paths();
			$breadcrumbs = $this->menu->getkeypath($menu_items, $parent_id);
			$subcats_list = $this->load->view('listing/ajax_view', $data, true);
			$response = array(
				'menu_level' => sizeof($breadcrumbs),
				'data' => $subcats_list
			);
			echo json_encode($response);

		}
	}

	public function get_filters() {
		if ($this->require_min_level(1)) {

			$cat_id = $this->input->get('cat_id', true);
			//POSTAVLJANJE JEZIKA
			$data['lang'] = $this->multilang->get_current();
			$this->load->library('menu', array('lang' => $data['lang']));
			$menu_items = $this->menu->generate_categories_paths();
			$breadcrumbs = $this->menu->getkeypath($menu_items, $cat_id);
			$data['filters'] = $this->main_model->get_category_properties_groups($breadcrumbs, $data['lang']['id']);
			$subcats_list = $this->load->view('listing/ajax_filters_view', $data, true);
			$response = array('data' => $subcats_list);
			echo json_encode($response);

		}
	}

	function upload() {
		//IF LOGGED IN
		if ($this->require_min_level(1)) {
			$listing_id = $this->input->get('listing_id', true);
			//IF OWNER OF LISTING
			if ($this->listing_model->is_owner($this->auth_user_id, $listing_id)) {
				if (!empty($_FILES)) {
					$file = $_FILES['file'];
					$tempFile = $file['tmp_name'];

					$path = $this->check_folder($listing_id);
					//GENERATE INDEX.HTML TO PREVENT DIRECT ACCESS
					$security_index = $path . '/index.html';
					if (!file_exists($security_index)) {
						$msg = "You don't have premissions to access this location.";
						file_put_contents($security_index, $msg);
					}
					$original_name = $file['name'];
					$fn = $this->safeName($file['name']);
					$file_path = $path . '/' . $fn;

					//FILE CHECK
					if (file_exists($file_path)) {
						$rand = rand(100, 999);
						$file_path = $path . '/' . $rand . $fn;
					}

					if (move_uploaded_file($file['tmp_name'], $file_path)) {
						//ONLY READ PREMISSIONS
						chmod($file_path, 0644);
						//DISTINCT DOCUMENTS AND PHOTOS
						$file_info = pathinfo($file_path);
						$extension = $file_info['extension'];
						$photos = array(
							'jpeg',
							'jpg',
							'png',
							'JPG',
							'JPEG'
						);
						$documents = array(
							'doc',
							'docx',
							'xls',
							'xlsx',
							'pdf',
							'txt'
						);
						if (is_int(array_search($extension, $photos))) {

							//RESIZE
							//BASIC CONF
							$img_config = array(
								'image_path' => $file_path,
								'delete_orig' => true,
								'quality' => 90,
							);
							//OUTPUT IMAGES
							$images = array(
								'large' => array('w' => 1000),
								'medium' => array(
									'w' => 227,
									'h' => 211
								),
								'medium2' => array(
									'w' => 558,
									'h' => 393
								),
								'small' => array(
									'w' => 86,
									'h' => 86
								)
							);
							//OSTAVLJAMO ORGINAL
							$paths = $this->resize_image($img_config, $images);
							//SAVE AS PHOTO
							$img_data = array(
								'item_id' => $listing_id,
								'name_hash' => $file_info['filename'],
								'paths' => json_encode($paths),
								'extension' => $extension,
								'upload_datetime' => date('Y-m-d H:i:s')
							);
							$this->listing_model->insert_image($img_data);

							//GENERAL RESPONSE
							$response = array(
								'status' => 1,
								'message' => 'File uploaded',
								'file_type' => 'image',
								'listing_id' => $listing_id,
								'file_path' => $paths,
								'file_info' => $file_info
							);
						} else if (is_int(array_search($extension, $documents))) {

							//SAVE AS DOCUMENT
							$doc_data = array(
								'item_id' => $listing_id,
								'name_hash' => $file_info['filename'],
								'document_name' => $original_name,
								'extension' => $extension,
								'upload_datetime' => date('Y-m-d H:i:s')
							);
							$this->listing_model->insert_document($doc_data);
							//GENERAL RESPONSE
							$response = array(
								'status' => 1,
								'message' => 'File uploaded',
								'file_type' => 'document',
								'listing_id' => $listing_id,
								'file_path' => $file_path,
								'file_info' => $file_info
							);
						}
						//IF NOT ALLOWED IMAGE OR DOCUMENT
						else {
							$response = array(
								'status' => 0,
								'message' => 'File type not allowed',
							);
							echo json_encode($response);
							die();
						}

					} else {
						$response = array(
							'status' => 0,
							'message' => 'Upload failed'
						);
					}
				}
			} else {
				$response = array(
					'status' => 0,
					'message' => "You don't have premission to upload"
				);
			}
		} else {
			$response = array(
				'status' => 0,
				'message' => "You don't have premission to upload"
			);
		}

		echo json_encode($response);
	}

	function list_attachments(){
		if ($this->require_min_level(1)) {
			$listing_id = $this->input->get('listing_id', true);
			if ($this->listing_model->is_owner($this->auth_user_id, $listing_id)) {
				$data['images']=$this->listing_model->get_images($listing_id);
				$data['documents']=$this->listing_model->get_documents($listing_id);
				$this->load->view('listing/ajax_attachments', $data);
			}
		}
	}

	function delete_file() {
		if ($this->require_min_level(1)) {
			$listing_id = $this->input->get('listing_id', true);
			$hash = $this->input->get('hash', true);
			//IF OWNER OF LISTING
			if ($this->listing_model->is_owner($this->auth_user_id, $listing_id)) {
				$type = $this->input->get('type');
				if ($type == 'image') {
					$image = $this->listing_model->get_image($listing_id, $hash);
					$files = json_decode($image['paths']);
					if (!empty($files)) {
						foreach ($files as $f) {
							if (file_exists(FCPATH . $f))
								unlink(FCPATH . $f);
						}
					}
					if ($this->listing_model->delete_image($listing_id, $hash)) {
						$response = array(
							'status' => 1,
							'message' => "Image deleted"
						);
					}
				} else if ($type == 'document') {
					$document = $this->listing_model->get_document($listing_id, $hash);
					$document_path = '/upload/' . $listing_id . '/' . $document['name_hash'] . '.' . $document['extension'];
					if (file_exists(FCPATH . $document_path)) {
						if (unlink(FCPATH . $document_path)) {
							if ($this->listing_model->delete_document($listing_id, $hash)) {
								$response = array(
									'status' => 1,
									'message' => "Document deleted"
								);
							}
						}
					}
				}
			} else {
				$response = array(
					'status' => 0,
					'message' => "You don't have premission to upload"
				);
			}

		} else {
			$response = array(
				'status' => 0,
				'message' => "You don't have premission to upload"
			);
		}

		echo json_encode($response);
	}

	public function all() {

		if ($this->require_min_level(1)) {

			//POSTAVLJANJE JEZIKA
			$data['lang'] = $this->multilang->get_current();
			//INICIJALIZIRAMO MENU LIB
			$this->load->library('menu', array('lang' => $data['lang']));
			//DOHVATIMO MENU ARRAY
			$data['menu_items'] = $this->menu->generate_categories_paths();
			$data['my_listings']=$this->listing_model->get_user_items($this->auth_user_id);
			$data['my_offers']=$this->listing_model->get_user_offers($this->auth_user_id);
			$data['watched_items']=$this->listing_model->get_user_watchlist($this->auth_user_id);	
			$data['notifications']=$this->main_model->get_notifications($this->auth_user_id);
			$data['title']='Moji oglasi';
			$data = array('content' => $this->load->view('user/my_listings_view', $data, TRUE), );

			$this->load->view($this->template, $data);

		}

	}

	public function offers() {

		if ($this->require_min_level(1)) {

			//POSTAVLJANJE JEZIKA
			$data['lang'] = $this->multilang->get_current();
			//INICIJALIZIRAMO MENU LIB
			$this->load->library('menu', array('lang' => $data['lang']));
			//DOHVATIMO MENU ARRAY
			$data['menu_items'] = $this->menu->generate_categories_paths();
			$data['my_offers']=$this->listing_model->get_user_offers($this->auth_user_id);
			$data['my_listings']=$this->listing_model->get_user_items($this->auth_user_id);
			$data['watched_items']=$this->listing_model->get_user_watchlist($this->auth_user_id);	
			$data['notifications']=$this->main_model->get_notifications($this->auth_user_id);
			$data = array('content' => $this->load->view('user/my_offers_view', $data, TRUE), );

			$this->load->view($this->template, $data);

		}

	}

	public function watching() {

		if ($this->require_min_level(1)) {

			//POSTAVLJANJE JEZIKA
			$data['lang'] = $this->multilang->get_current();
			//INICIJALIZIRAMO MENU LIB
			$this->load->library('menu', array('lang' => $data['lang']));
			//DOHVATIMO MENU ARRAY
			$data['menu_items'] = $this->menu->generate_categories_paths();
			$data['my_offers']=$this->listing_model->get_user_offers($this->auth_user_id);
			$data['my_listings']=$this->listing_model->get_user_items($this->auth_user_id); 
			$data['watched_items']=$this->listing_model->get_user_watchlist($this->auth_user_id);		   
	        $data['notifications']=$this->main_model->get_notifications($this->auth_user_id); 
			$data = array('content' => $this->load->view('user/my_watchlist_view', $data, TRUE), );

			$this->load->view($this->template, $data);

		}

	}

	//PRIVATE FUNCTIONS

	//UPLOAD
	private function check_folder($path) {
		$real_path = 'upload/' . $path;
		if (is_dir($real_path)) {
			return $real_path;
		} else {
			//ONLY WEB SERVER CAN ACCESS 0700
			if (mkdir($real_path, 0755, true))
				return $real_path;
			else
				return FALSE;
		}

	}

	private function safeName($string) {
		$path_info = pathinfo($string);
		$extension = $path_info['extension'];
		$name = $path_info['filename'];
		$not_allowed = array(
			'php',
			'html',
			'js',
			'jsp'
		);
		if (is_int(array_search($extension, $not_allowed))) {
			die('FILE TYPE NOT ALLOWED');
		}
		// $string = preg_replace('/[^\\pL\d]+/u', '_', $name);
		// $string = trim($string, '_');
		// $string = iconv('utf-8', 'us-ascii//TRANSLIT', $string);
		// $string = strtolower($string);
		// $string = preg_replace('/[^-\w]+/', '', $string);
		$stamp = time();
		$string = md5($name . $stamp);
		return $string . '.' . $extension;
	}

	private function resize_image($img_config = array(), $images = array()) {
		$this->load->library('image_moo');
		//DEFAULT CONFIG
		$image_path = $img_config['image_path'];
		unset($img_config['image_path']);

		if (empty($img_config)) {
			$img_config = array(
				'delete_orig' => true,
				'quality' => 90
			);
		}
		if (empty($images)) {
			$images = array(
				'large' => array('w' => 1000),
				'medium' => array('w' => 600),
				'small' => array('w' => 200)
			);
		}

		//GET IMAGE INFO
		$file_info = pathinfo($image_path);

		foreach ($images as $key => $image) {
			if (!isset($image['quality']))
				$quality = $img_config['quality'];
			else
				$quality = $image['quality'];

			//AKO JE POSTAVLJENA SAMO SIRINA SAMO RADI RESIZE
			if (isset($image['w']) && !isset($image['h']))
				$this->image_moo->set_jpeg_quality($quality)->load($image_path)->resize($image['w'])->save_pa('', '_' . $key, TRUE);
			//AKO SU POSTAVLJENI I SIRINA I VISINA RADI RESIZE CROP
			if (isset($image['w']) && isset($image['h']))
				$this->image_moo->set_jpeg_quality($quality)->load($image_path)->resize_crop($image['w'], $image['h'])->save_pa('', '_' . $key, TRUE);

			$paths[$key . '_image'] = $file_info['dirname'] . '/' . $file_info['filename'] . '_' . $key . '.' . $file_info['extension'];
		}

		//DELETE ORIGINAL IMAGE
		if ($img_config['delete_orig'])
			unlink($image_path);
		else
			$paths['original'] = $image_path;

		return $paths;
	}

	//CHECK IF ALL PROFILE IS FILLED
	private function _check_profile($user_id) {
		$this->load->model('user_model');
		$user_data=$this->user_model->view_user_record($user_id);
		if ($user_data->user_data == '')
			return FALSE;
		else
			return TRUE;
	}

}
?>