<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Category extends MY_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('main_model');
        $this->load->helper('language');
        $this->load->helper('url');
        $this->load->helper('links');
        $this->load->helper('text');
        $this->load->library('multilang', array('default_lang' => 'hr', 'multilang' => true));
		$this->load->library('pagination');
		//$this->output->enable_profiler(TRUE);
    }

    public function index() {
        
        $this->is_logged_in();
        //POSTAVLJANJE JEZIKA
        $data['lang'] = $this->multilang->get_current();
		if(!isset($data['lang']['country_id']))
			$country_id=null;
		else
			$country_id=$data['lang']['country_id'];
		
		if($this->input->get('ending_soon'))
			$sort=array('item_expired_datetime'=>'asc');
		else
			$sort=array('item_publish_datetime'=>'desc');
        //INICIJALIZIRAMO MENU LIB
        $this->load->library('menu', array('lang' => $data['lang']));
        //DOHVATIMO MENU ARRAY
        $data['menu_items'] = $this->menu->generate_categories_paths(NULL);

        $id = $this->input->get('category_id');
		
		//PAGINACIJA
		$config['base_url'] = base_url().'category/index';
		$config['suffix'] = '?' . http_build_query($_GET, '', "&");
		$config['first_url'] = $config['base_url'].'?'.http_build_query($_GET);
		$config['uri_segment'] = 3;
		$config['per_page'] = 10; 
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['prev_tag_open'] = '<li class="prev">';
        $config['prev_tag_close'] = '</li>';
        $config['prev_link'] = 'PREV';
        $config['next_tag_open'] = '<li class="next">';
        $config['next_tag_close'] = '</li>';
        $config['next_link'] = 'NEXT';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="current"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['first_link'] = 'FIRST';
        $config['first_tag_open'] = '<li class="first">';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = 'LAST';
        $config['last_tag_open'] = '<li class="last">';
        $config['last_tag_close'] = '</li>';
		
        if ($id && $id != 'all') {
            $data['submenu_items'] = $this->main_model->get_subcats($id, $data['lang']['id']);
            //TRENUTNI ID
            $data['category_info'] = $this->main_model->get_cat_info($id, $data['lang']['id']);
            //PROVJERA BREADCRUMBSA
            $data['breadcrumbs'] = $this->menu->getkeypath($data['menu_items'], $id);
            $data['category_id'] = $id;
            //FILTRI
            $data['filters'] = $this->main_model->get_category_properties_groups($data['breadcrumbs'],$data['lang']['id']);
        } else {
            $data['category_id'] = 'all';
        }
        //ITEMS IN CATEGORY
        if ($this->input->get('filter')) {
            $group_count = 0;
            $filter = array();
            $raw_filters = $this->input->get('filter', true);
            foreach ($raw_filters as $rf) {
                $group_count++;
                foreach ($rf as $key => $sf) {
                    $filter[] = $key;
                }
            }
			$config['total_rows'] = $this->main_model->count_by_filter($country_id,$this->menu->children,$filter, $group_count,null);
            $data['items'] = $this->main_model->get_by_filter($country_id,$this->menu->children,$filter, $group_count, null,$sort,$config['per_page'],$this->uri->segment($config['uri_segment'],0));
	    } else{
        	
        	$config['total_rows'] = $this->main_model->count_items($country_id,$this->menu->children,null);
			$data['items'] = $this->main_model->get_items($country_id,$this->menu->children,null,$sort,$config['per_page'],$this->uri->segment($config['uri_segment'],0));
        }
		$this->pagination->initialize($config); 
		
		$data['pagination']=$this->pagination->create_links();
        //TRENUTNA POZICIJA
        $data['nav_item'] = array('path' => 'category');
        $data['content'] = $this->load->view('main/category_view', $data, TRUE);

        $this->load->view($this->template, $data);
    }


}
