<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Users extends MY_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('user_model');
        $this->load->model('admin/general_model');
        //$this->lang->load('admin', $this->config->item('admin_lang'));
        $this->load->helper('language');
        $this->load->helper('url');
        $this->load->library('form_validation');
    }

    public function index($lang = 1) {

        if ($this->require_role_admin('admin')) {
            $data['lang'] = $this->general_model->get_lang($lang);
            $this->lang->load('admin', $data['lang']['abbr']);
            //ADMIN VIDI SVE
            $this->db->from('users');
            if ($this->auth_role != 'admin')
                $this->db->where('user_level <', $this->auth_level);
            $count = $this->db->count_all_results();

            $this->db->select('user_name,user_email,user_banned,user_level,user_id');
            if ($this->auth_role != 'admin')
                $this->db->where('user_level <', $this->auth_level);
            $this->db->from('users');
            $q = $this->db->get();
            $data['query'] = $q->result();

            $data['content'] = $this->load->view('admin/user/main_view', $data, TRUE);

            $this->load->view($this->admin_template, $data);
        }

    }

    public function view($lang = 1) {

        if ($this->require_role_admin('admin')) {

            $user_id = $this->uri->segment(5);
            $data['user'] = $this->user_model->view_user_record($user_id);
            $data['lang'] = $this->general_model->get_lang($lang);
			$data['sys_countries'] = $this->general_model->get_sys_countries();
			$data['current_countries']=$this->general_model->get_manager_countries($user_id);
            //AKO JE EDITOR ADMIN ILI KORISNIK NIZE RAZINE OD EDITORA DOPUSTA SE PRISTUP
            if ($user_id == 0 || (isset($data['user']->user_level) && $this->auth_level > $data['user']->user_level) || $this->auth_role == 'admin')
                $data['content'] = $this->load->view('admin/user/single_view', $data, TRUE);
            else
                $data['content'] = 'Nemate pravo prisupa ovom korisniku';
            $this->load->view($this->admin_template, $data);
        }

    }

    public function process() {
        if ($this->require_role_admin('admin')) {

            $this->form_validation->set_rules('first_name', 'Ime', 'trim|required|xss_clean');
            $this->form_validation->set_rules('last_name', 'Prezime', 'trim|required|xss_clean');

            if ($this->input->post('user_id') == 0) {
                $this->form_validation->set_rules('user_name', 'Korisničko ime', 'trim|required|xss_clean|is_unique[users.user_name]');
                $this->form_validation->set_rules('user_email', 'E-mail', 'trim|required|valid_email|xss_clean|is_unique[users.user_email]');
            } else if ($this->input->post('user_id') > 0) {
                $this->form_validation->set_rules('user_email', 'E-mail', 'trim|required|valid_email|xss_clean|external_callbacks[model,formval_callbacks,_update_email,update_user]');
            }

            if ($this->input->post('user_pass') != '') {
                $this->form_validation->set_rules('user_pass', 'Lozinka', 'trim|matches[user_pass_confirm]|external_callbacks[model,formval_callbacks,_check_password_strength,FALSE]');
                $this->form_validation->set_rules('user_pass_confirm', 'Potvrda lozinke', 'trim|required|xss_clean');
            }
            if ($this->form_validation->run() == TRUE) {

                if ($this->input->post('user_id') == 0) {
                    //KREIRANJE KORISNIKA
                    //PROVJERA RAZINE KOJA SE ZELI DODATI, blokira ako se zeli kreirati razina visa od vlastite
                    if ($this->auth_level < $this->authentication->levels[$this->input->post('user_level')]) {
                        $response = array('response' => 'Nemate pravo pristupa', 'success' => 0);
                        echo json_encode($response);
                        die();
                    }

                    if ($this->input->post('user_pass') == '') {
                        $this->load->helper('random_pass');
                        $pass = get_random_password(8, 10, true, true);

                    } else {
                        $pass = $this->input->post('user_pass');
                    }
                    $files = array(
                    	'user_name' => $this->input->post('user_name'), 
                    	'user_pass' => $pass, 
                    	'user_email' => $this->input->post('user_email'), 
                    	'first_name' => $this->input->post('first_name'), 
                    	'last_name' => $this->input->post('last_name'), 
                    	'user_banned' => $this->input->post('user_banned')?'0':'1'
						);

                    if ($this->user_model->create_user($this->input->post('user_level'), $files)) {
						
                        //POSALJI MAIL S PODACIMA
                        if ($this->send_mail($files))
                            $mail_sent = 1;
                        else
                            $mail_sent = 0;
                        //DOHVATI PODATKE ZBOG ID
                        $user_data = $this->user_model->view_user_record_byusername($files['user_name']);
						//SET PORTALS IF MANAGER
                    	if($this->input->post('user_level')=='manager'){
                    		$countries=$this->input->post('assig_country');
							if(!empty($countries)){
							foreach($countries as $key=>$c){
								$c_data=array(
									'user_id'=>$user_data->user_id,
									'country_id'=>$key
								);
								$this->_set_manager_portals($c_data);
							}
							}
                    	}
						//RESPONSE
                        $response = array('response' => 'Korisnik je uspješno kreiran!', 'user_id' => $user_data->user_id, 'user_pass' => $pass, 'success' => 1, 'mail_sent' => $mail_sent);
                        echo json_encode($response);

                    } else {
                        $response = array('response' => "Desila se greška kod spremanja!", 'success' => 0);
                        echo json_encode($response);
                    }
                } else if ($this->input->post('user_id') > 0) {
                    //UPDATE KORISNIKA
                    //TRENUTNI PODACI
                    $user = $this->user_model->view_user_record($this->input->post('user_id'));
                    //PROVJERA RAZINE KOJA SE ZELI DODAT, blokira ako se zeli staviti razina visa od vlastite ili smanjiti razina korisnika koji je visi od editora
                    if ($this->auth_level < $this->authentication->levels[$this->input->post('user_level')] || $user->user_level > $this->auth_level) {
                        $response = array('response' => 'Nemate pravo pristupa', 'success' => 0);
                        echo json_encode($response);
                        die();
                    }

                    $files = array(
                    	'user_email' => $this->input->post('user_email'), 
                    	'user_banned' => $this->input->post('user_banned')?'0':'1', 
                    	'user_level' => $this->input->post('user_level'), 
						);
                    if ($this->input->post('user_pass') != '' && $this->input->post('user_pass_confirm') != '') {
                        $files['user_pass'] = $this->input->post('user_pass');
                    }

                    $profile_files = array(
                    	'first_name' => $this->input->post('first_name'), 
                    	'last_name' => $this->input->post('last_name')
						);
                    if ($this->user_model->update_user($this->input->post('user_level'), $this->input->post('user_id'), 'update_user', $files, $profile_files)) {
						//SET PORTALS IF MANAGER
                    	if($this->input->post('user_level')=='manager'){
                    		$this->_purge_manager_portals($this->input->post('user_id'));
                    		$countries=$this->input->post('assig_country');
							if(!empty($countries)){
								foreach($countries as $key=>$c){
								$c_data=array(
									'user_id'=>$this->input->post('user_id'),
									'country_id'=>$key
								);
								$this->_set_manager_portals($c_data);
								}
							}
							
                    	}

                        $response = array('response' => 'Korisnik je uspješno editiran!', 'success' => 1);
                        echo json_encode($response);

                    } else {
                        $response = array('response' => "Desila se greška kod spremanja!", 'success' => 0);
                        echo json_encode($response);
                    }
                }
                //UKOLIKO JE PROSLJEĐEN NEISPRAVAN PARAMETAR
                else {
                    $response = array('response' => "Traženu akciju nije moguće provesti!", 'success' => 0);
                    echo json_encode($response);

                }
            }
            //UKOLIKO NE PROLAZI VALIDACIJA
            else {
                $response = array('response' => validation_errors(), 'success' => 0);
                echo json_encode($response);
            }
        }

    }

    public function delete($id) {

        if ($this->require_role_admin('admin')) {
            if ($this->user_model->delete_user($id, $this->auth_level)) {
                $response = array('response' => 'Korisnik je obrisan', 'success' => 1);
            } else {
                $response = array('response' => 'Korisnik nije obrisan', 'success' => 0);

            }

            echo json_encode($response);
        }

    }

    private function send_mail($data) {
        ///EMAIL TO USER
        $this->load->library('email');
        $html_email = $this->load->view('email_templates/created_user_view', $data, true);

        $config['charset'] = 'utf-8';
        $config['wordwrap'] = TRUE;
        $config['mailtype'] = 'html';

        //GET EMAIL LIST
        $emails = $data['user_email'];

        $this->email->initialize($config);
        $this->email->from('noreply@' . $this->config->item('domain'), $this->config->item('domain'));
        $this->email->to($emails);
        $this->email->subject('Obavijest o kreiranju korisničkog računa.');
        $this->email->message($html_email);

        error_reporting(0);

        if ($this->email->send()) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    public function datagrid() {

        if ($this->require_role_admin('admin')) {
            //ADMIN VIDI SVE
            $this->db->from('users');
            if ($this->auth_role != 'admin')
                $this->db->where('user_level <', $this->auth_level);
            $count = $this->db->count_all_results();

            $this->db->select('user_name,user_email,user_banned,user_level,user_id');
            if ($this->auth_role != 'admin')
                $this->db->where('user_level <', $this->auth_level);
            $this->db->from('users');
            $q = $this->db->get();
            $query = $q->result();

            $x = 0;

            $datagrid_data = '{ "aaData": [';

            foreach ($query as $row) {
                $x++;

                $roles = $this->config->item('levels_and_roles');

                if ($x != $count) {
                    $datagrid_data .= '["' . $row->user_name . '","' . $row->user_email . '","' . $row->user_banned . '","' . $roles[$row->user_level] . '","' . $row->user_id . '","' . $row->user_id . '"],';
                } else {
                    $datagrid_data .= '["' . $row->user_name . '","' . $row->user_email . '","' . $row->user_banned . '","' . $roles[$row->user_level] . '","' . $row->user_id . '","' . $row->user_id . '"]';
                }

            }

            $datagrid_data .= '] }';

            echo $datagrid_data;

        }

    }

//CUSTOM
	function _purge_manager_portals($user_id){
		$this->db->from('manager_countries');
		$this->db->where('user_id',$user_id);
		return $this->db->delete();
	}
	function _set_manager_portals($data){
		return $this->db->insert('manager_countries', $data);
	}

}
