<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Support extends MY_Controller {
	
	public $advertising_key='sa314n1hfjalfhhlgvu3';

    public function __construct() {
        parent::__construct();
        $this->load->model('admin/general_model');
        $this->load->model('admin/advertising_model');
        $this->load->model('admin/categories_model');
        //OVAJMODEL ISPOD MOŽEMO IZBACITI KAD SE NAPRAVI U ADVETISING
        $this->load->model('admin/listings_model');
        $this->load->model('user_model');
        $this->load->library('multilang', array('default_lang' => 'hr', 'multilang' => false));
        $this->load->library('encrypt');
        $this->load->helper('language');
    }

    public function tickets() {
        if ($this->require_role_admin('admin,manager')) {
            $data['lang'] = $this->multilang->get_current();
            //Active
            if ($this->input->get('active') != '')
                $active = $this->input->get('active', true);
            else
                $active = null;
            //Type
            if ($this->input->get('type') != 0)
                $type = $this->input->get('type', true);
            else
                $type = NULL;
            //Country
            if ($this->input->get('country') != 0)
                $country = $this->input->get('country', true);
            else
                $country = NULL;
			
			$count = $this->advertising_model->count_clients($country, $type, $active);
            //DEFINIRAMO LISTU ATRIBUTA KOJE ŽELIMO, PONOVLJENI ATRIBUTI TREBAJU IMATI DRUGACIJI ALIAS, DEFAULT LANG 1
            $param_list = array('client_name', 'contact_data','active','added_datetime', 'c.name as country_name', 'active', 'acl.id as edit_id', 'acl.id as delete_id');
            $query = $this->advertising_model->get_clients_datagrid($param_list, $country, $type, $active);
            if (!empty($query)) {
                foreach ($query as $q) {
                    //OBLIKOVANJE PODATAKA ZA ISPIS
                    $q['client_name'] = htmlspecialchars($q['client_name']);
                    $q['added_datetime'] = date('d.m.Y.', strtotime($q['added_datetime']));
                }
            }
			$data['clients']=$query;
            //SET MENU AND GET CLIENTS
            $data['params']['country'] = $country;
            $data['params']['active'] = $active;
            $data['params']['type'] = $type;
            $data = array('content' => $this->load->view('admin/support/tickets_main_view', $data, TRUE));
            $this->load->view($this->admin_template, $data);
        }
    }

    public function view_client() {
        if ($this->require_role_admin('admin,manager')) {
        	$this->load->library('encrypt');
            //GET LANG DATA AND SET MENU
            $data['lang'] = $this->multilang->get_current();
			
			//Type
            if ($this->input->get('type') != 0)
                $type = $this->input->get('type', true);
            else
                $type = NULL;
            //Country
            if ($this->input->get('country') != 0)
                $country = $this->input->get('country', true);
            else
                $country = NULL;
			//ID
            if ($this->input->get('id') != 0)
                $id = $this->input->get('id', true);
            else
                $id = NULL;
			
			if(is_null($id)){
				$data=array(
					'client_name'=>'new client',
					'added_datetime'=>date('d-m-Y h:i:s'),
					'country'=>$country,
					'client_type'=>$type
					);
				if($id=$this->advertising_model->insert_client($data)){
					 redirect('/admin/advertising/view_client?id='.$id, 'refresh');
				}
				else{
					redirect('/admin/advertising'.($param_list=http_build_query($params))?'?'.$param_list:null, 'refresh');
				}
			}
			else{
				$data['query'] = $this->advertising_model->get_client($id);
				$data['campaigns']=$this->advertising_model->get_campaigns_datagrid('*',$id);
			}
            
            
            //PRIVREMENO OD TU
            
            if($this->auth_role =='manager'){
                $current_countries=$this->general_model->get_manager_countries($this->auth_user_id);
                if(!empty($current_countries)){
                    $country=array();
                    foreach($current_countries as $cc){
                        $country[]=$cc['country_id'];
                    }
                }
            }
                
            else 
                $country=null;
            
            
            //DO TU
            
            
            
            
            //UTIL
            $data['countries'] = $this->general_model->list_countries();
            $data = array('content' => $this->load->view('admin/advertising/clients_single_view', $data, TRUE));
            $this->load->view($this->admin_template, $data);
        }
    }
    

    public function general() {
        if ($this->require_role_admin('admin,manager')) {
            $data['lang'] = $this->multilang->get_current();
            //MAIN FILTER BY ACTIVE STATUS
            //ACTIVE
            if ($this->input->get('active') !== FALSE)
                $active = $this->input->get('active', true);
            else
                $active = 'all';
            //CLIENT ID
            if ($this->input->get('client_id') != 0)
                $client = $this->input->get('client_id', true);
            else
                $client = NULL;
            //SET MENU AND GET CAMPAIGNS
            $data['active'] = $active;
            $data['client'] = $client;
            $data = array('content' => $this->load->view('admin/support/general_main_view', $data, TRUE));
            $this->load->view($this->admin_template, $data);
        }
    }

    public function view_campaign() {
        if ($this->require_role_admin('admin,manager')) {
            //GET LANG DATA AND SET MENU
            $data['lang'] = $this->multilang->get_current();
            //GET ID AND DATA
            $id = $this->input->get('id', true);
            
            
            //PRIVREMENO OD TU
            if($this->auth_role =='manager'){
                $current_countries=$this->general_model->get_manager_countries($this->auth_user_id);
                if(!empty($current_countries)){
                    $country=array();
                    foreach($current_countries as $cc){
                        $country[]=$cc['country_id'];
                    }
                }
            }
                
            else 
                $country=null;
            
            $data['count_listings']=$this->_count_listings($country);
            //DO TU
            
            
            
            //UTIL
            $data['countries'] = $this->general_model->list_countries();
            $data = array('content' => $this->load->view('admin/advertising/campaign_single_view', $data, TRUE));
            $this->load->view($this->admin_template, $data);
        }
    }


/* TEMP START */
	function _count_listings() {
		$count_listings = $this->listings_model->stat_count_listings_by_date();
		//echo $this->db->last_query();
		$tmp_count = array();
		foreach ($count_listings as $cl) {
			$tmp_count[] = '[' . (strtotime($cl['date']) * 1000) . ',' . $cl['num'] . ']';
		}
		$tmp_count = implode(',', $tmp_count);
		$tmp_count = '[' . $tmp_count . ']';
		return $tmp_count;
	}

	/* TEMP END */
	
	
	

    public function process_client() {
        if ($this->require_role_admin('admin,manager')) {
        	$this->load->library('encrypt');
			$id=$this->input->post('client_id',true);
			$contact_data=$this->input->post('cd',true);
			$base_data=array(
				'client_name'=>$this->input->post('client_name',true),
				'country'=>$this->input->post('country',true),
				'contact_data'=> $this->encrypt->encode(json_encode($contact_data), md5($this->advertising_key.$id)),
				'contact_email'=>$this->input->post('contact_email',true)
			);
			
			if($this->advertising_model->update_client($id,$base_data)){
				$response=array(
						'main_data'=>1,
						'response' => 'Client updated!'
					);
			}
			else{
				$response=array(
						'main_data'=>0,
						'response' => 'Client not updated!'
					);
			}
		//OUTPUT RESULT
		echo json_encode($response);
		}
    }

    public function process_campaign() {
        if ($this->require_role_admin('admin,manager')) {

        }
    }
	
	function send_mail($user_id,$message){
		if ($this->require_role_admin('admin,manager')) {
			$this->load->library('email');
			$this->config->load('email');
			
			$this->load->model('user_model');
	        $user_data=$this->user_model->view_user_record($user_id);
			
			//SEND MAIL
			$sent=$this->email->quick_email( array(
						'subject'        => lang('not_mail_title'),
						'email_template' => 'email_templates/notification',
						'from_name'      => 'no_reply_email_config',
						'template_data'  => array( 'message' => $message ),
						'to'             => $user_data->user_email
					) );
					
			if($sent){
				$response = array(
					'status' => '1',
					'message' => 'Message sent'
				);
			}
			else{
				$response = array(
					'status' => '0',
					'message' => 'Message not sent'
				);
			}
			echo json_encode($response);
        }
	}

    /*
     * DOHVAĆANJE PODATAKA ZA PREGLED U DATAGRIDU
     */
    public function clients_datagrid() {
        //Active
        if ($this->input->get('active') != '')
            $active = $this->input->get('active', true);
        else
            $active = null;
        //Type
        if ($this->input->get('type') != 0)
            $type = $this->input->get('type', true);
        else
            $type = NULL;
        //Country
        if ($this->input->get('country') != 0)
            $country = $this->input->get('country', true);
        else
            $country = NULL;

        if ($this->require_role_admin('admin,manager')) {
            //COUNT SE PROVODI PO DEFAULT JEZIKU 1
            $count = $this->advertising_model->count_clients($country, $type, $active);
            //DEFINIRAMO LISTU ATRIBUTA KOJE ŽELIMO, PONOVLJENI ATRIBUTI TREBAJU IMATI DRUGACIJI ALIAS, DEFAULT LANG 1
            $param_list = array('client_name as client_name', 'added_datetime', 'c.name', 'active', 'acl.id as edit_id', 'acl.id as delete_id');
            $query = $this->advertising_model->get_clients_datagrid($param_list, $country, $type, $active);
            $data = array();
            if (!empty($query)) {
                foreach ($query as $q) {
                    //OBLIKOVANJE PODATAKA ZA ISPIS
                    $q['client_name'] = htmlspecialchars($q['client_name']);
                    $q['added_datetime'] = date('d.m.Y.', strtotime($q['added_datetime']));
                    $data['aaData'][] = array_values($q);
                }
            } else {
                $data['aaData'] = array();
            }
            echo json_encode($data);

        }

    }

    public function campaigns_datagrid() {
        //client
        if ($this->input->get('client') != '')
            $client = $this->input->get('client', true);
        else
            $client = null;

        if ($this->require_role_admin('admin,manager')) {
            //COUNT SE PROVODI PO DEFAULT JEZIKU 1
            $count = $this->advertising_model->count_campaigns($client);
            //DEFINIRAMO LISTU ATRIBUTA KOJE ŽELIMO, PONOVLJENI ATRIBUTI TREBAJU IMATI DRUGACIJI ALIAS, DEFAULT LANG 1
            $param_list = array('name', 'client_name', 'start_datetime', 'end_datetime', 'acm.id as edit_id', 'acm.id as delete_id');
            $query = $this->advertising_model->get_campaigns_datagrid($param_list, $client);
            $data = array();
            if (!empty($query)) {
                foreach ($query as $q) {
                    //OBLIKOVANJE PODATAKA ZA ISPIS
                    $q['name'] = htmlspecialchars($q['name']);
                    $q['client_name'] = htmlspecialchars($q['client_name']);
                    $q['start_datetime'] = date('d.m.Y.', strtotime($q['start_datetime']));
                    $q['end_datetime'] = date('d.m.Y.', strtotime($q['end_datetime']));
                    $data['aaData'][] = array_values($q);
                }
            } else {
                $data['aaData'] = array();
            }
            echo json_encode($data);

        }

    }

}
