<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Pages extends MY_Controller {


	public function __construct() {
		parent::__construct();
		$this->load->model('admin/general_model');
		$this->load->model('admin/pages_model');
		$this->load->model('user_model');
		$this->load->library('multilang', array('default_lang' => 'hr', 'multilang'=>false));
		$this->load->library('encrypt');
		$this->load->helper('language');
	}

	public function index() {
	if ($this->require_role_admin('admin')) {
			$data['lang']=$this->multilang->get_current();
			$parent_id=$this->input->get('parent_id',true);
			
			//SET MENU AND GET LISTINGS IN CAT
			$this->load->library('menu',array('lang'=>$data['lang'],'parent'=>NULL));
			//$data['listings']=$this->listings_model->get_listings($category_id,$published);
			$data['menu_items']=$this->menu->generate_categories_paths(NULL);
			
			if($parent_id>0)
				$data['breadcrumbs']=$this->menu->getkeypath($data['menu_items'],$parent_id);
			$data['parent_id']=$parent_id;
			
			$count = $this->pages_model->count_pages($parent_id);
			//DEFINIRAMO LISTU ATRIBUTA KOJE ŽELIMO, PONOVLJENI ATRIBUTI TREBAJU IMATI DRUGACIJI ALIAS, DEFAULT LANG 1
			$param_list=array('sys_name','id as level_id','id as edit_id','id as delete_id');
			$data['query'] = $this->pages_model->get_pages_datagrid($param_list,$parent_id);
			
			
			$data = array(
				'content' => $this->load->view('admin/pages/main_view', $data, TRUE)
			);
			//$data['lang']=$this->general_model->get_lang(1);
			$this->load->view($this->admin_template, $data);
		}
	}
	
	public function add_new(){
		if ($this->require_role_admin('admin')) {
			
		$parent_id=(int)$this->input->get('parent_id',true);
		$data=array(
			'sys_name'=>'new page',
			'parent_id'=>$parent_id
			);
		if($id=$this->pages_model->insert($data)){
			 redirect('/admin/pages/view/?id='.$id, 'refresh');
		}
		else{
			redirect('/admin/pages?parent_id='.$parent_id, 'refresh');
		}
		
		}
	}

	public function remove(){
			if ($this->require_role_admin('admin')) {
			$id=$this->input->get('id');
			$page=$this->pages_model->get_page($id);
			if($this->pages_model->delete($id)){
				redirect('/admin/pages?parent_id='.$page['parent_id'], 'refresh');
			}
			else{
				redirect('/admin/pages?parent_id='.$page['parent_id'], 'refresh');
			}
			echo json_encode($response);
			}
		}
	
	
	public function view() {
	if ($this->require_role_admin('admin')) {
		//GET LANG DATA AND SET MENU
			$data['lang']=$this->multilang->get_current();
			$this->load->library('menu',array('lang'=>$data['lang'],'parent'=>NULL));
			//COUNTRIES
			$country=$this->general_model->user_countries($this->auth_role,$this->auth_user_id);
			$languages=
			//END COUNTRIES
			//GET ID AND DATA
			$id=$this->input->get('id',true);
			$data['page']=$this->pages_model->get_page($id);
			$data['lang_data']=$this->pages_model->get_page_trans_bylang($id,$country);
			//UTIL
			$data['countries']=$this->general_model->list_countries();
			$data = array(
				'content' => $this->load->view('admin/pages/single_view', $data, TRUE)
			);
			$this->load->view($this->admin_template, $data);
		}
	}


	public function process(){
		if ($this->require_role_admin('admin')) {
			
			$base_data=array(
				'sys_name'=>$this->input->post('sys_name',true)
			);
			$id=$this->input->post('page_id');
			$lang_title=$this->input->post('country_title',true);
			$lang_content=$this->input->post('country_content',true);
			
			if($this->pages_model->update($id,$base_data)){
				$response['main_data']=1;
				foreach($lang_title as $key=>$l){
					$lang_data=array(
						'title'=>$l,
						'content'=>$lang_content[$key],
						'page_id'=>$id,
						'country'=>$key,
						'last_edited_by'=>$this->auth_user_id,
						'last_edit_timestamp'=>date('Y-m-d h:i:s')
						
					);
				if($this->pages_model->check_country($id,$key)){
					if($this->pages_model->update_data($id,$key,$lang_data)){
						$response['lang_data']=1;
					}
					else{
						$response['lang_data']=0;
					}
				}
				else{
					if($this->pages_model->insert_data($lang_data)){
						$response['lang_data']=1;
					}
					else{
						$response['lang_data']=0;
					}
				}
					
				}
			}
			else{
				$response['main_data']=0;
			}
		if($response['lang_data']==1 && $response['main_data']==1)
			$response['response']='Page updated';
		else 
			$response['response']='Page not updated';
		//OUTPUT RESULT
		echo json_encode($response);
		}
	}

	/*
	 * DOHVAĆANJE PODATAKA ZA PREGLED U DATAGRIDU
	 */
	public function datagrid() {
			//CATEGORY ID
			if($this->input->get('parent_id')!=0)
				$parent_id=$this->input->get('parent_id',true);
			else
				$parent_id=NULL;
			
		if ($this->require_role_admin('admin')) {
			//COUNT SE PROVODI PO DEFAULT JEZIKU 1
			$count = $this->pages_model->count_pages($parent_id);
			//DEFINIRAMO LISTU ATRIBUTA KOJE ŽELIMO, PONOVLJENI ATRIBUTI TREBAJU IMATI DRUGACIJI ALIAS, DEFAULT LANG 1
			$param_list=array('sys_name','id as level_id','id as edit_id','id as delete_id');
			$query = $this->pages_model->get_pages_datagrid($param_list,$parent_id);
			$data=array();
			if(!empty($query)){
			foreach($query as $q){
				//OBLIKOVANJE PODATAKA ZA ISPIS
				$q['sys_name']=htmlspecialchars($q['sys_name']);
				$data['aaData'][]=array_values($q);
			}
			}
			else{
				$data['aaData']=array();
			}
			echo json_encode($data);

		}

	}

}
