<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Content extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model('admin/content_model');
		$this->load->model('admin/general_model');
		$this->lang->load('admin', $this->config->item('admin_lang'));
		$this->load->helper('language');
		$this->load->helper('url');

	}
	
	/*
	 * PREGLED SVIH SADRZAJA
	 */

	public function index($lang=1,$content_type = 1, $parent_id = 0) {

		if ($this->require_role_admin('admin,manager')) {
			
			$data['content_type'] = $content_type;
			$data['parent_id'] = $parent_id;
			//LOADA JEZIK
			$data['lang']=$this->content_model->get_lang($lang);
			$this->lang->load('admin', $data['lang']['abbreviation']);
			$data['content_type_data']=$this->content_model->get_content_type_data($content_type);
			$data['content'] = $this->load->view('admin/content/main_view', $data, TRUE);

			$this->load->view($this->admin_template, $data);
		}

	}
	
	/*
	 * PREGLED I KREIRANJE POJEDINOG SADRZAJA
	 */

	public function view($lang=1,$content_type = 1, $parent_id = 0,$id=0) {

		if ($this->require_role_admin('admin,manager')) {


			$data['content_type'] = $content_type;
			$data['parent_id'] = $parent_id;
			$data['current_id']=$id;
			//LOADA JEZIK
			$data['lang']=$this->content_model->get_lang($lang);
			$this->lang->load('admin', $data['lang']['abbreviation']);
			//UCITA POSTOJECE PODATKE
			$data['content_type_data']=$this->content_model->get_content_type_data($content_type);
			$data['query'] = $this->content_model->get_single($id,$lang,$data['content_type_data']['table']);
			if(empty($data['query']))
				$data['query'] = $this->content_model->get_base_data($id);
			if($data['content_type_data']['table']!='')
				$data['content'] = $this->load->view('admin/content/'.$data['content_type_data']['table'].'/single_view', $data, TRUE);
			else
				$data['content'] = $this->load->view('admin/content/single_view', $data, TRUE);

			$this->load->view($this->admin_template, $data);
		}

	}

	
	/*
	 * KREIRANJE I POHRANA SADRZAJA
	 */
	public function process() {

		if ($this->require_role_admin('admin,manager')) {
			$content_type_data=$this->content_model->get_content_type_data($this->input->post('content_type'));

			//ADD MODE
			if($this->input->post('content_id')==0 ){
				//URL
				$url = url_title($this->input->post('name'), 'dash', TRUE);
				// GET NEW POSITION
				$new_position = $this->content_model->get_position($this->input->post('content_type'),$this->input->post('parent_id'));
				$new_position = $new_position->position+1;
				//GENERAL DATA
				$item=array(
					'publish_datetime' => date('Y-m-d H:i:s', strtotime($this->input->post('publish_datetime'))),
					'edit_datetime' => date('Y-m-d H:i:s'),
					'parent_id' => $this->input->post('parent_id'),
					'content_type' => $this->input->post('content_type'),
					'created_by' => $this->auth_user_id,
					'last_edit_by' => $this->auth_user_id,
					'position' => $new_position,
					'default_gallery'=>$this->input->post('default_gallery',true)
				);
				$item['datetime']=date('Y-m-d H:i:s');
				//LANGUAGE DATA
				if ($last_row_id=$this->content_model->insert($item)) {
						//COORDINATES
						$coordinates=array();
						$addresses = $this->input->post('address');
						$lnglat = $this->input->post('lnglat');
						
						if(!empty($lnglat)){
						foreach($lnglat as $key => $c){
							$coordinates[$key]['address']=$addresses[$key];
							$coordinates[$key]['coordinates']=$lnglat[$key];
						}
						$coordinates_json=json_encode($coordinates);
						
						}
						else{
							$coordinates_json="";
						}
						//TRANSLATIONS
						$translation = array(
							'content_id' => $last_row_id,
							'lang_id' => $this->input->post('lang_id'),
							'name' => $this->input->post('name',true),
							'content' => $this->input->post('content',true),
							'description' => $this->input->post('description',true),
							'keywords' => $this->input->post('keywords',true),
							'tags' => $this->input->post('tags',true),
							'title' => $this->input->post('title',true),
							'url' => $url,
							'video' => $this->input->post('video',true),
							'coordinates'=>$coordinates_json,
							'highlighted' => $this->input->post('highlighted')?'1':'0',
							'published' => $this->input->post('published')?'1':'0',
						);
						
						//EXTENDED CONTENT
						if($content_type_data['table']!=''){
							$extended=$this->input->post('extended',true);
							$extended['content_id']=$last_row_id;
							$extended['lang_id']=$this->input->post('lang_id');
						}
						
						
						if($this->content_model->insert_translation($translation)){
								
								$response = array(
									'response' => 'Sadržaj je pohranjen',
									'url' => $url,
									'last_row_id' => $last_row_id,
									'success' => 1
								);
								if(isset($extended) && $this->content_model->insert_extended($content_type_data['table'],$extended)){
									$response['extended_content']=1;
								}
						}
						else {
							$response = array(
								'response' => "Tekstualni dio sadržaja nije pohranjen",
								'last_row_id' => '0',
								'success' => 0
							);
						}
				}
				else {
						$response = array(
							'response' => "Kreiranje novog sadržaja nije uspjelo",
							'last_row_id' => '0',
							'success' => 0
						);
					}
				//OUTPUT RESPONSE
				echo json_encode($response);
			}
			//EDIT MODE
			else{
				// GENERATE URL //////////////////////////////////////////////////////////////////////////
				$url = url_title($this->input->post('name'), 'dash', TRUE);
				$item=array(
					'publish_datetime' => date('Y-m-d H:i:s', strtotime($this->input->post('publish_datetime'))),
					'edit_datetime' => date('Y-m-d H:i:s'),
					'parent_id' => $this->input->post('parent_id'),
					'content_type' => $this->input->post('content_type'),
					'created_by' => $this->auth_user_id,
					'last_edit_by' => $this->auth_user_id,
					'default_gallery'=>$this->input->post('default_gallery')
				);
				if ($this->content_model->update($this->input->post('content_id'), $item)) {
					//COORDINATES
						$coordinates=array();
						$addresses = $this->input->post('address');
						$lnglat = $this->input->post('lnglat');
						
						if(!empty($lnglat)){
						foreach($lnglat as $key => $c){
							$coordinates[$key]['address']=$addresses[$key];
							$coordinates[$key]['coordinates']=$lnglat[$key];
						}
						$coordinates_json=json_encode($coordinates);
						
						}
						else{
							$coordinates_json="";
						}
					//TRANSLATIONS
						$translation = array(
							'content_id' => $this->input->post('content_id'),
							'lang_id' => $this->input->post('lang_id'),
							'name' => $this->input->post('name',true),
							'content' => $this->input->post('content',true),
							'description' => $this->input->post('description',true),
							'keywords' => $this->input->post('keywords',true),
							'tags' => $this->input->post('tags',true),
							'title' => $this->input->post('title',true),
							'url' => $url,
							'video' => $this->input->post('video',true),
							'coordinates'=>$coordinates_json,
							'highlighted' => $this->input->post('highlighted')?'1':'0',
							'published' => $this->input->post('published')?'1':'0',
						);
						
					//PROVJERA DAL VEĆ POSTOJI PRIJEVOD
					if($this->content_model->check_language($this->input->post('content_id'),$this->input->post('lang_id'))){
						if($this->content_model->update_translation($this->input->post('content_id'),$this->input->post('lang_id'),$translation )){
							$response = array(
								'response' => 'Izmjene su pohranjene',
								'url' => $url,
								'last_row_id' => $this->input->post('content_id'),
								'success' => 1
							);
						}
					}
					else {
						if($this->content_model->insert_translation($translation )){
							$response = array(
								'response' => 'Prijevod je dodan',
								'url' => $url,
								'last_row_id' => $this->input->post('content_id'),
								'success' => 1
							);
						}
						else {
							$response = array(
								'response' => "Tekstualni dio sadržaja nije pohranjen",
								'last_row_id' => '0',
								'success' => 0
							);
						}
						
					}
					//EXTENDED
					//Popunimo podatke
						if($content_type_data['table']!=''){
							$extended=$this->input->post('extended',true);
							$extended['content_id']=$this->input->post('content_id');
							$extended['lang_id']=$this->input->post('lang_id');
							
							//PROVJERIMO DAL POSTOJI VEC SADRZAJ U EXTENDED TABLICI
							if($this->content_model->check_extended($content_type_data['table'],$this->input->post('content_id'),$this->input->post('lang_id'))){
								//UPDATE AKO POSTOJI
								if(isset($extended) && $this->content_model->update_extended($content_type_data['table'],$this->input->post('content_id'),$this->input->post('lang_id'),$extended)){
											$response['extended_content']=1;
										}
							}
							else{
								//INSERT AKO NE POSTOJI
								if(isset($extended) && $this->content_model->insert_extended($content_type_data['table'],$extended)){
											$response['extended_content']=1;
										}
							}			
						}	
						
					//END EXTENDED
					
					//OUTPUT RESPONSE
					echo json_encode($response);
					
				}
				else{
					$response = array(
								'response' => 'Izmjene nisu pohranjene',
								'last_row_id' => 0,
								'success' => 0
							);
							echo json_encode($response);
				}
			}
		}

	}

	/*
	 * BRISANJE SADRZAJA
	 */
	public function delete($id) {

		if ($this->require_role_admin('admin,manager')) {
			
			if($this->content_model->delete($id)){
				//PUTANJA DO SADRZAJA
				$dir=FCPATH.'uploads/content/'.$id.'/';
				//OTKRIVANJE SVIH SADRZAJA U DIREKTORIJU
				$files = new RecursiveIteratorIterator(
				    new RecursiveDirectoryIterator($dir, RecursiveDirectoryIterator::SKIP_DOTS),
				    RecursiveIteratorIterator::CHILD_FIRST
				);
				//BRISANJE SVEGA
				foreach ($files as $fileinfo) {
				    $todo = ($fileinfo->isDir() ? 'rmdir' : 'unlink');
				    $todo($fileinfo->getRealPath());
				}
				//BRISANJE SAMOG DIREKTORIJA
				rmdir($dir);
				
				$response = array(
							'response' => 'Sadržaj je obrisan',
							'success' => 1
						);
			}
			else{
				$response = array(
							'response' => 'Sadržaj nije obrisan',
							'success' => 0
						);
				}
		echo json_encode($response);
		}

	}
	
	/*
	 * DOHVAĆANJE PODATAKA ZA PREGLED U DATAGRIDU
	 */
	public function datagrid($content_type = 1, $parent_id = 0) {

		if ($this->require_role_admin('admin,manager')) {
			//COUNT SE PROVODI PO DEFAULT JEZIKU 1
			$count = $this->content_model->count_content($content_type, $parent_id);
			//DEFINIRAMO LISTU ATRIBUTA KOJE ŽELIMO, PONOVLJENI ATRIBUTI TREBAJU IMATI DRUGACIJI ALIAS, DEFAULT LANG 1
			$param_list=array('name','publish_datetime','published','highlighted','id as edit_id','id as delete_id','position');
			$query = $this->content_model->list_content($param_list,$content_type, $parent_id);
			$data=array();
			foreach($query as $q){
				//OBLIKOVANJE PODATAKA ZA ISPIS
				$q['name']=htmlspecialchars($q['name']);
				$q['publish_datetime']=date('d.m.Y.', strtotime($q['publish_datetime']));
				$data['aaData'][]=array_values($q);
			}
			echo json_encode($data);

		}

	}

	public function sorting($lang=1,$content_type = 1, $parent_id = 0) {
		
		if ($this->require_role_admin('admin,manager')) {
			$data['content_type'] = $content_type;
			$data['parent_id'] = $parent_id;
		
			$data['query'] = $this->content_model->list_content('*',$content_type, $parent_id,$lang);
		
			$this->load->view('admin/content/sorting_view', $data);
		}

	}

	public function update_position() {
		//+1 samo da izbjegnemo 0 u poziciji
		$count_items = count($this->input->post('sort_id'))+1;  

		$x = $count_items;
		foreach ($this->input->post('sort_id') as $id) {
			
			$x--;

			$files = array(
				'position' => $x,
			);

			$this->content_model->update_position($id, $files);

		}

	}

}
