<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Categories extends MY_Controller {


	public function __construct() {
		parent::__construct();
		$this->load->model('admin/general_model');
		$this->load->model('admin/listings_model');
		$this->load->model('admin/categories_model');
		$this->load->model('offers_model');
		$this->load->model('user_model');
		$this->load->library('multilang', array('default_lang' => 'hr', 'multilang'=>false));
		$this->load->library('encrypt');
		$this->load->helper('language');
	}

	public function index() {
	if ($this->require_role_admin('admin')) {
			$data['lang']=$this->multilang->get_current();
			$parent_id=$this->input->get('parent_id',true);
			
			//SET MENU AND GET LISTINGS IN CAT
			$this->load->library('menu',array('lang'=>$data['lang'],'parent'=>NULL));
			//$data['listings']=$this->listings_model->get_listings($category_id,$published);
			$data['menu_items']=$this->menu->generate_categories_paths(NULL);
			if($parent_id>0)
				$data['breadcrumbs']=$this->menu->getkeypath($data['menu_items'],$parent_id);
			$data['category_id']=$parent_id;
            
            //COUNT SE PROVODI PO DEFAULT JEZIKU 1
            $count = $this->categories_model->count_categories($parent_id);
            //DEFINIRAMO LISTU ATRIBUTA KOJE ŽELIMO, PONOVLJENI ATRIBUTI TREBAJU IMATI DRUGACIJI ALIAS, DEFAULT LANG 1
            $param_list=array('ref_name','category_id as level_id','category_id as properties_id','category_id as edit_id','category_id as delete_id');
            $data['query'] = $this->categories_model->get_categories_datagrid($param_list,$parent_id);
            
            
			$data = array(
				'content' => $this->load->view('admin/categories/main_view', $data, TRUE)
			);
			//$data['lang']=$this->general_model->get_lang(1);
			$this->load->view($this->admin_template, $data);
		}
	}


	public function list_all() {
	if ($this->require_role_admin('admin')) {
			$data['lang']=$this->multilang->get_current();
			
			//SET MENU AND GET LISTINGS IN CAT
			$this->load->library('menu',array('lang'=>$data['lang'],'parent'=>NULL));
			//$data['listings']=$this->listings_model->get_listings($category_id,$published);
			$data['menu_items']=$this->menu->generate_categories_paths(NULL);
			 $parent_id=null;
			$data['category_id']=$parent_id;
            
           
            //DEFINIRAMO LISTU ATRIBUTA KOJE ŽELIMO, PONOVLJENI ATRIBUTI TREBAJU IMATI DRUGACIJI ALIAS, DEFAULT LANG 1
            $param_list=array('ref_name','category_id as level_id','category_id as properties_id','category_id as edit_id','category_id as delete_id');
           	$data['query'] = $this->categories_model->get_categories_datagrid($param_list,$parent_id);
            $count =sizeof($data['query']);
            
			$data = array(
				'content' => $this->load->view('admin/categories/all_view', $data, TRUE)
			);
			//$data['lang']=$this->general_model->get_lang(1);
			$this->load->view($this->admin_template, $data);
		}
	}
	
	public function add_new(){
		if ($this->require_role_admin('admin')) {
			
		$parent_id=(int)$this->input->get('parent_id',true);
		if($parent_id==0)
			$parent_id=NULL;
		$data=array(
			'ref_name'=>'new item',
			'parent_id'=>$parent_id
			);
		if($id=$this->categories_model->insert($data)){
			 redirect('/admin/categories/view/?id='.$id, 'refresh');
		}
		else{
			redirect('/admin/categories?parent_id='.$parent_id, 'refresh');
		}
		
		//echo json_encode($response);
		}
	}

	public function remove(){
			if ($this->require_role_admin('admin')) {
			$id=$this->input->get('id');
			$category=$this->categories_model->get_category($id);
			if($id=$this->categories_model->delete($id)){
				redirect('/admin/categories?parent_id='.$category['parent_id'], 'refresh');
			}
			else{
				redirect('/admin/categories?parent_id='.$category['parent_id'], 'refresh');
			}
			}
		}
	
	
	public function view() {
	if ($this->require_role_admin('admin')) {
		//GET LANG DATA AND SET MENU
			$data['lang']=$this->multilang->get_current();
			$this->load->library('menu',array('lang'=>$data['lang'],'parent'=>NULL));
			//GET ID AND DATA
			$id=$this->input->get('id',true);
			$data['category']=$this->categories_model->get_category($id);
			$data['lang_data']=$this->categories_model->get_category_trans_bylang($id);
			//SEND MENU ITEMS AND SET BREADCRUMBS
			$data['menu_items']=$this->menu->generate_categories_paths(NULL);
			$data['breadcrumbs']=$this->menu->getkeypath($data['menu_items'],$data['category']['category_id']);
			//UTIL
			$data['countries']=$this->general_model->list_countries();
			$data = array(
				'content' => $this->load->view('admin/categories/single_view', $data, TRUE)
			);
			$this->load->view($this->admin_template, $data);
		}
	}


	public function process(){
		if ($this->require_role_admin('admin')) {
			
			$base_data=array(
				'ref_name'=>$this->input->post('ref_name',true)
			);
			$id=$this->input->post('category_id');
			$lang_name=$this->input->post('lang_name',true);
			$lang_published=$this->input->post('lang_published',true);
			
			if($this->categories_model->update($id,$base_data)){
				$response['main_data']=1;
				foreach($lang_name as $key=>$l){
					$lang_data=array(
						'category_name'=>$l,
						'category_id'=>$id,
						'language_id'=>$key,
						'published'=>$lang_published[$key]
					);
				if($this->categories_model->check_language($id,$key)){
					if($this->categories_model->update_data($id,$key,$lang_data)){
						$response['lang_data']=1;
					}
					else{
						$response['lang_data']=0;
					}
				}
				else{
					if($this->categories_model->insert_data($lang_data)){
						$response['lang_data']=1;
					}
					else{
						$response['lang_data']=0;
					}
				}
					
				}
			}
			else{
				$response['main_data']=0;
			}
		if($response['main_data']==1 && $response['lang_data']==1)
			$response['response']='Data saved';
		else
			$response['response']='Data not saved';
		//OUTPUT RESULT
		echo json_encode($response);
		}
	}

	/*
	 * DOHVAĆANJE PODATAKA ZA PREGLED U DATAGRIDU
	 */
	public function datagrid() {
			//CATEGORY ID
			if($this->input->get('parent_id')!=0)
				$parent_id=$this->input->get('parent_id',true);
			else
				$parent_id=NULL;
			
		if ($this->require_role_admin('admin')) {
			//COUNT SE PROVODI PO DEFAULT JEZIKU 1
			$count = $this->categories_model->count_categories($parent_id);
			//DEFINIRAMO LISTU ATRIBUTA KOJE ŽELIMO, PONOVLJENI ATRIBUTI TREBAJU IMATI DRUGACIJI ALIAS, DEFAULT LANG 1
			$param_list=array('ref_name','category_id as level_id','category_id as properties_id','category_id as edit_id','category_id as delete_id');
			$query = $this->categories_model->get_categories_datagrid($param_list,$parent_id);
			$data=array();
			if(!empty($query)){
			foreach($query as $q){
				//OBLIKOVANJE PODATAKA ZA ISPIS
				$q['ref_name']=htmlspecialchars($q['ref_name']);
				$data['aaData'][]=array_values($q);
			}
			}
			else{
				$data['aaData']=array();
			}
			echo json_encode($data);

		}

	}

}
