<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class pages_menu extends MX_Controller {
	
	private $controller_name=array (
			'hr' => 'stranice',
			'en' => 'pages',
			'de' => 'seite'
	);

	function __construct() {
		parent::__construct();


	}

		public function index($parent_id,$lang='hr',$pages_list=null) {
		
		$data['parent_id'] = $parent_id;
		$data['lang'] = $lang;
		$data['c_name']=$this->controller_name[$lang];
		if($pages_list!=null)
			$data['category_list'] = $pages_list;
		else{
			
				$data['category_list'] = $this->_get_pages($parent_id);
		}
		//print_r($data['category_list']);
		$this->load->view('pages_menu_view', $data);
	}
		
		function _get_pages($parent = 0) {

		$categories = array();
		$this->db->from('pages');
		$this->db->where('parent_id', $parent);
		$this->db->order_by('id', 'asc');
		$query = $this->db->get();

		foreach ($query->result_array() as $cat) {

			$categories[$cat['id']] = array(
				'id' => $cat['id'],
				'name_hr' => $cat['name_hr'],
				'name_en' => $cat['name_en'],
				'name_de' => $cat['name_de'],
				'url_hr' => $cat['url_hr'],
				'url_en' => $cat['url_en'],
				'url_de' => $cat['url_de'],
				'children' => array()
			);

			if ($this->_has_child($cat['id'])) {
				$children = $this->_get_pages($cat['id']);
				
				$categories[$cat['id']]['children'] = $children;
			}

			

		}

		return $categories;

	}
	
	function _has_child($cat_id) {
		$this->db->from('pages');
		$this->db->where('parent_id', $cat_id);
		$test=$this->db->count_all_results();

		if ($test > 0) {
			return TRUE;
		}
		return FALSE;

	}
		
		
	}
 ?>