<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

/*
 * USING $query_single IN OPENED PAGES, NEWS ....
 * IN $params GOES DATA FRMO DATABASE IF $query_sinle EXIST
 * SECOND PARAMETER IS LANGUAGE
 * FOR THIS MODE USE CODE BELOW
 * if(isset($query_single)) { $param = $query_single; } else{ $param = ""; } echo Modules::run('front_meta/front_meta/index', $param, '_hr');
*/

class Front_meta extends MY_Controller {

	function __construct() {
		parent::__construct();
		$this->load->model('front_meta/front_meta_model');

	}

	public function index($param, $lang) {

		//GENERAL TAGS
		$settings = $this->front_meta_model->general_tags();

		$general_title = $settings['title'.$lang];
		$general_description = $settings['description'.$lang];
		$general_keywords = $settings['keywords'.$lang];
		

		if (!empty($param)) {

			$title = $param['title' . $lang];
			$description = $param['description' . $lang];
			$keywords = $param['keywords' . $lang];

			if (empty($title)) {
				$title = $general_title . " - " . $param['name' . $lang];
			}

			if (empty($description)) {
				$description = word_limiter(strip_tags($param['content' . $lang]), '25');
			}

			if (empty($keywords)) {
				$keywords = $general_keywords;
			}

		} else {

			$title = $general_title;
			$description = $general_description;
			$keywords = $general_keywords;

		}

		$data['title'] = $title;
		$data['description'] = $description;
		$data['keywords'] = $keywords;

		$this->load->view('front_meta_view', $data);

	}

}
