<?php
class Offers_model extends CI_Model {

    function __constructl() {
        parent::__construct();
    }
	
	private $table='item_offers';
	
	function get_offer($offer_id,$user_id){
		$this->db->from($this->table);
		$this->db->where('id',$offer_id);
		$this->db->where('user_id',$user_id);
		$query=$this->db->get();
		return $query->row_array();
	}
	
	
	function get_single_offer($offer_id){
		$this->db->from($this->table);
		$this->db->where('id',$offer_id);
		$query=$this->db->get();
		return $query->row_array();
	}
	
	function get_item_offers($item_id){
		$this->db->select('io.*,count(iom.id) as num_msg');
		$this->db->from('item_offers io');
		$this->db->where('item_id',$item_id);
		$this->db->where('published','1');
		$this->db->join('item_offer_messages iom', 'iom.offer_id=io.id','left');
		$this->db->group_by('io.id');
		$this->db->order_by('offer_datetime','desc');
		$query=$this->db->get();
		return $query->result_array();
	}
	
	function insert($data){
		if($this->db->insert($this->table, $data))
			return $this->db->insert_id();
		else
			return false;
	}
	
	function get_item_offer_owners($offer_id){
		$this->db->select('io.user_id as offer_owner, i.user_id as item_owner, i.item_id as item_id');
		$this->db->from('item_offers io');
		$this->db->where('io.id',$offer_id);
		$this->db->join('items i', 'i.item_id=io.item_id');
		$query=$this->db->get();
		return $query->row_array();
	}
	
	function get_base_data($offer_id){
		$this->db->select('io.user_id as offer_owner, i.user_id as item_owner, i.item_id as item_id,i.item_name as item_name, io.title as offer_title, i.item_origin_id as country');
		$this->db->from('item_offers io');
		$this->db->where('io.id',$offer_id);
		$this->db->join('items i', 'i.item_id=io.item_id');
		$query=$this->db->get();
		return $query->row_array();
	}
	
	function is_owner($user_id,$offer_id){
		$this->db->select('user_id');
		$this->db->from($this->table);
		$this->db->where('id',$offer_id);
		$query=$this->db->get();
		$result=$query->row_array();
		if(!empty($result)){
			if($result['user_id']==$user_id)
				return true;
			else
				return false;
		}
		else{
			return true;
		}
		
	}
	
	function count_offers($item_id){
		$this->db->select('id');
		$this->db->from($this->table);
		$this->db->where('item_id',$item_id);
		$this->db->where('published','1');
		$count= $this->db->count_all_results();
		return $count;
	}
	
	function has_applied($user_id,$item_id){
		$this->db->from($this->table);
		$this->db->where('item_id',$item_id);
		$this->db->where('user_id',$user_id);
		$query=$this->db->get();
		$result=$query->row_array();
		if(!empty($result))
			return $result;
		else
			return false;
	}
	
	function update($id,$data){
		return $this->db->update($this->table, $data, array('id' => $id));
	}
	
	//IMAGES
	function insert_image($data){
		return $this->db->insert('item_offer_images', $data);
	}
	
	function delete_image($offer_id,$hash){
		$this->db->from('item_offer_images');
		$this->db->where('offer_id',$offer_id);
		$this->db->where('name_hash',$hash);
		return $this->db->delete();
	}
	
	function get_images($offer_id){
		$this->db->from('item_offer_images');
		$this->db->where('offer_id',$offer_id);
		$query=$this->db->get();
		return $query->result_array();
	}
	function get_image($offer_id,$hash){
		$this->db->from('item_offer_images');
		$this->db->where('offer_id',$offer_id);
		$this->db->where('name_hash',$hash);
		$query=$this->db->get();
		return $query->row_array();
	}
	
	//DOCUMENTS
	function insert_document($data){
		return $this->db->insert('item_offer_documents', $data);
	}
	
	function get_documents($offer_id){
		$this->db->from('item_offer_documents');
		$this->db->where('offer_id',$offer_id);
		$query=$this->db->get();
		return $query->result_array();
	}
	
	function count_documents($item_id){
		$this->db->from('item_offer_documents');
		$this->db->where('item_id',$item_id);
		return $this->db->count_all_results();
	}
	
	function get_document($offer_id,$hash){
		$this->db->from('item_offer_documents');
		$this->db->where('offer_id',$offer_id);
		$this->db->where('name_hash',$hash);
		$query=$this->db->get();
		return $query->row_array();
	}

	function delete_document($offer_id,$hash){
		$this->db->from('item_offer_documents');
		$this->db->where('offer_id',$offer_id);
		$this->db->where('name_hash',$hash);
		return $this->db->delete();
	}
}
?>