<?php
class messages_model extends CI_Model {

    function __constructl() {
        parent::__construct();
    }
	
	private $table='item_offer_messages';
	
	function get_latest($offer_id,$limit=5){
		$this->db->from($this->table);
		$this->db->where('offer_id',$offer_id);
		$this->db->order_by('msg_timestamp','desc');
		$this->db->limit($limit);
		$query=$this->db->get();
		return $query->result_array();
	}
	
	function get_all($offer_id){
		$this->db->from($this->table);
		$this->db->where('offer_id',$offer_id);
		$this->db->order_by('msg_timestamp','desc');
		$query=$this->db->get();
		return $query->result_array();
	}
	
	
	function get_users($offer_id){
		$this->db->distinct();
		$this->db->select('user_id');
		$this->db->from($this->table);
		$this->db->where('offer_id',$offer_id);
		$query=$this->db->get();
		return $query->result_array();
	}
	
	function insert($data){
		if($this->db->insert($this->table, $data))
			return $this->db->insert_id();
		else
			return false;
	}
	
	
	
	function update($id,$data){
		return $this->db->update($this->table, $data, array('id' => $id));
	}
	
	function delete($id) {
		return $this->db->delete($this->table, array('id' => $id));

	}
	
	
	function is_owner($user_id,$offer_id){
		$this->db->select('user_id');
		$this->db->from($this->table);
		$this->db->where('id',$offer_id);
		$query=$this->db->get();
		$result=$query->row_array();
		if(!empty($result)){
			if($result['user_id']==$user_id)
				return true;
			else
				return false;
		}
		else{
			return true;
		}
		
	}
	
	//ATTACHMENTS
	function get_attachments($message_id,$type=null){
		$this->db->from('item_offer_msg_attach');
		$this->db->where('message_id',$message_id);
		if(!is_null($type))
			$this->db->where('type',$type);
		$this->db->order_by('type','asc');
		$this->db->order_by('upload_timestamp','asc');
		$query=$this->db->get();
		return $query->result_array();
	}

	function get_attachment($att_id){
		$this->db->from('item_offer_msg_attach');
		$this->db->where('id',$att_id);
		$query=$this->db->get();
		return $query->row_array();
	}
	
	function delete_attachment($id) {
		return $this->db->delete('item_offer_msg_attach', array('id' => $id));

	}
	
	function insert_attachment($data){
		if($this->db->insert('item_offer_msg_attach', $data))
			return $this->db->insert_id();
		else
			return false;
	}
	
	function update_att($id,$data){
		return $this->db->update('item_offer_msg_attach', $data, array('id' => $id));
	}
	
}
?>