<?php
class Main_model extends CI_Model {

	function __constructl() {
		parent::__construct();
	}

	function get_cat_info($id, $lang) {
		$this->db->select('ic.category_id as category_id, ic.parent_id as parent_id,ict.category_name as name, ict.category_description as description');
		$this->db->from('item_categories ic');
		$this->db->where('ic.category_id', $id);
		$this->db->join('item_categories_translations ict', 'ict.category_id = ic.category_id');
		$this->db->where('ict.language_id', $lang);
		$this->db->where('ict.published', '1');
		$query = $this->db->get();
		$result = $query->row_array();
		if (!empty($result))
			return $result;
		else
			return false;
	}

	function get_subcats($id, $lang) {
		$this->db->select('ic.category_id as category_id, ic.parent_id as parent_id,ict.category_name as name, ict.category_description as description');
		$this->db->from('item_categories ic');
		$this->db->where('ic.parent_id', $id);
		$this->db->join('item_categories_translations ict', 'ict.category_id = ic.category_id');
		$this->db->where('ict.language_id', $lang);
		$this->db->where('ict.published', '1');
		$query = $this->db->get();
		$result = $query->result_array();
		if (!empty($result))
			return $result;
		else
			return false;
	}

	//FILTRIRANJE

	//GRUPE SVOJSTAVA POJEDINE KATEGORIJE
	function get_category_properties_groups($category_id, $lang = 1) {
		$this->db->select('pg.id as id,pg.sys_name as sys_name,pg.type as type,pgt.name as name');
		$this->db->from('category_properties cp');
		$this->db->where_in('cp.category_id', $category_id);
		$this->db->join('properties_groups pg', 'pg.id = cp.group_id');
		$this->db->join('properties_groups_translations pgt', 'pg.id = pgt.group_id AND pgt.lang_id=' . $lang, 'left');
		//$this->db->join('properties p', 'p.group_id = pg.id');
		$query = $this->db->get();
		$result = $query->result_array();
		if (!empty($result))
			return $result;
		else
			return false;
	}

	//SVOJSTVA POJEDINE GRUPE
	function get_category_properties($group_id, $lang = 1) {
		$this->db->select('p.id as id, p.sys_name as sys_name,pt.name as name');
		$this->db->from('properties p');
		$this->db->where('group_id', $group_id);
		$this->db->join('properties_translations pt', 'p.id = pt.property_id AND pt.lang_id=' . $lang, 'left');
		$query = $this->db->get();
		$result = $query->result_array();
		if (!empty($result))
			return $result;
		else
			return false;
	}

	//FILTRIRANJE PO PARAMETRIMA
	function get_by_filter($country, $cid, $filters, $groups_number = null, $lang, $sort, $num = null, $offset = null) {
		if (is_null($groups_number))
			$groups_number = sizeof($filters);

		$query = 'SELECT DISTINCT
		  i.item_id as item_id,
		  i.item_name as item_name,
		  i.item_content as item_content,
		  i.item_expired_datetime as item_expired_datetime,
		  i.item_origin_id as item_origin_id,
		  i.item_budget as item_budget,
		  i.item_budget_currency as item_budget_currency,
		  i.item_category as item_category,
		  ic.abbr as currency,
		  uc.name as origin,
		  ip.property_id AS item_property,
		  ii.paths as image 
		FROM
		  items i';
		if (!is_null($country))
			$query .= ' INNER JOIN item_countries icnt ON i.item_id = icnt.item_id AND icnt.country_id=' . $country;

		$query .= ' LEFT JOIN item_properties ip ON ip.item_id = i.item_id
		LEFT JOIN item_currencies ic ON item_budget_currency = ic.id
		LEFT JOIN item_images ii ON i.item_id = ii.item_id
		INNER JOIN util_countries uc ON item_origin_id = uc.id
		WHERE i.item_published="1" AND i.item_category IN (' . implode(',', $cid) . ')  AND item_expired_datetime > NOW()';

		if (is_array($lang) && !empty($lang)) {
			$lang_list = array();
			foreach ($lang as $l) {
				$lang_list[] = $l['language_id'];
			}
			$list = implode(',', $lang_list);
			$query .= ' AND i.lang_id IN(' . $list . ')';
		}

		$query .= ' AND 
		  ip.property_id IN (' . implode(", ", $filters) . ')
		GROUP BY 
		  ip.item_id
		HAVING
		  COUNT(DISTINCT ip.property_id) =' . $groups_number . '
		  ORDER BY';
		if (is_array($sort)) {
			foreach ($sort as $key => $value) {
				$query .= ' ' . $key . ' ' . $value;
			}
		}
		if (!is_null($num) && !is_null($offset))
			$query .= ' LIMIT ' . $offset . ', ' . $num;
		$query = $this->db->query($query);
		$result = $query->result_array();
		if (!empty($result))
			return $result;
		else
			return false;
	}

	function count_by_filter($country, $cid, $filters, $groups_number = null, $lang) {
		if (is_null($groups_number))
			$groups_number = sizeof($filters);
		$query = 'SELECT
		  i.item_id as item_id,
		  ip.property_id AS item_property 
		FROM
		  items i';
		if (!is_null($country))
			$query .= ' INNER JOIN item_countries icnt ON i.item_id = icnt.item_id AND icnt.country_id=' . $country;

		$query .= ' LEFT JOIN item_properties ip ON ip.item_id = i.item_id
		  WHERE i.item_published="1" AND i.item_category IN (' . implode(',', $cid) . ') AND item_expired_datetime > NOW()';

		if (is_array($lang) && !empty($lang)) {
			$lang_list = array();
			foreach ($lang as $l) {
				$lang_list[] = $l['language_id'];
			}
			$list = implode(',', $lang_list);
			$query .= ' AND i.lang_id IN(' . $list . ')';
		}

		$query .= ' AND 
		  ip.property_id IN (' . implode(", ", $filters) . ')
		GROUP BY 
		  ip.item_id
		HAVING
		  COUNT(DISTINCT ip.property_id) =' . $groups_number;
		$query = $this->db->query($query);
		$result = $query->result_array();
		if (!empty($result))
			return sizeof($result);
		else
			return false;
	}

	//ITEM

	function get_items($country, $id, $lang, $sort, $num = null, $offset = null) {
		$this->db->distinct();
		$this->db->select('i.item_id,item_category,item_name ,item_content,item_budget, item_images, item_publish_datetime, item_expired_datetime, ic.abbr as currency, uc.name as origin, ii.paths as image');
		$this->db->from('items i');
		$this->db->where_in('item_category', $id);
		$this->db->where('item_published', '1');
		$this->db->where('item_expired_datetime > NOW()');
		if (is_array($lang) && !empty($lang)) {
			$lang_list = array();
			foreach ($lang as $l) {
				$lang_list[] = $l['language_id'];
			}
			$this->db->where_in('lang_id', $lang_list);
		}
		if (!is_null($country)  && $country!=0)
			$this->db->join('item_countries icnt', 'i.item_id = icnt.item_id AND icnt.country_id=' . $country, 'inner', false);
		$this->db->join('item_currencies ic', 'item_budget_currency = ic.id', 'left');
		$this->db->join('item_images ii', 'i.item_id = ii.item_id', 'left');
		$this->db->join('util_countries uc', 'item_origin_id = uc.id', 'inner');
		$this->db->group_by('i.item_id');
		if (is_array($sort)) {
			foreach ($sort as $key => $value) {
				$this->db->order_by($key, $value);
			}
		}

		if (!is_null($num) && !is_null($offset))
			$this->db->limit($num, $offset);
		$query = $this->db->get();
		$result = $query->result_array();
		if (!empty($result))
			return $result;
		else
			return false;
	}

	function count_items($country, $id, $lang) {
		$this->db->select('item_id');
		$this->db->from('items i');
		$this->db->where_in('item_category', $id);
		$this->db->where('item_published', '1');
		$this->db->where('item_expired_datetime > NOW()');
		if (is_array($lang) && !empty($lang)) {
			$lang_list = array();
			foreach ($lang as $l) {
				$lang_list[] = $l['language_id'];
			}
			$this->db->where_in('lang_id', $lang_list);
		}
		if (!is_null($country)  && $country!=0)
			$this->db->join('item_countries icnt', 'i.item_id = icnt.item_id AND icnt.country_id=' . $country, 'inner', false);
		$result = $this->db->count_all_results();
		if ($result > 0)
			return $result;
		else
			return false;
	}

	//BASIC SEARCH
	function simple_search_items($country, $search, $cid = 'all', $lang, $num = null, $offset = null) {
		$query = '
		SELECT DISTINCT
			i.item_id as item_id,
			item_category,
			item_name ,
			item_content,
			item_budget, 
			item_images, 
			item_publish_datetime, 
			item_expired_datetime, 
			ic.abbr as currency, 
			uc.name as origin,
			ii.paths as image
		FROM (items i)';
		if (!is_null($country)  && $country!=0)
			$query .= ' INNER JOIN item_countries icnt ON i.item_id = icnt.item_id AND icnt.country_id=' . $country;
		$query .= ' LEFT JOIN item_images ii ON i.item_id = ii.item_id
		LEFT JOIN item_currencies ic ON i.item_budget_currency = ic.id 
		LEFT JOIN util_countries uc ON item_origin_id = uc.id
		WHERE i.item_published="1" AND item_expired_datetime > NOW()
		';
		if ($cid != 'all')
			$query .= 'AND i.item_category IN  (' . implode(',', $cid) . ')';

		//GET COUNTRY LANGUAGES
		if (is_array($lang) && !empty($lang)) {
			$lang_list = array();
			foreach ($lang as $l) {
				$lang_list[] = $l['language_id'];
			}
			$list = implode(',', $lang_list);

			$query .= ' AND lang_id IN(' . $list . ')';

			$query .= ' AND (i.item_name LIKE "%' . $search . '%" OR i.item_content LIKE "%' . $search . '%")';
		} else {
			$query .= ' AND (i.item_name LIKE "%' . $search . '%" OR i.item_content LIKE "%' . $search . '%")';
		}
		$query .= ' GROUP BY i.item_id ';
		$query .= 'LIMIT ' . $offset . ',' . $num;

		$query = $this->db->query($query);
		$result = $query->result_array();

		if (!empty($result))
			return $result;
		else
			return false;
	}

	function simple_search_count_items($country, $search, $cid = 'all', $lang) {
		$query = '
		SELECT i.item_id FROM (items i)';
		if (!is_null($country)  && $country!=0)
			$query .= ' INNER JOIN item_countries icnt ON i.item_id = icnt.item_id AND icnt.country_id=' . $country;
		$query .= ' LEFT JOIN item_currencies ic ON i.item_budget_currency = ic.id 
		WHERE i.item_published="1" AND item_expired_datetime > NOW()
		';
		if ($cid != 'all')
			$query .= 'AND i.item_category IN  (' . implode(',', $cid) . ')';
		//GET COUNTRY LANGUAGES
		if (is_array($lang) && !empty($lang)) {
			$lang_list = array();
			foreach ($lang as $l) {
				$lang_list[] = $l['language_id'];
			}
			$list = implode(',', $lang_list);

			$query .= ' AND lang_id IN(' . $list . ')';

			$query .= ' AND (i.item_name LIKE "%' . $search . '%" OR i.item_content LIKE "%' . $search . '%")';
		} else {
			$query .= ' AND (i.item_name LIKE "%' . $search . '%" OR i.item_content LIKE "%' . $search . '%")';
		}
		$query = $this->db->query($query);
		$result = $query->result_array();
		if (!empty($result))
			return sizeof($result);
		else
			return false;
	}

	function get_latest_items($country, $lang, $limit, $cat_id = null,$img_only=false) {
		$this->db->distinct();
		$this->db->select('i.item_id,item_category,item_name ,item_content,item_budget, item_images, item_publish_datetime, item_expired_datetime, ic.abbr as currency,i.item_origin_id,ic.abbr, ii.paths');
		$this->db->from('items i');
		if (!is_null($cat_id))
			$this->db->where_in('i.item_category', $id);
		$this->db->where('item_published', '1');
		if (is_array($lang) && !empty($lang)) {
			$lang_list = array();
			foreach ($lang as $l) {
				$lang_list[] = $l['language_id'];
			}
			$this->db->where_in('lang_id', $lang_list);
		}
		$this->db->where('item_expired_datetime > NOW()');
		if (!is_null($country)  && $country!=0)
			$this->db->join('item_countries icnt', 'i.item_id = icnt.item_id AND icnt.country_id=' . $country, 'inner', false);
		$this->db->join('item_images ii', 'i.item_id = ii.item_id', 'left');
		if($img_only)
			$this->db->where('ii.paths !=""',null,false);
		$this->db->join('item_currencies ic', 'item_budget_currency = ic.id', 'left');
		$this->db->group_by('i.item_id');
		$this->db->order_by('item_publish_datetime', 'desc');
		$this->db->limit($limit);
		$query = $this->db->get();
		$result = $query->result_array();
		if (!empty($result))
			return $result;
		else
			return false;
	}

	function get_expiring_items($country, $lang, $limit, $cat_id = null) {
		$this->db->distinct();
		$this->db->select('i.item_id,item_category,item_name ,item_content,item_budget, item_images, item_publish_datetime, item_expired_datetime,i.item_origin_id, ic.abbr as abbr, ii.paths');
		$this->db->from('items i');
		if (is_array($lang) && !empty($lang)) {
			$lang_list = array();
			foreach ($lang as $l) {
				$lang_list[] = $l['language_id'];
			}
			$this->db->where_in('lang_id', $lang_list);
		}
		if (!is_null($cat_id))
			$this->db->where_in('i.item_category', $id);
		$this->db->where('item_published', '1');
		$this->db->where('item_expired_datetime > NOW()');
		if (!is_null($country)  && $country!=0)
			$this->db->join('item_countries icnt', 'i.item_id = icnt.item_id AND icnt.country_id=' . $country, 'inner', false);
		$this->db->join('item_images ii', 'i.item_id = ii.item_id', 'left');
		$this->db->join('item_currencies ic', 'item_budget_currency = ic.id', 'left');
		$this->db->group_by('i.item_id');
		$this->db->order_by('item_expired_datetime', 'asc');
		$this->db->limit($limit);
		$query = $this->db->get();
		$result = $query->result_array();
		if (!empty($result))
			return $result;
		else
			return false;
	}

	function get_watched_items($user) {
		$this->db->distinct();
		$this->db->select('i.item_id,item_category,item_name ,item_content,item_budget, item_images, item_publish_datetime, item_expired_datetime,i.item_origin_id, ic.abbr as abbr, ii.paths');
		$this->db->from('items i');
		$this->db->where('item_published', '1');
		/*$this->db->where('item_publish_datetime < NOW() AND item_expired_datetime > NOW()');
		 if(!is_null($country))
		 $this->db->join('item_countries icnt', 'i.item_id = icnt.item_id AND icnt.country_id='.$country, 'inner',false);

		 */
		$this->db->join('item_watchlist iw', 'i.item_id = iw.item_id AND iw.user_id=' . $user, 'inner', false);
		$this->db->join('item_images ii', 'i.item_id = ii.item_id', 'left');
		$this->db->join('item_currencies ic', 'item_budget_currency = ic.id', 'left');
		$this->db->group_by('i.item_id');
		$this->db->order_by('item_expired_datetime', 'desc');
		$query = $this->db->get();
		$result = $query->result_array();
		if (!empty($result))
			return $result;
		else
			return false;
	}

	function get_item($id) {
		$this->db->from('items i');
		$this->db->where('item_id', $id);
		$this->db->join('item_currencies ic', 'item_budget_currency = ic.id', 'left');
		$query = $this->db->get();
		$result = $query->row_array();
		if (!empty($result))
			return $result;
		else
			return false;
	}

	function get_item_countries($id){
		$this->db->from('item_countries');
		$this->db->where('item_id', $id);
		$query = $this->db->get();
		$result = $query->result_array();
		if (!empty($result))
			return $result;
		else
			return false;
	}

	function get_country($id) {
		$this->db->from('util_countries');
		$this->db->where('id', $id);
		$query = $this->db->get();
		$result = $query->row_array();
		if (!empty($result))
			return $result;
		else
			return false;
	}
	
	function get_all_countries() {
		$this->db->from('util_countries');
		$this->db->where('id !=', '0');
		$query = $this->db->get();
		$result = $query->result_array();
		if (!empty($result))
			return $result;
		else
			return false;
	}

	function get_sys_countries() {
		$this->db->distinct();
		$this->db->select('uc.id as id, uc.name as country_name, uc.abbr_2 as country_abbr');
		$this->db->from('sys_countries sc');
		$this->db->join('util_countries uc', 'sc.country_id=uc.id', 'left');
		$this->db->group_by('sc.country_id');
		$query = $this->db->get();
		return $query->result_array();
	}

	function list_languages() {
		$this->db->from('util_languages');
		$this->db->where('published', '1');
		$query = $this->db->get();
		return $query->result_array();
	}

	function list_currencies() {
		$this->db->from('item_currencies');
		$query = $this->db->get();
		return $query->result_array();
	}
	// LIVE SEARCH

	function live_search($country, $keyword, $cid = 'all', $lang = array()) {
		$this->db->select('item_name');
		$this->db->from('items i');
		$this->db->where('item_published', '1');
		$this->db->where('item_expired_datetime > NOW()');
		if ($cid != 'all')
			$this->db->where('item_category', $cid);
		if (is_array($lang) && !empty($lang)) {
			$lang_list = array();
			foreach ($lang as $l) {
				$lang_list[] = $l['language_id'];
			}
			$this->db->where_in('lang_id', $lang_list);
		}
		if (!is_null($country))
			$this->db->join('item_countries icnt', 'i.item_id = icnt.item_id AND icnt.country_id=' . $country, 'inner', false);
		$this->db->like('item_name', $keyword);
		$this->db->limit(10, 0);
		$query = $this->db->get();
		$result = $query->result_array();
		if (!empty($result))
			return $result;
		else
			return false;
	}

	function get_contact($lang_id = 1) {
		$this->db->from('contact c');
		$this->db->where('c.language_id', $lang_id);
		$query = $this->db->get();
		return $query->row_array();
	}

	//IMAGE
	function get_image($item_id) {
		$this->db->from('item_images');
		$this->db->where('item_id', $item_id);
		$query = $this->db->get();
		return $query->row_array();
	}

	//NOTIFICATIONS
	function get_notifications($user_id, $type_id = null) {
		$this->db->from('user_notifications');
		$this->db->where('user_id', $user_id);
		if (!is_null($type_id))
			$this->db->where('type_id', $type_id);
		$this->db->order_by('created_timestamp', 'desc');
		$query = $this->db->get();
		return $query->result_array();
	}

	function add_notification($data) {
		if ($this->db->insert('user_notifications', $data))
			return $this->db->insert_id();
		else
			return false;
	}

	function update_notification($id, $data) {
		return $this->db->update('user_notifications', $data, array('id' => $id));
	}

	function delete_notification($id,$user_id) {
		return $this->db->delete('user_notifications', array('id' => $id,'user_id'=>$user_id));

	}

	//WATCHING
	function add_to_watch_list($data) {
		return $this->db->insert('item_watchlist', $data);
	}

	//VIEW COUNTER
	function add_view($id) {
		$this->db->set('item_views', 'item_views+1', FALSE);
		$this->db->where('item_id', $id);
		$this->db->update('items');
	}

	function check_if_watched($user_id, $item_id) {
		$this->db->from('item_watchlist');
		$this->db->where('item_id', $item_id);
		$this->db->where('user_id', $user_id);
		$count = $this->db->count_all_results();
		if ($count > 0)
			return false;
		else
			return true;
	}

	//CREDITS
	function get_user_credits($user_id){
		$this->db->from('user_credits');
		$this->db->where('user_id',$user_id);
		$query=$this->db->get();
		return $query->row_array();
	}
	
	function add_credit_log($data) {
		return $this->db->insert('logs_credit_transactions', $data);
	}
	
	//STATISTICS
	function get_stat($id,$date){
		$this->db->from('item_statistics');
		$this->db->where('item_id',$id);
		$this->db->where('date', $date);
		$query=$this->db->get();
		return $query->result_array();
	}
	
	function create_stat($data) {
		return $this->db->insert('item_statistics', $data);
	}
	
	function update_stat($id, $date) {
		$this->db->set('count', 'count+1', FALSE);
		$this->db->where('item_id', $id);
		$this->db->where('date', $date);
		$this->db->update('item_statistics');
	}
	
	
	//PAGES
	function get_pages($parent_id,$lang){
		$this->db->from('pages p');
		$this->db->where('p.parent_id',$parent_id);
		$this->db->join('pages_translations pt','p.id=pt.page_id');
		$this->db->where('pt.lang_id', $lang);
		$query=$this->db->get();
		return $query->result_array();
	}
	
	function get_page($id,$lang){
		$this->db->from('pages p');
		$this->db->where('p.id',$id);
		$this->db->join('pages_translations pt','p.id=pt.page_id');
		$this->db->where('pt.lang_id', $lang);
		$query=$this->db->get();
		return $query->row_array();
	}
	
	
	//ADVERTISING
	function get_banner($country,$location,$position, $cat_id=null){
		$this->db->select('adb.id as id,adc.id as campaign_id,target_country, banner_location,file_type, type, redirect_url, target_value, counter, size_width,size_height');
		$this->db->from('adv_banners adb');
		$this->db->where('adb.target_country',$country);
		$this->db->join('adv_campaigns adc','adb.campaign_id=adc.id');
		$this->db->where('adc.active','1');
		$this->db->where('(adc.end_datetime > NOW() AND adc.start_datetime < NOW())');
		$this->db->join('adv_positions adp','adb.position=adp.id');
		$this->db->where('adp.source',$location);
		$this->db->where('adp.name',$position);
		if(!is_null($cat_id)){
			$this->db->join('adv_category_banners adcb','adb.id=adcb.banner_id');
			$this->db->where('adcb.category_id',$cat_id);
		}
		$this->db->where('((adb.target_value-adb.counter)>0 OR adb.target_value = 0)');
		$this->db->order_by('adb.id','RANDOM');
		$query=$this->db->get();
		return $query->row_array();
	}
	
	function get_single_banner($id){
		$this->db->from('adv_banners');
		$this->db->where('id',$id);
		$query=$this->db->get();
		return $query->row_array();
	}
	
	function insert_banner_statistic($files) {
		if($this->db->insert('adv_statistic', $files))
			return $this->db->insert_id();
		else
			return FALSE;
	}
	
	function update_counter($banner_id){
		$this->db->set('counter','counter+1',false);
		$this->db->where('id',$banner_id);
		return $this->db->update('adv_banners');
	}
}
?>