<?php
class Main_model extends CI_Model {

	function __constructl() {
		parent::__construct();

	}

	function get_news_by_type($type_id=1,$num=3,$lang='hr') {
		$this->db->from('articles');
		$this->db->where('published', '1');
		$this->db->where('category_type_id', $type_id);
		$this->db->where('name_'.$lang.' !=', '');
		$this->db->order_by('position', 'asc');
		$this->db->order_by('publish_datetime', 'desc');
		if($num!=0)
			$this->db->limit($num, 0);
		$query = $this->db->get();
		return $query->result_array();
	}


	function get_news($num, $offset, $cat_id,$lang='hr') {
		$this->db->from('articles');
		$this->db->where('published', '1');
		$this->db->where('category_type_id', $cat_id);
		$this->db->where('name_'.$lang.' !=', '');
		$this->db->order_by('position', 'asc');
		$this->db->order_by('publish_datetime', 'desc');
		$this->db->limit($num, $offset);
		$query = $this->db->get();
		return $query->result_array();

	}

	function get_front_items() {
		$this->db->from('calendar');
		$this->db->where('published', '1');
		$this->db->order_by('position', 'asc');
		$this->db->order_by('publish_datetime', 'asc');
		$this->db->limit(5, 0);
		$query = $this->db->get();
		return $query->result_array();

	}

	function get_slider() {
		$this->db->from('widget_slider');
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function get_frontpage_content() {
		$this->db->from('widget_frontpage_text');
		$query = $this->db->get();
		return $query->row_array();
	}
	

	function count_frontpage_news($cat_id,$lang='hr') {
		$this->db->from('articles');
		$this->db->where('category_type_id', $cat_id);
		$this->db->where('published', '1');
		$this->db->where('name_'.$lang.' !=', '');
		return $this->db->count_all_results();
	}


	function get_page($id) {
		$this->db->from('pages');
		$this->db->where('id', $id);
		$this->db->where('published', '1');
		$query = $this->db->get();
		return $query->row_array();
	}
	
	function get_page_by_name($name) {
		$this->db->from('pages');
		$this->db->where('name_hr', $name);
		$query = $this->db->get();
		return $query->row_array();
	}
	
	function get_pages_bytype($type_id,$lang="hr") {
		$this->db->from('pages');
		$this->db->where('category_type_id', $type_id);
		$this->db->where('parent_id', 0);
		$this->db->where('published', '1');
		$this->db->where('menu', '1');
		$this->db->where('name_'.$lang.' !=', '');
		$this->db->order_by('position', 'desc');
		$this->db->order_by('publish_datetime', 'asc');
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function get_subpages($parent_id) {
		$this->db->from('pages');
		$this->db->where('parent_id', $parent_id);
		$this->db->where('published', '1');
		$this->db->order_by('position', 'desc');
		$this->db->order_by('publish_datetime', 'asc');
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function get_pages_accordian($category_type_id=1,$parent = 0) {
		$pages = array();
		$this->db->from('pages');
		$this->db->where('parent_id', $parent);
		$this->db->order_by('position', 'desc');
		$this->db->where('category_type_id', $category_type_id);
		$this->db->where('published', 1);
		$this->db->where('menu', 1);
		$query = $this->db->get();

		foreach ($query->result_array() as $cat) {

			$pages[$cat['id']] = array(
				'id' => $cat['id'],
				'name_hr' => $cat['name_hr'],
				'url_hr' => $cat['url_hr'],
				'name_en' => $cat['name_en'],
				'url_en' => $cat['url_en'],
				'name_de' => $cat['name_de'],
				'url_de' => $cat['url_de'],
				'children' => array()
			);

			if ($this->page_has_child($cat['id'])) {
				$children = $this->get_pages_accordian($category_type_id,$cat['id']);
			}

			$pages[$cat['id']]['children'] = $children;

		}

		return $pages;
	}
	
	function page_has_child($cat_id) {
		$this->db->from('pages');
		$this->db->where('parent_id', $cat_id);
		$this->db->count_all_results();

		if ($this->db->count_all_results() > 0) {
			return TRUE;
		}
		return FALSE;

	}
	function get_single_news($id) {
		$this->db->from('articles');
		$this->db->where('id', $id);
		$this->db->where('published', 1);
		$query = $this->db->get();
		return $query->row_array();
	}

	function get_galleries($num, $offset,$type_id=1,$lang='hr') {
		$this->db->from('gallery');
		$this->db->where('category_type_id', $type_id);
		$this->db->where('published', '1');
		$this->db->where('name_'.$lang.' !=', '');
		$this->db->order_by('position','desc');
		$this->db->order_by('publish_datetime','desc');
		$this->db->limit($num, $offset);
		$query = $this->db->get();
		return $query->result_array();

	}

	function get_gallery($id) {
		$this->db->from('gallery');
		$this->db->where('id', $id);
		$this->db->where('published', '1');
		$query = $this->db->get();
		return $query->row_array();

	}

	function count_galleries($type_id=1,$lang="hr") {
		$this->db->from('gallery');
		$this->db->where('category_type_id', $type_id);
		$this->db->where('published', '1');
		$this->db->where('name_'.$lang.' !=', '');
		return $this->db->count_all_results();
	}

	function get_image($id) {
		$this->db->from('gallery_images');
		$this->db->where('gallery_id', $id);
		$this->db->limit(1, 0);
		$query = $this->db->get();
		return $query->row_array();

	}

	function get_images($id) {
		$this->db->from('gallery_images');
		$this->db->where('gallery_id', $id);
		$query = $this->db->get();
		return $query->result_array();

	}

	function get_gallery_parent($id) {
		$this->db->from('gallery');
		$this->db->where('parent_id', $id);
		$this->db->limit(1, 0);
		$query = $this->db->get();
		return $query->row_array();

	}

	function get_gallery_images($id) {
		$this->db->from('gallery_images');
		$this->db->where('gallery_id', $id);
		$query = $this->db->get();
		return $query->result_array();

	}
	
		function get_gallery_images_2($id) {
		$this->db->from('gallery_images');
		$this->db->where('gallery_id', $id);
		$query = $this->db->get();
		return $query->result();

	}

	function get_gallery_info($id) {
		$this->db->from('gallery');
		$this->db->where('id', $id);
		$query = $this->db->get();
		return $query->row_array();

	}

	function get_cat_item_info($id) {
		$this->db->from('category_items');
		$this->db->where('id', $id);
		$query = $this->db->get();
		return $query->row_array();

	}

	function count_gallery_images($id) {
		$this->db->from('gallery_images');
		$this->db->where('gallery_id', $id);
		return $this->db->count_all_results();
	}

	function get_catalog($id) {
		$this->db->from('category_items');

		if ($id != 0) {
			$this->db->where('category_id', $id);
		}

		$this->db->where('published', '1');
		$this->db->order_by('publish_datetime', 'desc');
		$query = $this->db->get();
		return $query->result_array();
	}

	function count_catalog($id) {
		$this->db->from('category_items');

		if ($id != 0) {
			$this->db->where('category_id', $id);
		}

		$this->db->where('published', '1');
		$this->db->order_by('publish_datetime', 'desc');
		return $this->db->count_all_results();
	}

	function get_catalog_menu() {
		$this->db->from('categories');
		$this->db->where('published', '1');
		$this->db->order_by('publish_datetime', 'desc');
		$query = $this->db->get();
		return $query->result_array();
	}

	function get_catalog_downloads($id) {
		$this->db->from('documents');
		$this->db->where('relevant_id', $id);
		$this->db->where('type', '3');
		$query = $this->db->get();
		return $query->result_array();
	}

	function get_latest_news($num) {
		$this->db->from('articles');
		$this->db->where('published', '1');
		$this->db->where('category_type_id', '1');
		$this->db->order_by('position', 'asc');
		$this->db->order_by('publish_datetime', 'desc');
		$this->db->limit($num, 0);
		$query = $this->db->get();
		return $query->result_array();
	}

	function get_latest_documents($num) {
		$this->db->from('widget_documents');
		$this->db->order_by('position', 'asc');
		$this->db->limit($num, 0);
		$query = $this->db->get();
		return $query->result_array();
	}

	function get_all_documents() {
		$this->db->from('widget_documents');
		$this->db->order_by('position', 'asc');
		$query = $this->db->get();
		return $query->result_array();
	}

	function get_single_event($id) {
		$this->db->from('calendar');
		$this->db->where('id', $id);
		$query = $this->db->get();
		return $query->row_array();
	}

	//ADVERTS
	function get_adverts($num, $offset, $category_id) {
		$this->db->from('category_items');
		if ($category_id != 0)
			$this->db->where('parent_id', $category_id);
		$this->db->where('published', '1');
		$this->db->order_by('position', 'asc');
		$this->db->order_by('publish_datetime', 'desc');
		$this->db->limit($num, $offset);
		$query = $this->db->get();
		return $query->result_array();
	}

	function get_single_advert($id) {
		$this->db->from('category_items');
		$this->db->where('id', $id);
		$this->db->where('published', '1');
		$query = $this->db->get();
		return $query->row_array();
	}
	
	function get_frontpage_adverts() {
		$this->db->from('category_items');
		$this->db->where('published', '1');
		$this->db->order_by('publish_datetime', 'desc');
		$this->db->limit(5, 0);
		$query = $this->db->get();
		return $query->result_array();
	}

	function get_advert_menu($parent_id) {
		$this->db->from('categories');
		$this->db->where('parent_id', $parent_id);
		$this->db->where('published', '1');
		$this->db->order_by('position', 'asc');
		$this->db->order_by('publish_datetime', 'desc');
		$query = $this->db->get();
		return $query->result_array();
	}

	function count_adverts($cat_id) {
		$this->db->from('category_items');
		if ($cat_id != 0)
			$this->db->where('parent_id', $cat_id);
		$this->db->where('published', '1');
		return $this->db->count_all_results();
	}

	function get_category($cat_id) {
		$this->db->from('categories');
		$this->db->where('id', $cat_id);
		$this->db->where('published', '1');
		$query = $this->db->get();
		return $query->row_array();
	}

	function get_categories() {
		$this->db->from('categories');
		$this->db->where('published', '1');
		$query = $this->db->get();
		return $query->result_array();

	}

	function get_user_ad($user_id) {
		$this->db->from('category_items');
		$this->db->where('created_by', $user_id);
		$query = $this->db->get();
		return $query->result_array();

	}
	
	
	function get_settings()

	{
		$this->db->from('settings');
		$query = $this->db->get();
		return $query->row_array();
			

	}
	

}
?>