<?php
class Listing_model extends CI_Model {

    function __constructl() {
        parent::__construct();
    }
	
	private $table='items';
	
	function get_user_items($user_id,$num = null, $offset = null) {
    	$this->db->distinct();
        $this->db->select('i.item_id,item_category,item_name ,item_content,item_budget, item_images, item_publish_datetime,item_sold, item_expired_datetime, ic.abbr as currency, uc.name as origin, ii.paths as image, item_published');
        $this->db->from('items i');
		$this->db->where('user_id',$user_id);
        $this->db->join('item_currencies ic', 'item_budget_currency = ic.id', 'left');
        $this->db->join('item_images ii', 'i.item_id = ii.item_id AND ii.default_img="1"', 'left');
        $this->db->join('util_countries uc', 'item_origin_id = uc.id', 'inner');
		$this->db->group_by('i.item_id');
		$this->db->order_by('i.item_publish_datetime','desc');
        if (!is_null($num) && !is_null($offset))
            $this->db->limit($num, $offset);
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }
	
	function count_item_offers($item_id){
        $this->db->from('item_offers io');
		$this->db->where('io.item_id',$item_id);
		$this->db->where('io.title IS NOT NULL');
        return $this->db->count_all_results();
		
	}
	
	function get_user_offers($user_id,$num = null, $offset = null) {
    	$this->db->distinct();
        $this->db->select('
        i.item_id,item_category,
        item_name ,
        item_content,
        item_budget, 
        item_images, 
        item_publish_datetime, 
        item_expired_datetime, 
        ic.abbr as currency, 
        uc.name as origin, 
        ii.paths as image, 
        item_published,
        io.budget as offer_budget,
        ic2.abbr as offer_currency');
        $this->db->from('items i');
		$this->db->where('io.user_id',$user_id);
		$this->db->join('item_offers io', 'i.item_id = io.item_id', 'left');
        $this->db->join('item_currencies ic', 'item_budget_currency = ic.id', 'left');
		$this->db->join('item_currencies ic2', 'io.budget_currency = ic2.id', 'left');
        $this->db->join('item_images ii', 'i.item_id = ii.item_id', 'left');
        $this->db->join('util_countries uc', 'item_origin_id = uc.id', 'inner');
		$this->db->group_by('i.item_id');
		$this->db->order_by('i.item_publish_datetime','desc');
        if (!is_null($num) && !is_null($offset))
            $this->db->limit($num, $offset);
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }
	
	function get_user_watchlist($user_id,$num = null, $offset = null) {
    	$this->db->distinct();
        $this->db->select('i.item_id,item_category,item_name ,item_content,item_budget, item_images, item_publish_datetime, item_expired_datetime, ic.abbr as currency, uc.name as origin, ii.paths as image, item_published');
        $this->db->from('items i');
		$this->db->where('iw.user_id',$user_id);
		$this->db->join('item_watchlist iw', 'i.item_id =iw.item_id', 'left');
        $this->db->join('item_currencies ic', 'item_budget_currency = ic.id', 'left');
        $this->db->join('item_images ii', 'i.item_id = ii.item_id', 'left');
        $this->db->join('util_countries uc', 'item_origin_id = uc.id', 'inner');
		$this->db->group_by('i.item_id');
		$this->db->order_by('i.item_publish_datetime','desc');
        if (!is_null($num) && !is_null($offset))
            $this->db->limit($num, $offset);
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }
	
	function insert($data){
		if($this->db->insert($this->table, $data))
			return $this->db->insert_id();
		else
			return false;
	}
	
	function purge_countries($item_id){
		$this->db->from('item_countries');
		$this->db->where('item_id',$item_id);
		return $this->db->delete();
	}
	
	function insert_country($data){
		return $this->db->insert('item_countries', $data);
	}
	
	function is_owner($user_id,$listing_id){
		$this->db->select('user_id');
		$this->db->from('items');
		$this->db->where('item_id',$listing_id);
		$query=$this->db->get();
		$result=$query->row_array();
		if(isset($result['user_id']) && $result['user_id']==$user_id)
			return true;
		else
			return false;
	}
	
	function select_offer($listing_id,$offer_id){
		$data=array(
		'selected_offer'=>$offer_id,
		'item_published'=>'2'
		);
		return $this->db->update($this->table, $data, array('item_id' => $listing_id));
	}
	
	function update($id,$data){
		return $this->db->update($this->table, $data, array('item_id' => $id));
	}
	
	//FILTERS
	function insert_filter($data){
		return $this->db->insert('item_properties', $data);
	}
	
	//IMAGES
	function insert_image($data){
		 if($this->db->insert('item_images', $data))
		 	return $this->db->insert_id();
		else
			return false;
	}
	
	function delete_image($item_id,$hash){
		$this->db->from('item_images');
		$this->db->where('item_id',$item_id);
		$this->db->where('name_hash',$hash);
		return $this->db->delete();
	}
	
	function get_images($item_id){
		$this->db->from('item_images');
		$this->db->where('item_id',$item_id);
        $this->db->order_by('default_img','desc');
		$query=$this->db->get();
		return $query->result_array();
	}
	function get_image($item_id,$hash){
		$this->db->from('item_images');
		$this->db->where('item_id',$item_id);
		$this->db->where('name_hash',$hash);
		$query=$this->db->get();
		return $query->row_array();
	}
	
	//DOCUMENTS
	function insert_document($data){
		return $this->db->insert('item_documents', $data);
	}
	
	function get_documents($item_id){
		$this->db->from('item_documents');
		$this->db->where('item_id',$item_id);
		$query=$this->db->get();
		return $query->result_array();
	}
	
	function count_documents($item_id){
		$this->db->from('item_documents');
		$this->db->where('item_id',$item_id);
		return $this->db->count_all_results();
	}
	
	function get_document($item_id,$hash){
		$this->db->from('item_documents');
		$this->db->where('item_id',$item_id);
		$this->db->where('name_hash',$hash);
		$query=$this->db->get();
		return $query->row_array();
	}

	function delete_document($item_id,$hash){
		$this->db->from('item_documents');
		$this->db->where('item_id',$item_id);
		$this->db->where('name_hash',$hash);
		return $this->db->delete();
	}

	//QUESTIONS
	function get_item_questions($lang){
		$this->db->from('item_questions iq');
		$this->db->join('item_questions_translations iqt','iq.id=iqt.question_id','left');
		$this->db->where('iqt.lang_id',$lang);
		$this->db->where('iq.published','1');
		$query=$this->db->get();
		return $query->result_array();
	}
	
	function get_single_questions($id,$lang){
		$this->db->from('item_questions iq');
		$this->db->join('item_questions_translations iqt','iq.id=iqt.question_id','left');
		$this->db->where('iq.published','1');
		$this->db->where('iq.id',$id);
		$this->db->where('iqt.lang_id',$lang);
		$query=$this->db->get();
		return $query->row_array();
	}

	function stat_single_views_by_date($item_id){
		$this->db->select('date, count');
		$this->db->from('item_statistics');
		$this->db->where('item_id',$item_id);
		$this->db->where('DATE BETWEEN NOW() - INTERVAL 30 DAY AND NOW()',null,false);
		$query = $this->db->get();
		return $query->result_array();
	}
}
?>