<?php
class Language_model extends CI_Model {

	function __constructl() {
		parent::__construct();
	}
	
	
	function list_languages(){
		$this->db->from('util_languages');
		$this->db->where('published','1');
		$query = $this->db->get();
		return $query->result_array();
	}
	
	
	function get_lang($id){
		$this->db->from('util_languages');
		$this->db->where('id', $id);
		$query = $this->db->get();
		return $query->row_array();
	}
	
	function get_lang_by_abb($abb){
		$this->db->from('util_languages');
		$this->db->where('abbr', $abb);
		$query = $this->db->get();
		return $query->row_array();
	}
	
	function get_country_by_abb($abb){
		$this->db->select('ul.id as id, ul.name as name, ul.abbr as abbr, uc.name as country_name, uc.id as country_id, uc.abbr_2 as country_abbr, sc.currency_id as currency_id,ic.off_abbr as curr_abbr, sc.domain as domain');
		$this->db->from('util_countries uc');
		$this->db->join('sys_countries sc','uc.id=sc.country_id AND uc.abbr_2="'.$abb.'"');
		$this->db->join('util_languages ul','sc.language_id=ul.id');
		$this->db->join('item_currencies ic','ic.id=sc.currency_id');
		$query = $this->db->get();
		return $query->row_array();
	}
	
	function get_settings($id,$attr='*'){
		$this->db->select($attr);
		$this->db->from('sys_country_settings');
		$this->db->where('country_id', $id);
		$query = $this->db->get();
		return $query->row_array();
	}
	
	function get_countries(){
		$this->db->from('util_countries');
		$query = $this->db->get();
		return $query->result_array();
	}

	function get_country_languages($country_id){
		$this->db->select('language_id');
		$this->db->from('sys_countries');
		$this->db->where('country_id',$country_id);
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function list_currencies() {
        $this->db->from('item_currencies');
        $query = $this->db->get();
        return $query->result_array();
    }
	
	function get_routes($lang_id){
		$this->db->distinct();
		$this->db->select('referrer,link');
		$this->db->from('routes');
		$this->db->where('lang_id', $lang_id);
		$query = $this->db->get();
		return $query->result_array();
	}
	
	
}
?>