<?php
class ext_model extends CI_Model {
	private $table;
	function __constructl($table) {
		parent::__construct();
	}
	
	function initialize($table){
		$this->table=$table;
	}

	function get_ids($attr,$filter=null){
		$this->db->distinct();
		$this->db->select($attr,false);
		$this->db->from($this->table);
		if(!is_null($filter))
				$this->db->where($filter);
		$this->db->order_by('name','asc');
		$query=$this->db->get();
		return $query->result_array();
	}

	function get_by_filter($country,$region, $cid, $filters, $input_filters=array(), $groups_number = null,$ex_filters, $ex_groups_number = null,$price_from=null,$price_to=null, $lang, $sort, $num = null, $offset = null) {
		if (is_null($groups_number))
			$groups_number = sizeof($filters);

		$query = 'SELECT DISTINCT
		  i.item_id as item_id,
		  i.item_name as item_name,
		  i.item_content as item_content,
		  i.item_expired_datetime as item_expired_datetime,
		  i.item_origin_id as item_origin_id,
		  i.item_budget as item_budget,
		  i.item_budget_currency as item_budget_currency,
		  i.item_category as item_category,
		  ic.off_abbr as currency,
		  uc.name as origin,
		  ip.property_id AS item_property,
		  ii.paths as image,
		  i.item_budget_currency,
		  i.item_video,
		  i.latlng,
		  i.item_sold,
		  IF(ic.off_abbr!="EUR", (item_budget / cr.exc_rate),item_budget) AS eur_price 
		FROM
		  items i';
		if (!is_null($country))
			$query .= ' INNER JOIN item_countries icnt ON i.item_id = icnt.item_id AND icnt.country_id=' . $country;
		if(!is_null($ex_filters)){
			$cntr=0;
			foreach($ex_filters as $type=>$id){
			$query .= ' INNER JOIN ext_properties ep'.$cntr.' ON ep'.$cntr.'.item_id = i.item_id AND ep'.$cntr.'.ext_type="' . $type.'" AND ep'.$cntr.'.ext_id="'.$id.'"';
			$cntr++;
			}
		}
		$query .= ' LEFT JOIN item_properties ip ON ip.item_id = i.item_id
		LEFT JOIN item_currencies ic ON item_budget_currency = ic.id
		LEFT JOIN util_eur_curr_rate cr ON cr.off_abbr=ic.off_abbr
		LEFT JOIN item_images ii ON i.item_id = ii.item_id AND ii.default_img="1"
		INNER JOIN util_countries uc ON item_origin_id = uc.id
		WHERE i.item_published="1" AND i.item_category IN (' . implode(',', $cid) . ')  AND item_expired_datetime > NOW()';

		if (is_array($lang) && !empty($lang)) {
			$lang_list = array();
			foreach ($lang as $l) {
				$lang_list[] = $l['language_id'];
			}
			$list = implode(',', $lang_list);
			$query .= ' AND i.lang_id IN(' . $list . ')';
		}
		if(!is_null($region))
			  $query .= ' AND i.item_region_id = '.$region;
		if(!is_null($filters))
			$query .= ' AND ip.property_id IN (' . implode(", ", $filters) . ')';
		if(!empty($input_filters)){
			$query .=' AND i.item_id in( SELECT item_id FROM item_properties ip WHERE ';
					$fcounter=0;
					foreach($input_filters as $key=>$ipf){
						if($fcounter>0)
							$query .=' AND ';	
						$query .='(ip.property_id='.$key.' AND ip.value='.$ipf.') ';
						$fcounter++;
					}
			$query .='  )';
		}

		$query .= ' 
		GROUP BY 
		  i.item_id';
		if(!is_null($filters)){
			$query .= '	HAVING COUNT(DISTINCT ip.property_id) =' . $groups_number;
			if(!is_null($price_from))
			$query.=' AND eur_price >= '.$price_from;
			if(!is_null($price_to)){
				if($price_to=='1000+')
					$query.=' AND eur_price > 1000 ';
				else
					$query.=' AND eur_price <= '.$price_to;
			}
		}
		else{
			if(!is_null($price_from))
			$query.=' HAVING eur_price >= '.$price_from;
			if(!is_null($price_to) && is_null($price_from)){
				if($price_to=='1000+')
					$query.=' HAVING eur_price > 1000 ';
				else
					$query.=' HAVING eur_price <= '.$price_to;
			}
			if(!is_null($price_to) && !is_null($price_from)){
				if($price_to=='1000+')
					$query.=' AND eur_price > 1000 ';
				else
					$query.=' AND eur_price <= '.$price_to;
			}
		}
		$query.='
		  ORDER BY';
		if (is_array($sort)) {
			foreach ($sort as $key => $value) {
				$query .= ' ' . $key . ' ' . $value;
			}
		}
		if (!is_null($num) && !is_null($offset))
			$query .= ' LIMIT ' . $offset . ', ' . $num;
		$query = $this->db->query($query);
		$result = $query->result_array();
		if (!empty($result))
			return $result;
		else
			return false;
	}

	function count_by_filter($country,$region, $cid, $filters, $groups_number = null,$ex_filters, $ex_groups_number = null,$price_from=null,$price_to=null, $lang) {
		if (is_null($groups_number))
			$groups_number = sizeof($filters);
		$query = 'SELECT
		  i.item_id as item_id,
		  ip.property_id AS item_property 
		FROM
		  items i';
		if (!is_null($country))
			$query .= ' INNER JOIN item_countries icnt ON i.item_id = icnt.item_id AND icnt.country_id=' . $country;
		if(!is_null($ex_filters)){
			$cntr=0;
			foreach($ex_filters as $type=>$id){
			$query .= ' INNER JOIN ext_properties ep'.$cntr.' ON ep'.$cntr.'.item_id = i.item_id AND ep'.$cntr.'.ext_type="' . $type.'" AND ep'.$cntr.'.ext_id="'.$id.'"';
			$cntr++;
			}
		}
		$query .= ' LEFT JOIN item_properties ip ON ip.item_id = i.item_id
		  WHERE i.item_published="1" AND i.item_category IN (' . implode(',', $cid) . ') AND item_expired_datetime > NOW()';
		if(!is_null($region))
			  $query .= ' AND i.item_region_id = '.$region;
		if (is_array($lang) && !empty($lang)) {
			$lang_list = array();
			foreach ($lang as $l) {
				$lang_list[] = $l['language_id'];
			}
			$list = implode(',', $lang_list);
			$query .= ' AND i.lang_id IN(' . $list . ')';
		}
		if(!is_null($price_from))
			$query.=' AND i.item_budget >= '.$price_from;
		if(!is_null($price_to)){
			if($price_to=='1000+')
				$query.=' AND i.item_budget > 1000 ';
			else
				$query.=' AND i.item_budget <= '.$price_to;
		}
			
		if(!is_null($filters))
			$query .= ' AND ip.property_id IN (' . implode(", ", $filters) . ')';

		$query .= ' 
		GROUP BY 
		  i.item_id';
		if(!is_null($filters))
			$query .= '	HAVING COUNT(DISTINCT ip.property_id) =' . $groups_number;
		$query = $this->db->query($query);
		$result = $query->result_array();
		if (!empty($result))
			return sizeof($result);
		else
			return false;
	}
	

	function fetch_short_data($item_id,$ext_table){
		switch ($ext_table) {
			case 'ext_cars':
				return $this->fetch_cars($item_id);
				break;
			
			default:
				return false;
				break;
		}
	}
	
	function fetch_cars($id){
		$prop=$this->db->from('ext_properties ep')
                    ->where('item_id',$id)
                    ->order_by('level','asc')
                    ->get()
                    ->result_array();

        if(!empty($prop)){
        	$result=array();
        	foreach($prop as $p){
        		switch ($p['level']) {
        			case '1':
        				$column='model_make_id';
        				$target='model_make_display';
        				break;
        			case '2':
        				$column='model_name';
        				$target='model_name';
        				break;
        			case '3':
        				$column='model_id';
        				$target='model_trim';
        				break;
        			default:
        				# code...
        				break;
        		}
        		$result[]=$this->db->select($target)
        						->from('ext_cars')
        						->where($column,$p['ext_id'])
        						->get()->row_array();
        	}
        	return $result;
        }      	      
        return false;
	}

}
?>