<?php if( ! defined('BASEPATH') ) exit('No direct script access allowed');
/**
 * Community Auth - User_model Model
 *
 * Community Auth is an open source authentication application for CodeIgniter 2.1.1
 *
 * @package     Community Auth
 * @author      Robert B Gottier
 * @copyright   Copyright (c) 2011 - 2012, Robert B Gottier. (http://brianswebdesign.com/)
 * @license     BSD - http://http://www.opensource.org/licenses/BSD-3-Clause
 * @link        http://community-auth.com
 */

class Users_model extends MY_Model {

	/**
	 * An array holding values necessary for pagination of users
	 * in the Manage Users area of the adminstration
	 *
	 * @var array
	 * @access private
	 */
	private $query_params = array();

	/**
	 * Class Constructor
	 */
	public function __construct()
	{
		parent::__construct();
	}
	
	
	
	function list_users() {

		$this->db->from('users');
		$this->db->where('user_level !=', '9');
		$this->db->order_by('user_date', 'asc');
		$query = $this->db->get();
		return $query->result();

	}
	
	function get_user($user_id) {
	
	$this->db->from('users');
	$this->db->where('users.user_id', $user_id);
	$this->db->join('user_profiles', 'user_profiles.user_id = users.user_id');
	
	$query = $this->db->get();
		return $query->row_array();
	}
	
	

	// --------------------------------------------------------------

	/**
	 * Create a new user
	 * 
	 * @param   array  pre-validated data to insert into the user and profile records
	 * @return  bool
	 */
	public function create_user( $insert_array = array(),  $type = 'standard' )
	{
		// The form validation class doesn't allow for multiple config files, so we do it the old fashion way
		//$this->config->load( 'form_validation/administration/create_user' );
		//$this->validation_rules = config_item( $type . '_user_creation_rules' );

		// If the data is already validated, there's no reason to do it again
		if( ! empty( $insert_array ))
		{
			// Prepare user_data array for insert into user table
			$user_data = array(
				'user_name'  => ( isset( $insert_array['user_name'] ) ) ? $insert_array['user_name'] : set_value('user_name'),
				'user_pass'  => ( isset( $insert_array['user_pass'] ) ) ? $insert_array['user_pass'] : set_value('user_pass'),
				'user_email' => ( isset( $insert_array['user_email'] ) ) ? $insert_array['user_email'] : set_value('user_email'),
				'user_level' => ( isset( $insert_array['user_level'] ) ) ? $insert_array['user_level'] : set_value('user_level'),
				'user_banned' => ( isset( $insert_array['user_level'] ) ) ? $insert_array['user_banned'] : set_value('user_banned')
			);



		
				unset( $insert_array['user_name'] );
				unset( $insert_array['user_pass'] );
				unset( $insert_array['user_email'] );
				unset( $insert_array['user_level'] );
				unset( $insert_array['user_banned'] );

				// Profile data is insert array
				$profile_data = $insert_array;
			

			// Encrypt any sensitive data
			$this->load->library('encrypt');
			$profile_data['license_number'] = $this->encrypt->encode( $profile_data['license_number'] );

			// Create a random user id if not already set
			$random_unique_int = $this->get_unused_id();

			// Generate random user salt
			$user_salt = $this->authentication->random_salt();

			// Perform transaction
			$this->db->trans_start();

			$user_data['user_id']       = $random_unique_int;
			$user_data['user_pass']     = $this->authentication->hash_passwd( $user_data['user_pass'], $user_salt );
			$user_data['user_salt']     = $user_salt;
			$user_data['user_date']     = time();
			$user_data['user_modified'] = time();

			// Insert data in user table
			$this->db->set($user_data)
						->insert($this->config->item('user_table'));

			$profile_data['user_id'] = $random_unique_int;

			// Insert data in profile table
			$this->db->set($profile_data)
						->insert($this->config->item('profiles_table'));

			// Complete transaction
			$this->db->trans_complete();

			// Verify transaction was successful
			if( $this->db->trans_status() !== FALSE )
			{
				// Load var to confirm user inserted into database
				$this->load->vars( array( 'user_created' => 1 ) );
			}

			return TRUE;
		}

		return FALSE;
	}


	public function delete_user( $user_id)
	{
		
		$this->db->delete('user_profiles', array('user_id' => $user_id));
		return $this->db->delete('users', array('user_id' => $user_id));
	}

	public function update_user( $the_user, $update_type, $update_array = array(), $profile_arr = array() )
	{
		
		$user_salt = $this->authentication->random_salt();
		
		
		$user_data = array(
				'user_name'  => ( isset( $update_array['user_name'] ) ) ? $update_array['user_name'] : set_value('user_name'),
				'user_email' => ( isset( $update_array['user_email'] ) ) ? $update_array['user_email'] : set_value('user_email'),
				'user_level' => ( isset( $update_array['user_level'] ) ) ? $update_array['user_level'] : set_value('user_level'),
				'user_banned' => ( isset( $update_array['user_banned'] ) ) ? $update_array['user_banned'] : set_value('user_banned')
			);
			
			
			$profile_data = array(
				'first_name'  => ( isset( $profile_arr['first_name'] ) ) ? $profile_arr['first_name'] : set_value('first_name'),
				'last_name'  => ( isset( $profile_arr['last_name'] ) ) ? $profile_arr['last_name'] : set_value('last_name')
			);
		
		if(!empty($update_array['user_pass']) && $update_array['user_pass'] == $update_array['user_pass_confirm']){
		$user_data['user_pass']     = $this->authentication->hash_passwd( $update_array['user_pass'], $user_salt );
		$user_data['user_salt']     = $user_salt;
		}
		
		$user_data['user_modified'] = time();
		

			

			$this->db->where('user_id', $the_user);
			return $this->db->update( 'users', $user_data );
					
					

				$this->db->where('user_id', $the_user);
				return $this->db->update('user_profiles', $profile_data);
				
				
			
	
	}



	public function get_recovery_data( $email )
	{
		$query = $this->db->select('u.user_id, u.user_salt, u.user_email, u.user_banned')
			->from($this->config->item('user_table') . ' u')
			->where('u.user_email', $email)
			->limit(1)
			->get();

		if( $query->num_rows() == 1 )
		{
			return $query->row();
		}

		return FALSE;
	}

	// --------------------------------------------------------------

	/**
	 * Validation and processing for password change during account recovery
	 */
	public function recovery_password_change()
	{
		// The form validation class doesn't allow for multiple config files, so we do it the old fashion way
		$this->config->load( 'form_validation/user/recovery_verification' );
		$this->validation_rules = config_item('recovery_verification');

		if( $this->validate() )
		{
			$this->_change_password(
				set_value('user_pass'),
				set_value('user_pass_confirm'),
				$this->input->post('user_identification'),
				$this->input->post('old_salt')
			);
		}
	}

	// --------------------------------------------------------------

	/**
	 * Change a user's password
	 * 
	 * @param  string  the form token
	 * @param  string  the flash token to match the form token
	 * @param  string  the new password
	 * @param  string  the new password confirmed
	 * @param  string  the user ID
	 * @param  string  the special string
	 */
	protected function _change_password( $password, $password2, $user_id, $special_string )
	{
		// User ID check
		if( isset( $user_id ) && $user_id !== FALSE )
		{
			$this->db->select('user_id');

			// If special string is the CI encryption key, this is a self update or user update.
			if( $special_string == config_item('encryption_key') )
			{
				$this->db->where( 'user_id', $user_id );
			}

			// If the special string was not present, this is a password recovery
			else
			{
				$this->db->where( 'user_id', $user_id );
				$this->db->where( 'user_salt', $special_string );
			}

			$query = $this->db->get_where( $this->config->item('user_table') );

			// If above query indicates a match, change the password
			if( $query->num_rows() == 1 )
			{
				$user_data = $query->row();

				// Generate a new random user salt
				$new_salt = $this->authentication->random_salt();

				$data = array(
					'user_pass' => $this->authentication->hash_passwd( $password, $new_salt ),
					'user_salt' => $new_salt
				);

				$this->db->where( 'user_id', $user_data->user_id )
					->update( $this->config->item('user_table'), $data );
			}
		}
	}

	// --------------------------------------------------------------

	/**
	 * Get a user record by user ID
	 * 
	 * @param   int    the user ID
	 * @return  mixed  either the query data or FALSE
	 */
	public function view_user_record( $user_id, $fields = FALSE )
	{
		if( (int) $user_id !== 0 )
		{
			if( $fields === FALSE )
			{
				$this->db->select('u.*, p.*');
			}
			else
			{
				$this->db->select( $fields );
			}

			$this->db->from($this->config->item('user_table') . ' u')
				->join($this->config->item('profiles_table') . ' p','u.user_id = p.user_id', 'left')
				->where('p.user_id', $user_id)
				->limit(1);

			$query = $this->db->get();
			
			if( $query->num_rows() == 1 )
			{
				return $query->row();
			}
		}

		return FALSE;
	}

	// --------------------------------------------------------------

	/**
	 * Perform either the count or data query for a specific set or users
	 *
	 * Query params are set the first time this method is called, which
	 * is during the count of all of the user records that fit the 
	 * specific set we are searching. Because we are using a class member 
	 * to hold these params, we don't have to send them twice when the 
	 * method is called the second time, which is when we get the actual 
	 * user data
	 *
	 * @param   array   the values to obtain a custom set of users
	 * @param   bool    whether or not the query is the count
	 * @return  mixed   either int, query data as an object, or FALSE
	 */
	public function manage_user_records_data( $params = FALSE, $count = FALSE )
	{
		// Set params if this is the first call
		if( $params !== FALSE )
		{
			$this->query_params = $params;

			// Compute / set the offset for the query
			$this->query_params['offset'] = ( $params['page'] * $params['limit'] ) - $params['limit'];
		}

		// If this is the actual data query, we want to add a SELECT to our query
		if( ! $count )
		{
			$this->db->select('u.*, p.*');
		}

		$this->db->from($this->config->item('user_table') . ' u');
		$this->db->join($this->config->item('profiles_table') . ' p','u.user_id = p.user_id', 'left');
		$this->db->where('u.user_level <', $this->query_params['user_level'] );

		// If this is a search, it may change the number of results
		if( ! empty( $this->query_params['search_in'] ) && ! empty( $this->query_params['search_for'] ) )
		{
			$this->db->like( $this->query_params['search_in'], $this->query_params['search_for'] );
		}

		// If this is the row count
		if( $count )
		{
			return $this->db->count_all_results();
		}

		// If this is the data query
		else
		{
			// Set the limit / offset
			$this->db->limit( $this->query_params['limit'], $this->query_params['offset'] );

			// Order by user creation date so newest users appear first
			$this->db->order_by( 'user_date', 'desc' );

			$query = $this->db->get();

			// Return data if there is any
			if( $query->num_rows() > 0 )
			{
				return $query->result();
			}
		}

		return FALSE;
	}

	/**
	 * Get an unused ID for user creation
	 * 
	 * @param   bool  whether to generate a user Id or registration ID
	 * @return  int
	 */
	public function get_unused_id( $temp = FALSE )
	{
		// Create a random user id
		$random_unique_int = mt_rand(1200,999999999);

		// Make sure the random user_id isn't already in use
		if($temp === FALSE)
		{
			// Generate unused user ID
			$query = $this->db->where('user_id', $random_unique_int)
								->get_where($this->config->item('user_table'));
		}
		else
		{
			// Generate unused registration ID
			$query = $this->db->where('reg_id', $random_unique_int)
								->get_where($this->config->item('temp_reg_data_table'));
		}

		if ($query->num_rows() > 0)
		{
			$query->free_result();

			// If the random user_id is already in use, get a new number
			$this->get_unused_id($temp);
		}

		return $random_unique_int;
	}

	// --------------------------------------------------------------

	/**
	 * Get the username by supplying the user ID and old password
	 * 
	 * @param   int     the user ID
	 * @param   string  the current user salt
	 * @return  mixed   either string or FALSE
	 */
	public function get_username_for_recovery( $user_id, $old_salt )
	{
		// Check if password recovery link has a usable URL
		$query = $this->db->select('user_name')
			->from( $this->config->item('user_table') )
			->where( 'user_id', $user_id )
			->where( 'user_salt', $old_salt )
			->limit(1)
			->get();

		if ( $query->num_rows() == 1 )
		{
			// If there is a user match, send the username back
			$user_data = $query->row();

			return $user_data->user_name;
		}
		
		return FALSE;
	}

	// --------------------------------------------------------------

}
	function last_row($user_name) {
		$this->db->from('users');
		$this->db->where(1, 0);
		$this->db->order_by('id', 'desc');
		$query = $this->db->get();
		return $query->row_array();
	}