<?php
class Testimonial_model extends CI_Model {

	function __constructl() {
		parent::__construct();

	}

	function get_participant($id) {
		$query = $this->db->get_where('participants', array('id' => $id));
		return $query->row_array();
	}

	function get_contract($id) {
		$query = $this->db->get_where('testimonial', array('id' => $id));
		return $query->row_array();
	}

	function check_id($id) {
		$query = $this->db->get_where('testimonial', array('degree_id' => $id));
		return $query->row_array();
	}

	function get_program_name($id) {
		$this->db->from('languages');
		$this->db->where('id', $id);
		$query = $this->db->get();
		return $query->row_array();
	}

	function get_school($id) {
		$this->db->from('schools');
		$this->db->where('id', $id);
		$query = $this->db->get();
		return $query->row_array();
	}

	function get_teacher($id) {
		$this->db->from('teachers');
		$this->db->where('id', $id);
		$query = $this->db->get();
		return $query->row_array();
	}

	function get_degree($id) {
		$this->db->from('participants_degrees pd');
		$this->db->where('pd.id', $id);
		$this->db->join('degrees d', 'd.id = pd.degree', 'left');
		$query = $this->db->get();
		return $query->row_array();
	}

	function list_testimonial($year, $sid) {
		$this->db->from('testimonial');
		$this->db->where('YEAR(datetime)', date($year));
		$this->db->where('school_id', $sid);
		$this->db->order_by('datetime', 'desc');
		$query = $this->db->get();
		return $query->result();

	}

	function years() {
		$query = $this->db->query('SELECT DISTINCT YEAR(datetime) as y FROM testimonial');
		return $query->result();
	}

	function insert($files) {
		return $this->db->insert('testimonial', $files);
	}

	function update($id, $files) {
		return $this->db->update('testimonial', $files, array('id' => $id));
	}

	function delete($id) {
		return $this->db->delete('testimonial', array('id' => $id));
	}

	function last_row() {
		$this->db->from('testimonial');
		$this->db->limit(1, 0);
		$this->db->order_by('id', 'desc');
		$query = $this->db->get();
		return $query->row_array();
	}

	function new_id($sid) {
		//$query= "SELECT * FROM testimonial WHERE YEAR(datetime) = 2011 AND MONTH(Date) = 5";
		$this->db->from('testimonial');
		$this->db->select_max('id_order');
		$this->db->where('YEAR(datetime)', date("Y"));
		$this->db->where('school_id', $sid);
		$query = $this->db->get();
		return $query->row_array();
	}

	function list_degrees($pid) {
		$this->db->from('testimonial_degrees');
		$this->db->where('testimonial_id', $pid);
		$this->db->order_by('start_date', 'desc');
		$query = $this->db->get();
		return $query->result();

	}

	function insert_degree($files) {
		return $this->db->insert('testimonial_degrees', $files);
	}

	function update_degree($id, $files) {
		return $this->db->update('testimonial_degrees', $files, array('id' => $id));
	}

	function get_settings() {
		$query = $this->db->get_where('settings', array('id' => '1'));
		return $query->row_array();
	}

}
?>