<?php
class Pages_model extends CI_Model {

	function __constructl() {
		parent::__construct();
	}
	
	function get_pages_datagrid($attr_lis=array('*'),$parent_id=null){
		$this->db->select($attr_lis);
		$this->db->from('pages');
		$this->db->where('parent_id',(int)$parent_id);
		//$this->db->order_by('position','asc');
		$query = $this->db->get();
		$result=$query->result_array();
		if(sizeof($result)>0)
			return $result;
		else
			return false;
	}
	
	function count_pages($parent_id){
		$this->db->select('id');
		$this->db->from('pages');
		$this->db->where('parent_id',(int)$parent_id);
		return $this->db->count_all_results();
	}
	
	
	
	function get_page($id){
		$this->db->from('pages');
		$this->db->where('id',$id);
		$query = $this->db->get();
		return $query->row_array();
	}
	
	function get_page_trans($id){
		$this->db->from('pages_translations');
		$this->db->where('page_id',$id);
		$query = $this->db->get();
		return $query->row_array();
	}
	
	function get_page_trans_bylang($id,$country){
		$this->db->select('sc.country_id as c_id, uc.name as name, pt.title as title, pt.content as content');
		$this->db->from('sys_countries sc');
		$this->db->where_in('sc.country_id',$country);
		$this->db->join('util_countries uc','sc.country_id=uc.id','left');
		$this->db->join('pages_translations pt', 'sc.country_id = pt.country AND pt.page_id='.$id,'left',true);
		
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function get_languages($country){
		$this->db->from('sys_countries');
		$this->db->where_in('country_id',$country);
		
	}
	
	
	
	
	function insert($files) {
		if($this->db->insert('pages', $files))	
			return $this->db->insert_id();
		else
			return FALSE;
	}
	
	function insert_data($files) {
		return $this->db->insert('pages_translations', $files);

	}
	
	function check_country($type,$country){
		$this->db->from('pages_translations');
		$this->db->where('page_id', $type);
		$this->db->where('country', $country);
		$count=$this->db->count_all_results();
		if($count>0)
			return TRUE;
		else 
			return FALSE;
		
	}
	
	function update($id, $files) {
		return $this->db->update('pages', $files, array('id' => $id));
	}
	
	function update_data($id,$country, $files) {
		return $this->db->update('pages_translations', $files, array('page_id' => $id,'country'=>$country));
	}
	
	// UPDATING POSITION
	function update_position($id, $files) {
		return $this->db->update('pages', $files, array('id' => $id));
	}

	function delete($id) {
		return $this->db->delete('pages', array('id' => $id));

	}
}
?>