<?php
class Members_model extends CI_Model {

	function __constructl() {
		parent::__construct();

	}

	function list_members($institution, $payment, $year) {

		$this->db->select('m.id as id, 
		m.first_name as first_name, 
		m.last_name as last_name, 
		m.oib as oib, 
		i.institution_name as institution_name, 
		d.department_name as department_name,
		t.type_name as type_name,
		p.member_id as member_id
		');
		$this->db->from('members m');
		$this->db->join('institution i', 'm.institution=i.id');
		$this->db->join('types t', 'm.type=t.id');
		$this->db->join('department d', 'm.department=d.id', 'left');
		$this->db->join('payments p', 'm.id=p.member_id AND p.year = "' . $year . '"', 'left');
		if (!is_null($institution))
			$this->db->where('m.institution', $institution);
		if (!is_null($payment)) {
			if ($payment == 'da')
				$this->db->where('p.member_id IS NOT NULL', null, false);
			else
				$this->db->where('p.member_id IS NULL', null, false);
		}

		$this->db->order_by('m.datetime', 'desc');
		$query = $this->db->get();
		return $query->result();

	}

	function list_members_csv($institution, $payment, $year) {

		$this->db->select('m.id as id, 
		m.first_name as first_name, 
		m.last_name as last_name, 
		m.oib as oib, 
		i.institution_name as institution_name, 
		d.department_name as department_name,
		t.type_name as type_name,
		p.member_id as member_id
		');
		$this->db->from('members m');
		$this->db->join('institution i', 'm.institution=i.id');
		$this->db->join('types t', 'm.type=t.id');
		$this->db->join('department d', 'm.department=d.id');
		$this->db->join('payments p', 'm.id=p.member_id AND p.year = "' . $year . '"', 'left');
		if (!is_null($institution))
			$this->db->where('m.institution', $institution);
		if (!is_null($payment)) {
			if ($payment == 'da')
				$this->db->where('p.member_id IS NOT NULL', null, false);
			else
				$this->db->where('p.member_id IS NULL', null, false);
		}

		$this->db->order_by('m.datetime', 'desc');
		$query = $this->db->get();
		return $query->result_array();

	}

	function list_payments($member_id) {
		$this->db->from('payments');
		$this->db->where('member_id', $member_id);
		$this->db->order_by('date', 'desc');
		$query = $this->db->get();
		return $query->result();

	}

	function list_selected_languages($tid) {
		$this->db->from('teacher_languages');
		$this->db->where('teacher_id', $tid);
		$query = $this->db->get();
		return $query->result();

	}

	function years() {
		$query = $this->db->query('SELECT DISTINCT YEAR(datetime) as y FROM members');
		return $query->result();
	}

	function insert($files) {
		return $this->db->insert('members', $files);
	}

	function update($id, $files) {
		return $this->db->update('members', $files, array('id' => $id));
	}

	function delete($id) {

		return $this->db->delete('members', array('id' => $id));
	}

	function delete_payment($id) {

		return $this->db->delete('payments', array('id' => $id));
	}

	function get_member($id) {
		$query = $this->db->get_where('members', array('id' => $id));
		return $query->row_array();
	}

	function get_institution() {
		$this->db->from('institution');
		$this->db->order_by('institution_name', 'asc');
		$query = $this->db->get();
		return $query->result();
	}

	function get_types() {
		$query = $this->db->get_where('types');
		return $query->result();
	}

	function get_departments() {
		$query = $this->db->get_where('department');
		return $query->result();
	}

	function last_row() {
		$this->db->from('members');
		$this->db->limit(1, 0);
		$this->db->order_by('id', 'desc');
		$query = $this->db->get();
		return $query->row_array();
	}

	function new_id() {
		//$query= "SELECT * FROM members WHERE YEAR(datetime) = 2011 AND MONTH(Date) = 5";
		$this->db->from('members');
		$this->db->select_max('id_order');
		$this->db->where('YEAR(datetime)', date("Y"));
		$query = $this->db->get();
		return $query->row_array();
	}

	function single_institution($id) {
		$this->db->from('institution');
		$this->db->where('id', $id);
		$query = $this->db->get();
		return $query->row_array();
	}

	function insert_payment($files) {
		return $this->db->insert('payments', $files);
	}

	// function update_top($id, $files) {
	// $this->db->set($files);
	// $this->db->update('members', $files, array('id' => $id));
	// }

}
?>