<?php
class Listings_model extends CI_Model {

	function __constructl() {
		parent::__construct();

	}
	
	//STATISTIC
	function stat_count_listings_by_date($country=null,$from=null,$to=null){
		$this->db->select('date(item_insert_datetime) as date, count(item_id) as num');
		$this->db->from('items');
		if(!is_null($country))
			$this->db->where_in('item_portal',$country);
		if(!is_null($from))
			$this->db->where('item_insert_datetime >',$form);
		if(!is_null($to))
			$this->db->where('item_insert_datetime <',$to);
		$this->db->where('item_status','1');
		$this->db->where('item_published','1');
		$this->db->group_by('date');
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function stat_count_offers_by_date($country=null,$from=null,$to=null){
		$this->db->select('date(offer_datetime) as date, count(id) as num');
		$this->db->from('item_offers');
		if(!is_null($country)){
			$this->db->join('items i','item_offers.item_id=i.item_id');
			$this->db->where_in('i.item_portal',$country);
		}
		if(!is_null($from))
			$this->db->where('offer_datetime >',$form);
		if(!is_null($to))
			$this->db->where('offer_datetime <',$to);
		$this->db->where('published','1');
		$this->db->group_by('date');
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function stat_total_listngs($country=null){
		$this->db->from('items');
		if(!is_null($country))
			$this->db->where_in('item_portal',$country);
		return $this->db->count_all_results();
	}
	
	function stat_total_views($country=null){
		$this->db->select('SUM(is1.count) as total, i.item_status, i.item_published',false);
		$this->db->from('item_statistics is1');
		if(!is_null($country)){
			$this->db->join('items i','is1.item_id=i.item_id');
			$this->db->where_in('i.item_portal',$country);
		}
		else
			$this->db->join('items i','is1.item_id=i.item_id',false);
		$this->db->where('i.item_status','1');
		$this->db->where('i.item_published','1');
		$query = $this->db->get();
		return $query->row_array();
	}
	
	function stat_single_total_views($item_id){
		$this->db->select('SUM(count) as total',false);
		$this->db->from('item_statistics');
		$this->db->join('items','item_statistics.item_id=items.item_id AND items.item_id='.$item_id,false);
		$query = $this->db->get();
		return $query->row_array();
	}
	
	function stat_single_views_by_date($item_id){
		$this->db->select('date, count');
		$this->db->from('item_statistics');
		$this->db->where('item_id',$item_id);
		$query = $this->db->get();
		return $query->result_array();
	}
	
	//END STATISTIC

	
	function get_listings($category_id=null,$published=null, $country=null){
		$this->db->from('items');
		if(!is_null($category_id))
			$this->db->where('item_category',(int)$category_id);
		if(!is_null($published))
			$this->db->where('item_published',(string)$published);
		if(!is_null($country))
			$this->db->where_in('item_portal',$country);
		$this->db->where('item_status','1');
		$this->db->order_by('item_publish_datetime','desc');
		$query = $this->db->get();
		$result=$query->result_array();
		if(sizeof($result)>0)
			return $result;
		else
			return false;
	}
	
	function get_listings_datagrid($attr_lis=array('*'),$category_id=null,$published=null,$country=null){
		$this->db->select($attr_lis);
		$this->db->from('items');
		if(!is_null($category_id))
			$this->db->where('item_category',(int)$category_id);
		if(!is_null($published))
			$this->db->where('item_published',(string)$published);
		if(!is_null($country))
			$this->db->where_in('item_portal',$country);
		$this->db->where('item_status','1');
		$this->db->order_by('item_publish_datetime','desc');
		$query = $this->db->get();
		$result=$query->result_array();
		if(sizeof($result)>0)
			return $result;
		else
			return false;
	}
	
	function count_listings($category_id=null,$published=null,$country=null){
		$this->db->select('item_id');
		$this->db->from('items');
		if(!is_null($category_id))
			$this->db->where('item_category', $category_id);
		if(!is_null($published))
			$this->db->where('item_published', $published);
		if(!is_null($country))
			$this->db->where_in('item_portal',$country);
		// if(!is_null($lang))
			// $this->db->where('lang_id', $lang);
		// if(!is_null($origin))
			// $this->db->where('item_origin', $origin);
		$this->db->where('item_status','1');
		return $this->db->count_all_results();
	}
	
	function get_listing($id){
		$this->db->from('items');
		$this->db->where('item_id',$id);
		$query = $this->db->get();
		$result=$query->row_array();
		if(sizeof($result)>0)
			return $result;
		else
			return false;
	}
	
	function get_listing_notifications($id){
		$this->db->from('user_notifications');
		$this->db->where('item_id',$id);
		$this->db->order_by('id','desc');
		$query = $this->db->get();
		$result=$query->result_array();
		if(sizeof($result)>0)
			return $result;
		else
			return false;
	}

	function delete_listing($id) {
		return $this->db->delete('items', array('item_id' => $id));

	}

	function get_documents($item_id){
		$this->db->from('item_documents');
		$this->db->where('item_id',$item_id);
		$query=$this->db->get();
		return $query->result_array();
	}

	function get_images($item_id){
		$this->db->from('item_images');
		$this->db->where('item_id',$item_id);
		$query=$this->db->get();
		return $query->result_array();
	}
	
	//FILTRIRANJE

//GRUPE SVOJSTAVA POJEDINE KATEGORIJE
	function get_category_properties_groups($category_id){
		$this->db->from('category_properties cp');
		$this->db->where('cp.category_id',$category_id);
		$this->db->join('properties_groups pg', 'pg.id = cp.group_id');
		//$this->db->join('properties p', 'p.group_id = pg.id');
		$query = $this->db->get();
		$result=$query->result_array();
		if(!empty($result))
			return $result;
		else 
			return false;
	}
//SVOJSTVA POJEDINE GRUPE	
	function get_category_properties($group_id){
		$this->db->from('properties');
		$this->db->where('group_id',$group_id);
		$query = $this->db->get();
		$result=$query->result_array();
		if(!empty($result))
			return $result;
		else 
			return false;
	}
	
	function get_item_properties($item_id){
		$this->db->from('item_properties');
		$this->db->where('item_id',$item_id);
		$query = $this->db->get();
		$result=$query->result_array();
		if(!empty($result))
			return $result;
		else 
			return false;
	}
	
	function get_item_countries($id){
		$this->db->from('item_countries');
		$this->db->where('item_id', $id);
		$query = $this->db->get();
		$result = $query->result_array();
		if (!empty($result))
			return $result;
		else
			return false;
	}
	
	//UPDATE
	function update($id, $files) {
		return $this->db->update('items', $files, array('item_id' => $id));
	}
	
	function purge_countries($item_id){
		$this->db->from('item_countries');
		$this->db->where('item_id',$item_id);
		return $this->db->delete();
	}
	
	function insert_country($data){
		return $this->db->insert('item_countries', $data);
	}
	
	//DELETE
	function properties_cleanup($tem_id) {
		return $this->db->delete('item_properties', array('item_id' => $tem_id));

	}

	//BATCH INSERT PROPERTIES
	function batch_insert_properties($data){
		return $this->db->insert_batch('item_properties', $data); 
	}
	
	//CLEANUP
	function cleanup_expired(){
		$this->db->where('item_status','1');
		$this->db->where('item_expired_datetime < NOW()',null,false);
		return $this->db->update('items', array('item_published'=>'2'));
	}
	
	//CLEANUP
	function get_recently_expired($user_id=null){
		$this->db->select('i.item_id,i.item_expired_datetime, i.item_name, i.item_origin_id, uc.abbr_2 as lang,sc.domain,u.user_email, u.user_id');
		$this->db->from('items i');
		$this->db->where('item_published','1');
		if(!is_null($user_id))
			$this->db->where('i.user_id',$user_id);
		$this->db->where('item_expired_datetime < NOW()',null,false);
		$this->db->join('util_countries uc', 'uc.id = i.item_origin_id');
		$this->db->join('sys_countries sc', 'sc.country_id = i.item_origin_id');
		$this->db->join('c1db1.users u', 'u.user_id = i.user_id');
		$query = $this->db->get();
		$result = $query->result_array();
		return $result;
	}
	
	//CLEANUP
	function get_soon_to_expire($x=3){
		$this->db->select('i.item_id,i.item_expired_datetime, i.item_name, i.item_origin_id, uc.abbr_2 as lang,sc.domain,u.user_email, u.user_id');
		$this->db->from('items i');
		$this->db->where('item_published','1');
		$this->db->where('item_expired_datetime > NOW()',null,false);
		$this->db->where('DATE(item_expired_datetime) = DATE(NOW()) + INTERVAL '.(int)$x.' DAY',null,false);
		$this->db->join('util_countries uc', 'uc.id = i.item_origin_id');
		$this->db->join('sys_countries sc', 'sc.country_id = i.item_origin_id');
		$this->db->join('c1db1.users u', 'u.user_id = i.user_id');
		$query = $this->db->get();
		$result = $query->result_array();
		return $result;
	}
	
	
	//CLEANUP
	function cleanup_empty(){
		$this->db->from('items');
		$this->db->where('item_status','0');
		$this->db->where('item_insert_datetime < NOW() - INTERVAL 1 DAY',null,false);
		return $this->db->delete();
	}
	
	//CHECK MANAGER RIGHTS
	function check_rights($id,$countries){
		$this->db->from('items');
		$this->db->where('item_id',$id);
		$this->db->where_in('item_portal',$countries);
		$query = $this->db->get();
		$result = $query->row_array();
		if(!empty($result))
			return true;
		else
			return false;
	}
}
?>