<?php
class Content_model extends CI_Model {

	function __constructl() {
		parent::__construct();
	}
	
	function get_content_type_data($id){
		$this->db->from('content_types');
		$this->db->where('id',$id);
		$query = $this->db->get();
		return $query->row_array();
	}
	
	function list_languages(){
		$this->db->from('languages');
		$query = $this->db->get();
		return $query->result_array();
	}
	
	
	function get_lang($id){
		$this->db->from('languages');
		$this->db->where('id', $id);
		$query = $this->db->get();
		return $query->row_array();
	}

	function list_content($attr_lis=array('*'),$content_type, $parent_id,$lang=1) {
		$this->db->select($attr_lis);
		$this->db->from('content c');
		$this->db->where('c.parent_id', $parent_id);
		$this->db->where('c.content_type', $content_type);
		$this->db->join('content_translations t', 't.content_id = c.id');
		$this->db->where('t.lang_id', $lang);
		$this->db->order_by('c.position', 'desc');
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function count_content($content_type, $parent_id,$lang=1){
		$this->db->select('c.id');
		$this->db->from('content c');
		$this->db->where('c.parent_id', $parent_id);
		$this->db->where('c.content_type', $content_type);
		$this->db->join('content_translations t', 't.content_id = c.id');
		$this->db->where('t.lang_id', $lang);
		return $this->db->count_all_results();
	}
	
	function get_single($id,$lang,$table) {
		$this->db->from('content c');
		$this->db->where('c.id', $id);
		$this->db->join('content_translations t', 't.content_id = c.id');
		if($table!=''){
			$this->db->join($table.' ex', 'ex.content_id = c.id AND ex.lang_id=t.lang_id', 'left');
			
		}
		$this->db->where('t.lang_id', $lang);
		$query = $this->db->get();
		
		return $query->row_array();

	}
	
	function get_images($id,$lang_id){
		$this->db->from('content_images');
		$this->db->where('content_id',$id);
		$this->db->where('language_id',$lang_id);
		$this->db->order_by('position','asc');
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function get_documents($id,$lang_id){
		$this->db->from('content_documents');
		$this->db->where('content_id',$id);
		$this->db->where('language_id',$lang_id);
		$this->db->order_by('position','asc');
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function get_base_data($id){
		$this->db->from('content c');
		$this->db->where('c.id', $id);
		$query = $this->db->get();
		
		return $query->row_array();
	}
	
	function insert($files) {
		if($this->db->insert('content', $files))	
			return $this->db->insert_id();
		else
			return FALSE;
	}
	
	function insert_translation($files) {
		return $this->db->insert('content_translations', $files);

	}
	
	function insert_extended($table_name,$files) {
		return $this->db->insert($table_name, $files);

	}

	
	function check_language($item,$lang){
		$this->db->from('content_translations');
		$this->db->where('content_id', $item);
		$this->db->where('lang_id', $lang);
		$count=$this->db->count_all_results();
		if($count>0)
			return TRUE;
		else 
			return FALSE;
		
	}
	
	function check_extended($table,$item,$lang){
		$this->db->from($table);
		$this->db->where('content_id', $item);
		$this->db->where('lang_id', $lang);
		$count=$this->db->count_all_results();
		if($count>0)
			return TRUE;
		else 
			return FALSE;
		
	}
	
	function update($id, $files) {
		return $this->db->update('content', $files, array('id' => $id));
	}
	
	function update_translation($id,$lang, $files) {
		return $this->db->update('content_translations', $files, array('content_id' => $id,'lang_id'=>$lang));
	}
	
	function update_extended($table,$id,$lang, $files) {
		return $this->db->update($table, $files, array('content_id' => $id,'lang_id'=>$lang));
	}

	function delete($id) {
		return $this->db->delete('content', array('id' => $id));

	}
	
	
	//GET POSITION
	function get_position($content_type,$parent_id) {
		$this->db->from('content');
		$this->db->where('content_type', $content_type);
		$this->db->where('parent_id', $parent_id);
		$this->db->select_max('position');
		$query = $this->db->get();
		return $query->row();
	}
	// UPDATING POSITION
	function update_position($id, $files) {
		return $this->db->update('content', $files, array('id' => $id));
	}
	

}
?>