<?php
class Categories_model extends CI_Model {

	function __constructl() {
		parent::__construct();
	}
	
	function get_categories_datagrid($attr_lis=array('*'),$parent_id=null){
		$this->db->select($attr_lis);
		$this->db->from('item_categories');
		if($parent_id>0)
			$this->db->where('parent_id',(int)$parent_id);
		else
			$this->db->where('parent_id IS NULL', null, false);
		$this->db->order_by('position','asc');
		$query = $this->db->get();
		$result=$query->result_array();
		if(sizeof($result)>0)
			return $result;
		else
			return false;
	}
	
	
	function count_categories($parent_id){
		$this->db->select('category_id');
		$this->db->from('item_categories');
		if($parent_id>0)
			$this->db->where('parent_id',(int)$parent_id);
		else
			$this->db->where('parent_id IS NULL', null, false);
		return $this->db->count_all_results();
	}
	
	function list_content_types($parent_id){
		$this->db->from('item_categories');
		$this->db->where('parent_id',$parent_id);
		$query = $this->db->get();
		return $query->result_array();
	}
	
	
	function get_category($id){
		$this->db->from('item_categories');
		$this->db->where('category_id',$id);
		$query = $this->db->get();
		return $query->row_array();
	}
	
	function get_category_trans($id){
		$this->db->from('item_categories_translations');
		$this->db->where('category_id',$id);
		$query = $this->db->get();
		return $query->row_array();
	}
	
	function get_category_trans_bylang($id){
		$this->db->from('util_languages l');
		$this->db->join('item_categories_translations ctd', 'l.id = ctd.language_id and ctd.category_id='.$id,'left',true);
		$query = $this->db->get();
		return $query->result_array();
	}
	
	
	
	
	function insert($files) {
		if($this->db->insert('item_categories', $files))	
			return $this->db->insert_id();
		else
			return FALSE;
	}
	
	function insert_data($files) {
		return $this->db->insert('item_categories_translations', $files);

	}
	
	function check_language($type,$lang){
		$this->db->from('item_categories_translations');
		$this->db->where('category_id', $type);
		$this->db->where('language_id', $lang);
		$count=$this->db->count_all_results();
		if($count>0)
			return TRUE;
		else 
			return FALSE;
		
	}
	
	function update($id, $files) {
		return $this->db->update('item_categories', $files, array('category_id' => $id));
	}
	
	function update_data($id,$lang, $files) {
		return $this->db->update('item_categories_translations', $files, array('category_id' => $id,'language_id'=>$lang));
	}
	
	// UPDATING POSITION
	function update_position($id, $files) {
		return $this->db->update('item_categories', $files, array('category_id' => $id));
	}

	function delete($id) {
		return $this->db->delete('item_categories', array('category_id' => $id));

	}
}
?>