<?php
class Articles_model extends CI_Model {

	function __constructl() {
		parent::__construct();

	}

	function list_articles($category_type_id, $parent_id) {

		$this->db->from('articles');
		$this->db->where('parent_id', $parent_id);
		$this->db->where('category_type_id', $category_type_id);
		$this->db->order_by('position', 'desc');
		$query = $this->db->get();
		return $query->result();

	}

	//CATEGORY PICKER DATA
	function has_child($cat_id) {
		$this->db->from('articles');
		$this->db->where('parent_id', $cat_id);
		$this->db->count_all_results();

		if ($this->db->count_all_results() > 0) {
			return TRUE;
		}
		return FALSE;

	}

	function get_categories($parent = 0) {

		$categories = array();
		$this->db->from('articles');
		$this->db->where('parent_id', $parent);
		$this->db->order_by('datetime', 'desc');
		$query = $this->db->get();

		foreach ($query->result_array() as $cat) {

			$categories[$cat['id']] = array(
				'id' => $cat['id'],
				'name_hr' => $cat['name_hr'],
				'url_hr' => $cat['url_hr'],
				'children' => array()
			);

			if ($this->has_child($cat['id'])) {
				$children = $this->get_categories($cat['id']);
			}

			$categories[$cat['id']]['children'] = $children;

		}

		return $categories;

	}

	function insert($files) {
		return $this->db->insert('articles', $files);
	}

	function last_row() {
		$this->db->from('articles');
		$this->db->limit(1, 0);
		$this->db->order_by('id', 'desc');
		$query = $this->db->get();
		return $query->row_array();
	}
	
	

	function get_category($id) {
		$query = $this->db->get_where('articles', array('id' => $id));
		return $query->row_array();

	}

	function update_top($id, $files) {
		$this->db->set($files);
		$this->db->update('articles', $files, array('id' => $id));
	}

	function update($id, $files) {
		return $this->db->update('articles', $files, array('id' => $id));
	}

	function delete($id) {

		$this->delete_childs($id);
		return $this->db->delete('articles', array('id' => $id));

	}

	//DELETING CHILDS IN DATABASE

	function delete_childs($parent = 0) {

		$categories = array();
		$this->db->from('articles');
		$this->db->where('parent_id', $parent);
		$query = $this->db->get();

		foreach ($query->result_array() as $cat) {

			$categories[$cat['id']] = array(
				'id' => $cat['id'],
				'children' => array()
			);

			if ($this->has_child($cat['id'])) {
				$children = $this->delete_childs($cat['id']);
			}

			$categories[$cat['id']]['children'] = $children;

		}

		foreach ($categories as $row) {
			$this->db->delete('articles', array('id' => $row['id']));
		}

	}

	//DOCUMENTS
	function get_documents($id) {
		$this->db->from('documents');
		$this->db->where('relevant_id', $id);
		$this->db->where('type', '2');
		$query = $this->db->get();
		return $query->result();

	}

	function insert_document($files) {
		$this->db->insert('documents', $files);
	}

	function delete_documents($id) {

		$this->db->delete('documents', array(
			'relevant_id' => $id,
			'type' => '2'
		));

	}
	
	//GET POSITION
	function get_position($category_type_id) {
		$this->db->from('articles');
		$this->db->where('category_type_id', $category_type_id);
		$this->db->select_max('position');
		$query = $this->db->get();
		return $query->row();
	}
	// UPDATING POSITION
	function update_position($id, $files) {
		return $this->db->update('articles', $files, array('id' => $id));
	}

	//GALLERIES
	function get_all_galleries($galleries) {
		$this->db->from('gallery');
		foreach ($galleries as $row) {
			$this->db->where('id !=', $row);
		}
		$this->db->order_by('datetime', 'desc');
		$query = $this->db->get();
		return $query->result();

	}

	function get_single_gallery($id) {
		$this->db->from('gallery');
		$this->db->where('id', $id);
		$query = $this->db->get();
		return $query->result();
	}

	function get_preview_images($id) {
		$this->db->from('gallery_images');
		$this->db->where('gallery_id', $id);
		$this->db->limit('3', '0');
		$query = $this->db->get();
		return $query->result();
	}

}
?>