<?php
class Advertising_model extends CI_Model {

	function __constructl() {
		parent::__construct();

	}

	
	//CLIENTS
	function get_clients_datagrid($attr_lis=array('*'),$country=null,$type=null,$active=null){
		$this->db->select($attr_lis);
		$this->db->from('adv_clients acl');
		if(!is_null($country))
			$this->db->where_in('country',$country);
		if(!is_null($type))
			$this->db->where('client_type',(int)$type);
		if(!is_null($active))
			$this->db->where('active',(string)$active);
		$this->db->join('util_countries c', 'acl.country = c.id');
		$query = $this->db->get();
		$result=$query->result_array();
		if(sizeof($result)>0)
			return $result;
		else
			return false;
	}
	
	//campaigns
	function get_campaigns_datagrid($attr_lis=array('*'),$country=null,$client=null,$active=null){
		$this->db->select($attr_lis);
		$this->db->from('adv_campaigns acm');
		if(!is_null($country))
			$this->db->where_in('country',$country);
		if(!is_null($client))
			$this->db->where('client_id',(int)$client);
		if(!is_null($active))
			$this->db->where('acm.active',(int)$active);
		$this->db->join('adv_clients acl', 'acm.client_id = acl.id');
		$query = $this->db->get();
		$result=$query->result_array();
		if(sizeof($result)>0)
			return $result;
		else
			return false;
	}
	
	function count_clients($country=null,$type=null,$active=null){
		$this->db->select('id');
		$this->db->from('adv_clients');
		if(!is_null($country))
			$this->db->where_in('country',$country);
		if(!is_null($type))
			$this->db->where('client_type',(int)$type);
		if(!is_null($active))
			$this->db->where('active',(string)$active);
		return $this->db->count_all_results();
	}

	function count_campaigns($client=null){
		$this->db->select('id');
		$this->db->from('adv_campaigns');
		if(!is_null($client))
			$this->db->where('client',(string)$client);
		return $this->db->count_all_results();
	}
	
	//BANNERS
	//campaigns
	function get_banners_datagrid($attr_lis=array('*'),$campaign_id=null){
		$this->db->select($attr_lis);
		$this->db->from('adv_banners abn');
		if(!is_null($campaign_id))
			$this->db->where('campaign_id',$campaign_id);
		$this->db->join('adv_positions aps', 'abn.position = aps.id','left');
		$this->db->join('util_countries uc', 'abn.target_country = uc.id','left');
		$query = $this->db->get();
		$result=$query->result_array();
		if(sizeof($result)>0)
			return $result;
		else
			return false;
	}
	//CLIENT
	function get_client($id){
		$this->db->from('adv_clients');
		$this->db->where('id',$id);
		$query = $this->db->get();
		$result=$query->row_array();
		if(sizeof($result)>0)
			return $result;
		else
			return false;
	}

	function insert_client($files) {
		if($this->db->insert('adv_clients', $files))
			return $this->db->insert_id();
		else
			return FALSE;
	}
	
	function update_client($id, $files) {
		return $this->db->update('adv_clients', $files, array('id' => $id));
	}
	function delete_client($id) {
		return $this->db->delete('adv_clients', array('id' => $id));
	}
	//CAMPAIGN
	function get_campaign($id){
		$this->db->from('adv_campaigns');
		$this->db->where('id',$id);
		$query = $this->db->get();
		$result=$query->row_array();
		if(sizeof($result)>0)
			return $result;
		else
			return false;
	}

	function insert_campaign($files) {
		if($this->db->insert('adv_campaigns', $files))
			return $this->db->insert_id();
		else
			return FALSE;
	}
	
	function update_campaign($id, $files) {
		return $this->db->update('adv_campaigns', $files, array('id' => $id));
	}
	function delete_campaign($id) {
		return $this->db->delete('adv_campaigns', array('id' => $id));
	}
	//
	
	//BANNERS
	function get_banner($id){
		$this->db->from('adv_banners');
		$this->db->where('id',$id);
		$query = $this->db->get();
		$result=$query->row_array();
		if(sizeof($result)>0)
			return $result;
		else
			return false;
	}
	
	function get_positions($source){
		$this->db->from('adv_positions');
		$this->db->where('source',$source);
		$query = $this->db->get();
		$result=$query->result_array();
		if(sizeof($result)>0)
			return $result;
		else
			return false;
	}
	
	function get_single_positions($id){
		$this->db->from('adv_positions');
		$this->db->where('id',$id);
		$query = $this->db->get();
		$result=$query->row_array();
		if(sizeof($result)>0)
			return $result;
		else
			return false;
	}
	
	function get_banner_categories($banner_id){
		$this->db->from('adv_category_banners');
		$this->db->where('banner_id',$banner_id);
		$query = $this->db->get();
		$result=$query->result_array();
		if(sizeof($result)>0)
			return $result;
		else
			return false;
	}

	function insert_banner($files) {
		if($this->db->insert('adv_banners', $files))
			return $this->db->insert_id();
		else
			return FALSE;
	}
	
	function update_banner($id, $files) {
		return $this->db->update('adv_banners', $files, array('id' => $id));
	}
	
	function delete_banner($id) {
		return $this->db->delete('adv_banners', array('id' => $id));
	}
	
	function purge_banner_categories($id) {
		return $this->db->delete('adv_category_banners', array('banner_id' => $id));
	}
	
	function insert_banner_category($files) {
		if($this->db->insert('adv_category_banners', $files))
			return $this->db->insert_id();
		else
			return FALSE;
	}
	//
	//STATISTIC
	
	//BANNERS
	function banner_statistic_total($id){
		$query="SELECT COUNT(event_type) AS event_count, event_type, banner_id
				FROM adv_statistic
				WHERE banner_id= $id
				GROUP BY banner_id, event_type";
		$query= $this->db->query($query);
		return $query->result_array();
	}
	function banner_statistic_total_datespan($id,$from,$to){
		
		$query="SELECT COUNT(event_type) AS event_count, event_type, banner_id
				FROM adv_statistic
				WHERE banner_id= $id
				AND DATE(event_datetime)>='$from' AND  DATE(event_datetime)<='$to'
				GROUP BY banner_id, event_type";
		$query= $this->db->query($query);
		return $query->result_array();
	}
	
	function stat_count_banners_views_by_date($id){
		$query="SELECT COUNT(event_type) AS num, date(event_datetime) as date
				FROM adv_statistic
				WHERE banner_id= $id AND event_type='view' 
				GROUP BY date(event_datetime)
				HAVING num > 0";
		$query= $this->db->query($query);
		return $query->result_array();
	}
	
	function stat_count_banners_clicks_by_date($id){
		$query="SELECT COUNT(event_type) AS num, date(event_datetime) as date
				FROM adv_statistic
				WHERE banner_id= $id AND event_type='click' 
				GROUP BY date(event_datetime)
				HAVING num > 0";
		$query= $this->db->query($query);
		return $query->result_array();
	}

	function banner_statistic_by_day_total($id){
		$query="SELECT DATE(event_datetime) AS d,SUM(IF(stat.event_type = 'click', 1, 0)) AS click, SUM(IF(stat.event_type = 'view', 1, 0)) AS v
				FROM adv_banners ban
				LEFT JOIN adv_statistic stat ON ban.id=stat.banner_id
				WHERE ban.id= $id
				GROUP BY DATE(event_datetime)
				HAVING d IS NOT NULL";
		$query= $this->db->query($query);
		return $query->result_array();
	}
	function banner_statistic_by_day_datespan($id,$from,$to){
		
		$query="SELECT DATE(event_datetime) AS d,SUM(IF(stat.event_type = 'click', 1, 0)) AS click, SUM(IF(stat.event_type = 'view', 1, 0)) AS v
				FROM adv_banners ban
				LEFT JOIN adv_statistic stat ON ban.id=stat.banner_id
				WHERE ban.id= $id
				AND DATE(event_datetime)>='$from' AND  DATE(event_datetime)<='$to'
				GROUP BY DATE(event_datetime)
				HAVING d IS NOT NULL";
		$query= $this->db->query($query);
		return $query->result_array();
	}
	
	
	
	//CAMPAIGN
	function campaign_statistic_total($id){
		$query="SELECT camp.id AS campaign_id, COUNT(stat.event_type) AS event_count, stat.event_type
				FROM adv_campaigns camp
				LEFT JOIN adv_banners ban ON camp.id=ban.campaign_id
				LEFT JOIN adv_statistic stat ON ban.id=stat.banner_id
				WHERE camp.id= $id
				GROUP BY camp.id,event_type";
		$query= $this->db->query($query);
		return $query->result_array();
	}
	
	function campaign_statistic_by_day_total($id){
		$query="SELECT DATE(event_datetime) AS d,SUM(IF(stat.event_type = 'click', 1, 0)) AS click, SUM(IF(stat.event_type = 'view', 1, 0)) AS v
				FROM adv_campaigns camp
				LEFT JOIN adv_banners ban ON camp.id=ban.campaign_id
				LEFT JOIN adv_statistic stat ON ban.id=stat.banner_id
				WHERE camp.id= $id
				GROUP BY camp.id,DATE(event_datetime)
				HAVING d IS NOT NULL";
		$query= $this->db->query($query);
		return $query->result_array();
	}
	
	function stat_count_campaign_views_by_date($id){
		$query="SELECT COUNT(stat.event_type) AS num, DATE(stat.event_datetime) AS date
				FROM adv_campaigns camp
				LEFT JOIN adv_banners ban ON camp.id=ban.campaign_id
				LEFT JOIN adv_statistic stat ON (ban.id=stat.banner_id AND stat.event_type='view') 
				WHERE camp.id=$id
				GROUP BY DATE(stat.event_datetime)
				HAVING num > 0";
		$query= $this->db->query($query);
		return $query->result_array();
	}
	
	
	
	function stat_count_campaign_clicks_by_date($id){
		$query="SELECT COUNT(stat.event_type) AS num, DATE(stat.event_datetime) AS date
				FROM adv_campaigns camp
				LEFT JOIN adv_banners ban ON camp.id=ban.campaign_id
				LEFT JOIN adv_statistic stat ON (ban.id=stat.banner_id AND stat.event_type='click') 
				WHERE camp.id=$id
				GROUP BY DATE(stat.event_datetime)
				HAVING num > 0";
		$query= $this->db->query($query);
		return $query->result_array();
	}

	//CHECK MANAGER RIGHTS
	function check_rights_campaign($id,$countries){
		$this->db->from('adv_clients acl');
		$this->db->where_in('country',$countries);
		$this->db->join('adv_campaigns acm','acl.id=acm.client_id');
		$this->db->where('acm.id',$id);
		$query = $this->db->get();
		$result = $query->row_array();
		if(!empty($result))
			return true;
		else
			return false;
	}
	
	function check_rights_client($id,$countries){
		$this->db->from('adv_clients acl');
		$this->db->where_in('country',$countries);
		$this->db->where('acl.id',$id);
		$query = $this->db->get();
		$result = $query->row_array();
		if(!empty($result))
			return true;
		else
			return false;
	}
}
?>