<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

include_once dirname(__FILE__).DIRECTORY_SEPARATOR.'facebook.php';

class social_auth extends Authentication 
{
  public function login_social( $required_level = 0, $social_data )
	{
		/**
		 * Validate the posted username / email address and password.
		 */
		$this->CI->load->library('form_validation');
		$this->CI->config->load('login' );
		$this->CI->form_validation->set_rules( config_item('login_rules') );

			// Check if IP, username or email address is already on hold.
			$this->on_hold = $this->current_hold_status();
			
			if( ! $this->on_hold )
			{
				
				// Get user table data if username or email address matches a record
				if( $auth_data = $this->CI->auth_model->get_auth_data( $social_data['email'] ) )
				{
					
					if(
						// Check if user is banned
						( $auth_data->user_banned === '1' )

						// Check response from social network
						OR ( ! $this->check_social($social_data ) )

						// Check if the user is of high enough level to be here
						OR ( is_int( $required_level ) && $auth_data->user_level < $required_level )
						OR ( is_array( $required_level ) && ! in_array( $this->account_types[$auth_data->user_level], $required_level ) )
					)
					{
						// Login failed ...
					}
					else
					{
						// Store login time in database and cookie
						$login_time = time();

						// Update user record in database
						$this->CI->auth_model->login_update( $auth_data->user_id, $login_time );

						/**
						 * Since the session cookie needs to be able to use
						 * the secure flag, we want to hold some of the user's 
						 * data in another cookie. For instance, the `user_name` 
						 * is used to have a logout button on standard HTTP pages.
						 *
						 * If auth_model->get_auth_data() joined the user profile
						 * table, you might also add the user's first and last name
						 * or other data that is not sensitive. Please do not
						 * add sensitive data to the http user cookie.
						 */
						$http_user_cookie = array(
							'name'   => config_item('http_user_cookie_name'),
							'value'  => $this->CI->session->serialize_data( array(
								'_user_name' => $auth_data->user_name
							) ),
							'domain' => config_item('cookie_domain'),
							'path'   => config_item('cookie_path'),
							'prefix' => config_item('cookie_prefix'),
							'secure' => FALSE
						);

						// Check if remember me requested, and set cookie if yes
						if( config_item('allow_remember_me') && $this->CI->input->post('remember_me') )
						{
							$remember_me_cookie = array(
								'name'   => config_item('remember_me_cookie_name'),
								'value'  => config_item('remember_me_expiration') + time(),
								'expire' => config_item('remember_me_expiration'),
								'domain' => config_item('cookie_domain'),
								'path'   => config_item('cookie_path'),
								'prefix' => config_item('cookie_prefix'),
								'secure' => FALSE
							);

							$this->CI->input->set_cookie( $remember_me_cookie );

							// Make sure the CI session cookie doesn't expire on close
							$this->CI->session->sess_expire_on_close = FALSE;
							$this->CI->session->sess_expiration = config_item('remember_me_expiration');

							// Set the expiration of the userName cookie
							$http_user_cookie['expire'] = config_item('remember_me_expiration') + time();
						}
						else
						{
							// Unless remember me is requested, the userName cookie expires when the browser closes.
							$http_user_cookie['expire'] = 0;
						}

						$this->CI->input->set_cookie( $http_user_cookie );

						// Set CI session cookie
						$this->CI->session->set_userdata( 
							'auth_identifier',
							$this->create_auth_identifier(
								$auth_data->user_id,
								$auth_data->user_modified,
								$login_time
							)
						);

						// Send the auth data back to the controller
						return $auth_data;
					}
				}
				//AKO JE NOVI KORISNIK
				else{
					if($this->register_social($social_data))
						$this->login_social(1,$social_data);
				}
			}
		

		// Log the error
		$this->log_error( $this->CI->security->xss_clean( $social_data['email'] ) );

		$this->login_error = TRUE;
		
		return FALSE;
	}


	private function check_social($social_data)
	{
		$ci = &get_instance();
		try{
			 $user = $ci->facebook->getUser();
		}
		catch (FacebookApiException $e)  {
			return false;
		}
			
		if( $user==$social_data['id'] )
		{
			return TRUE;
		}
		else{
			return FALSE;
		}

		
	}
	
	private function register_social($social_data){
		$ci = &get_instance();
		$ci->load->model('user_model');
		
		
		if (!empty($social_data)) {
				$ci->load->library('uuid');	
				$ci->load->helper('random_pass');

				$pass=get_random_password(6, 8, false, true, false);
				//USERNAME
				$username=url_title( $social_data['first_name'].' '. $social_data['last_name'], 'dash', TRUE);
				//SENDING FORM DATA TO MODEL
				$files = array(
					'user_name' => $username.rand(1, 1000),
					'user_pass' => $pass,
					'user_email' => $social_data['email'],
					'user_level' => 1,
					'first_name' => $social_data['first_name'],
					'last_name' => $social_data['last_name'],
					'license_number' => $ci->uuid->v4()
				);
			
				if ($ci->user_model->create_user($files)) {
					if($this->send_email($files))
							return TRUE;
					else
							return FALSE;
				} else {
					return FALSE;
				}

			} 
			else {
						return FALSE;
					}
		
	}
	
	private function send_email($data){
		$ci = &get_instance();
		$ci->load->library('email');
		
		$message="
			<p>Hvala vam na registraciji!</p>
			<h2>Korisnički podaci</h2>
			<p>
			Username:". $data['user_name']."
			</p>
			<p>
			Password:". $data['user_pass']."
			</p>
			
		";

		$ci->email->from('noreplay@emicca.com', 'Emicca test');
		$ci->email->to($data['user_email']);
		
		$ci->email->subject('Email Test');
		
		$ci->email->message($message);
		
		if($ci->email->send())
			return TRUE;
		else {
			return FALSE;
		}
	}

}