<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Images {
	private $CI;

	public function __construct() {
		$this->CI = &get_instance();
	}
	
	
	 function resize($oldFile, $id, $width, $height)
    {
    	
    	
		$obj =& get_instance();
		//CHECK SERVER
		$protocol = ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off') || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
		$domainName = $_SERVER['HTTP_HOST'];
		$domain = $protocol . $domainName;
		$web_path = $_SERVER['DOCUMENT_ROOT'];

		$image_path = str_replace($domain . "/", $web_path . "/" , $oldFile);
		
		if(file_exists($image_path)) {
			
			
		$thumb_name = pathinfo($image_path);
		$thumb_name = $thumb_name['filename'] . "_" . $width . $height . "_".$id . "." . $thumb_name['extension'];
		$thumb_path = $web_path . $this->CI->config->item('thumb_folder') . $thumb_name;
		
        
        //math for resize/crop without loss
        $o_size = $this->_get_size($image_path);        
        
        $master_dim = ($o_size['width']-$width < $o_size['height']-$height?'width':'height');
        
        $perc = max( (100*$width)/$o_size['width'] , (100*$height)/$o_size['height']  );
        
        $perc = round($perc, 0);
        
        $w_d = round(($perc*$o_size['width'])/100, 0);        
        $h_d = round(($perc*$o_size['height'])/100, 0);
        
                // end math stuff

        /*
         *    Resize image
         */
        $config['image_library'] = 'gd2';
        $config['source_image'] = $image_path;
        $config['new_image'] = $thumb_path;
        $config['maintain_ratio'] = TRUE;
        $config['master_dim'] = $master_dim;
        $config['width'] = $w_d + 1;
        $config['height'] = $h_d + 1;

        $this->CI->load->library('image_lib', $config);
        
       	$this->CI->image_lib->resize();
        
        $size = $this->_get_size($thumb_path);    

        unset($config); // clear $config

        /*
         *    Crop image  in weight, height
         */
         
        $config['image_library'] = 'gd2';
        $config['source_image'] = $thumb_path;
        $config['maintain_ratio'] = FALSE;
        $config['width'] = $width;
        $config['height'] = $height;
        $config['y_axis'] = round(($size['height'] - $height) / 2);
        $config['x_axis'] = 0;

        $this->CI->image_lib->clear();
		$this->CI->image_lib->initialize($config);
		
        if (!$this->CI->image_lib->crop())
        {
            echo $this->CI->image_lib->display_errors();
        }
        
        $info = pathinfo($thumb_path);  
        
       $final_domain = $domain ."/" . $this->CI->config->item('thumb_folder') ."/". $thumb_name;
	   
	   return preg_replace('%([^:])([/]{2,})%', '\\1/', $final_domain);
    }  

}
	private function _get_size($image) {
		$img = getimagesize($image);
		return Array(
			'width' => $img['0'],
			'height' => $img['1']
		);
	}

}
