<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * Community Auth - Input Class Extension
 *
 * Community Auth is an open source authentication application for CodeIgniter 2.1.0
 *
 * @package     Community Auth
 * @author      Robert B Gottier
 * @copyright   Copyright (c) 2011 - 2012, Robert B Gottier. (http://brianswebdesign.com/)
 * @license     BSD - http://http://www.opensource.org/licenses/BSD-3-Clause
 * @link        http://community-auth.com
 */

class MY_Input extends CI_Input {

	public function __construct()
	{
		parent::__construct();
	}

	/**
	* Validate IP Address
	*
	* Validates both IPv4 and IPv6 addresses as valid
	*
	* @access	public
	* @param	string
	* @return	bool
	*/
	public function valid_ip( $ip )
	{
		if( 
			! filter_var( $ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4 ) && 
			! filter_var( $ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6 )
		)
		{
			return FALSE;
		}

		return TRUE;
	}

	// --------------------------------------------------------------------
}

/* End of file MY_Input.php */
/* Location: ./application/core/MY_Input.php */