<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Xml extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('main_model');
        $this->load->model('xml_model');
        $this->load->helper('language');
        $this->load->helper('url');
        $this->load->helper('links');
        $this->load->helper('text');
        $this->load->library('multilang', array('default_lang' => 'hr', 'multilang' => true));
    }

    public function index() {
        $data['lang'] = $this->multilang->get_current();
        $data['regions'] = $this->xml_model->get_regions();
        $this->load->view('xml/tree_view', $data);
        
    }

    function get_info() {
        if ($id = $this->input->post('id', true)) {
            $data['lang'] = $this->multilang->get_current();
            //INICIJALIZIRAMO MENU LIB
            $this->load->library('menu', array('lang' => $data['lang']));
            //DOHVATIMO MENU ARRAY
            $data['menu_items'] = $this->menu->generate_categories_paths(NULL);
            $data['breadcrumbs'] = $this->menu->getkeypath($data['menu_items'], $id);
            $data['category_id'] = $id;
            $data['category_info'] = $this->main_model->get_cat_info($id, $data['lang']['id']);
            //FILTRI
            $data['filters'] = $this->main_model->get_category_properties_groups($data['breadcrumbs'], $data['lang']['id'], true);
            echo $this->load->view('xml/xml_ajax_single_view', $data, false);
        }
    }
     function print_info() {
        if ($id = $this->input->get('id', true)) {
            $data['lang'] = $this->multilang->get_current();
            //INICIJALIZIRAMO MENU LIB
            $this->load->library('menu', array('lang' => $data['lang']));
            //DOHVATIMO MENU ARRAY
            $data['menu_items'] = $this->menu->generate_categories_paths(NULL);
            $data['breadcrumbs'] = $this->menu->getkeypath($data['menu_items'], $id);
            $data['category_id'] = $id;
            $data['category_info'] = $this->main_model->get_cat_info($id, $data['lang']['id']);
            //FILTRI
            $data['filters'] = $this->main_model->get_category_properties_groups($data['breadcrumbs'], $data['lang']['id'], true);
            echo $this->load->view('xml/xml_print_single_view', $data, false);
        }
    }

    public function xml_import() {

        if (!$this->input->get('run'))
            return false;
        if ($this->input->get('quid', true)) {
            $xml_list = $this->xml_model->get_speciffic_import_list($this->input->get('quid', true));
        } else
            $xml_list = $this->xml_model->get_import_list(1);
        if (empty($xml_list))
            die('No available task to process');
        //MAIN FOREACH
        if (!empty($xml_list)) {
            foreach ($xml_list as $xl) {
                //LOADING XML FILE	
                $xml = @simplexml_load_file($xl['url']);
                if (!$xml) {
                    die('Provided XML file is not valid');
                }
                //SET ENTRY STATUS
                $this->db->update('xml_import_list', array('status' => '1', 'last_access' => date('Y-m-d H:i:s')), array('id' => $xl['id']));

                $user_id = (int) $xml->config->user_id;
                if ($user_id != $xl['user_id'])
                    die('Invalid user ID');
                //SET CONFIG DATA
                $config = array(
                    'user_id' => $user_id,
                    'lang_id' => (int) $xml->config->lang_id,
                    'origin_id' => (int) $xml->config->origin_id,
                    'portal_id' => (int) $xml->config->portal_id
                );
                //PREPARE TRACKING
                $response = array();
                $time_start = microtime(true);
                $total_count = 0;
                $total_image_count = 0;
                //print_r($xml);
                foreach ($xml->items->item as $i) {
                    $internal_id = null;
                    $item_proccessed = false;
                    $proc_options_count = 0;
                    $proc_images_count = 0;

                    //INITIAL CHECK FOR OPTIONS
                    if (!$i->options) {
                        $response[] = 'Error with item ' . $i->external_id . ' - no properties provided.';
                        continue;
                    }

                    $data = array(
                        'item_category' => $this->xml_import->validate($i->category, 'item_category'),
                        'user_id' => $user_id,
                        'ext_id' => $this->xml_import->validate($i->external_id, 'external_id'),
                        'lang_id' => $config['lang_id'],
                        'item_origin_id' => $config['origin_id'],
                        'item_portal' => $config['portal_id'],
                        'item_name' => $this->xml_import->validate($i->name, 'item_name'),
                        'item_content' => $this->xml_import->validate($i->content, 'item_content'),
                        'item_budget_currency' => $this->xml_import->validate($i->budget_currency, 'item_budget_currency'),
                        'item_budget' => $this->xml_import->validate($i->budget, 'item_budget'),
                        'item_video' => $this->xml_import->validate($i->video, 'item_video'),
                        'item_published' => (string) $i->published == '1' ? '1' : '0',
                        'item_sold' => (string) $i->sold == '1' ? '1' : '0',
                        'item_status' => '1',
                        'item_edit_datetime' => date('Y-m-d H:i:s'),
                    );

                    //SPECIFFIC ATRIBUTES
                    if ($i->region) {
                        $data['item_region_id'] = $this->xml_import->validate($i->region, 'item_region_id');
                    }
                    //CHECK IF IT'S INSERT, UPDATE OR INVALID
                    $check = $this->xml_model->check_existing_item($user_id, $this->xml_import->validate($i->external_id, 'external_id'));

                    if ($check == 'insert') {
                        //INSERT NEW ITEM AND RETRIEVE INTERNAL ID
                        $data['item_insert_datetime'] = date('Y-m-d H:i:s');
                        $data['item_publish_datetime'] = date('Y-m-d H:i:s');
                        $data['item_expired_datetime'] = date('Y-m-d H:i:s', strtotime("+30 days"));

                        if ($this->db->insert('items', $data)) {
                            $internal_id = $this->db->insert_id();
                            $item_proccessed = true;
                        }
                    } else if (is_array($check) && isset($check['item_id'])) {
                        //DELETE ITEM
                        if ($i->delete && $i->item_name == 'true') {
                            $this->delete_listing($check['item_id']);
                            continue;
                        }
                        //SKIP ITEM
                        if ($i->unchanged && $i->unchanged == 'true') {
                            continue;
                        }

                        //CHECK DATES
                        $datetime1 = date_create($check['item_publish_datetime']);
                        $datetime2 = date_create();
                        $interval = date_diff($datetime1, $datetime2);
                        $day_diff = $interval->format('a');
                        //IF MORE THAN 29 DAYS UPDATE DATES
                        if ($day_diff > 30) {
                            $data['item_publish_datetime'] = date('Y-m-d H:i:s');
                            $data['item_expired_datetime'] = date('Y-m-d H:i:s', strtotime("+30 days"));
                        }
                        //GET INTERNAL ID OF EXISTING ITEM AND TO UPDATE
                        $internal_id = $check['item_id'];
                        if ($this->db->update('items', $data, array('item_id' => $internal_id)))
                            $item_proccessed = true;
                    }
                    else {
                        $response[] = 'Error with user ' . $user_id . ' and item ' . $i->external_id;
                    }
                    //GO FURHER ONLY IF ITEM IS PROCESSED
                    if ($item_proccessed && $internal_id > 0) {
                        //PURGE ITEM COUNTRIES
                        $this->db->delete('item_countries', array('item_id' => $internal_id));
                        //LINK ITEM TO COUNTRY
                        $this->db->insert('item_countries', array('item_id' => $internal_id, 'country_id' => $config['origin_id']));
                        //PURGE CURRENT OPTIONS
                        $this->db->delete('item_properties', array('item_id' => $internal_id));
                        foreach ($i->options->children() as $x) {

                            $current_option = array(
                                'item_id' => $internal_id,
                                'property_id' => (int) $x->attributes()->id,
                                'value' => (string) $x
                            );
                            //VALIDATE CURRENT OPTION AND RETURN VALIDATED FOR INSERT
                            if ($valid_option = $this->xml_import->validate_option($current_option)) {
                                if ($this->db->insert('item_properties', $valid_option))
                                    $proc_options_count++;
                            }
                            else {
                                $response[] = 'Invalid option ' . $current_option['property_id'] . ' for item ' . $i->external_id . ', option import skipped.';
                                continue;
                            }
                        }

                        //IMAGES
                        if ($i->images) {
                            //REMOVE OLD FILES FROM SERVER
                            $this->delete_listing_files($internal_id);
                            //REMOVE OLD IMAGES FROM DATABASE
                            $this->db->delete('item_images', array('item_id' => $internal_id));
                            //PURGE CURRENT IMPORT IMAGES
                            $this->db->delete('import_images', array('item_id' => $internal_id));
                            foreach ($i->images->children() as $x) {

                                $img_data = array(
                                    'item_id' => $internal_id,
                                    'import_timestamp' => date('Y-m-d H:i:s'),
                                    'image_url' => urldecode($x)
                                );
                                $this->db->insert('import_images', $img_data);
                                $proc_images_count++;
                                $total_image_count++;
                            }
                        }
                    }

                    //$response[]='Item '.$i->external_id.' processed, '.$proc_options_count.' options added, '.$proc_images_count.' images in queue for import</p>';
                    $total_count++;
                }
                $time_end = microtime(true);

                //dividing with 60 will give the execution time in minutes other wise seconds
                $execution_time = ($time_end - $time_start) / 60;
                $response[] = 'Total item count: ' . $total_count;
                $response[] = 'Total images count: ' . $total_image_count;
                //execution time of the script
                $response[] = '<b>Total Execution Time:</b> ' . $execution_time . ' Mins';
                $response = implode('<br/>', $response);
                //$this->load->view('view');
            }
            //SET ENTRY STATUS
            $this->db->update('xml_import_list', array('status' => '0'), array('id' => $xl['id']));
            $this->db->insert('xml_import_log', array(
                'log_time' => date('Y-m-d H:i:s'),
                'import_id' => $xl['id'],
                'log_data' => $response
            ));
            echo $response;
            unset($response);
        }
    }

    function validation() {
        $url = $this->input->post('url', true);
        echo '<p>Validating: ' . $url . '</p>';
        $xml = simplexml_load_file($url);
        if (!$xml) {
            die('Provided XML file or path is not valid');
        }


        $user_id = (int) $xml->config->user_id;
        $config = array(
            'user_id' => $user_id,
            'lang_id' => (int) $xml->config->lang_id,
            'origin_id' => (int) $xml->config->origin_id,
            'portal_id' => (int) $xml->config->portal_id
        );

        $response = array();
        $total_count = 0;
        $total_image_count = 0;
        //print_r($xml);
        foreach ($xml->items->item as $i) {
            $internal_id = null;
            $item_proccessed = false;
            $proc_options_count = 0;
            $proc_images_count = 0;

            //INITIAL CHECK FOR OPTIONS
            if (!$i->options) {
                $response[] = 'Error with item ' . $i->external_id . ' - no properties provided.';
                continue;
            }

            $data = array(
                'item_category' => $this->xml_import->validate($i->category, 'item_category'),
                'user_id' => $user_id,
                'ext_id' => $this->xml_import->validate($i->external_id, 'external_id'),
                'lang_id' => $config['lang_id'],
                'item_origin_id' => $config['origin_id'],
                'item_portal' => $config['portal_id'],
                'item_name' => $this->xml_import->validate($i->name, 'item_name'),
                'item_content' => $this->xml_import->validate($i->content, 'item_content'),
                'item_budget_currency' => $this->xml_import->validate($i->budget_currency, 'item_budget_currency'),
                'item_budget' => $this->xml_import->validate($i->budget, 'item_budget'),
                'item_video' => $this->xml_import->validate($i->video, 'item_video'),
                'item_published' => (string) $i->published == '1' ? '1' : '0',
                'item_sold' => (string) $i->sold == '1' ? '1' : '0',
                'item_status' => '1',
            );
            //SPECIFFIC ATRIBUTES
            if ($i->region) {
                $data['item_region_id'] = $this->xml_import->validate($i->region, 'item_region_id');
            }
            //CHECK IF IT'S INSERT, UPDATE OR INVALID
            $check = $this->xml_model->check_existing_item($user_id, $this->xml_import->validate($i->external_id, 'external_id'));

            if ($check == 'insert') {
                //INSERT NEW ITEM AND RETRIEVE INTERNAL ID
                $response[] = 'New item: ' . $i->external_id;
            } else if (is_array($check) && isset($check['item_id'])) {
                $response[] = 'Existing item: ' . $i->external_id;
            } else {
                $response[] = 'Error with user ' . $user_id . ' and item ' . $i->external_id;
            }



            foreach ($i->options->children() as $x) {

                $current_option = array(
                    'item_id' => $internal_id,
                    'property_id' => (int) $x->attributes()->id,
                    'value' => (string) $x
                );
                //VALIDATE CURRENT OPTION AND RETURN VALIDATED FOR INSERT
                if ($valid_option = $this->xml_import->validate_option($current_option)) {

                    $proc_options_count++;
                } else {
                    $response[] = 'Invalid option ' . $current_option['property_id'] . ' for item ' . $i->external_id . ', option import skipped.';
                    continue;
                }
            }

            //IMAGES
            if ($i->images) {

                foreach ($i->images->children() as $x) {

                    $img_data = array(
                        'item_id' => $internal_id,
                        'import_timestamp' => date('Y-m-d H:i:s'),
                        'image_url' => urldecode($x)
                    );
                    $total_image_count++;
                    $proc_images_count++;
                }
            }


            $response[] = 'Item ' . $i->external_id . ' processed, ' . $proc_options_count . ' valid options, ' . $proc_images_count . ' images available for queue</p>';
            $total_count++;
        }
        $response[] = 'Total item count: ' . $total_count;
        $response[] = 'Total images count: ' . $total_image_count;
        echo implode('<br/>', $response);
        unset($response);
    }

    function do_upload() {
        $config['upload_path'] = 'xml/';
        $config['allowed_types'] = '*';

        $this->load->library('upload', $config);

        if (!$this->upload->do_upload()) {
            $error = array('error' => $this->upload->display_errors());

            $this->load->view('xml_validation_view', $error);
        } else {
            echo '<div style="color:blue;width:50%;margin:0 auto;font-size:24px;">Upload successfull</div>';
            //$this->output->set_header('refresh:1; url='.base_url('xml_validation'));
            $this->output->set_header('refresh:1; url=' . base_url());
        }
    }

    private function delete_listing($id) {
        $this->load->model('admin/listings_model');
        if ($this->listings_model->delete_listing($id)) {
            $subdir = (int) ($id / 1000);
            //PUTANJA DO SADRZAJA
            $dir = FCPATH . 'upload/coll' . $subdir . '/' . $id . '/';
            if (is_dir($dir)) {
                try {
                    //OTKRIVANJE SVIH SADRZAJA U DIREKTORIJU
                    $files = new RecursiveIteratorIterator(
                            new RecursiveDirectoryIterator($dir, RecursiveDirectoryIterator::SKIP_DOTS), RecursiveIteratorIterator::CHILD_FIRST
                    );
                    //BRISANJE SVEGA
                    foreach ($files as $fileinfo) {
                        $todo = ($fileinfo->isDir() ? 'rmdir' : 'unlink');
                        $todo($fileinfo->getRealPath());
                    }
                    //BRISANJE SAMOG DIREKTORIJA
                    rmdir($dir);
                } catch (MyException $e) {
                    $response = array(
                        'response' => 'File removal failed',
                        'success' => 0
                    );
                }
            }


            $response = array(
                'response' => 'Item deleted',
                'success' => 1
            );
        } else {
            $response = array(
                'response' => 'Item not deleted',
                'success' => 0
            );
        }

        return json_encode($response);
    }

    private function delete_listing_files($id) {

        $subdir = (int) ($id / 1000);
        //PUTANJA DO SADRZAJA
        $dir = FCPATH . 'upload/coll' . $subdir . '/' . $id . '/';
        if (is_dir($dir)) {
            try {
                //OTKRIVANJE SVIH SADRZAJA U DIREKTORIJU
                $files = new RecursiveIteratorIterator(
                        new RecursiveDirectoryIterator($dir, RecursiveDirectoryIterator::SKIP_DOTS), RecursiveIteratorIterator::CHILD_FIRST
                );
                //BRISANJE SVEGA
                foreach ($files as $fileinfo) {
                    $todo = ($fileinfo->isDir() ? 'rmdir' : 'unlink');
                    $todo($fileinfo->getRealPath());
                }
                //BRISANJE SAMOG DIREKTORIJA
                rmdir($dir);
            } catch (MyException $e) {
                return false;
            }
        } else {
            return false;
        }
    }

    private function delete_files($type, $listing_id) {
        $response = null;
        if ($type == 'image') {
            $images = $this->xml_model->get_images($listing_id);
            if (!empty($images)) {
                foreach ($images as $image) {
                    $files = json_decode($image['paths']);
                    if (!empty($files)) {
                        foreach ($files as $f) {
                            if (file_exists(FCPATH . $f))
                                unlink(FCPATH . $f);
                        }
                    }
                    if ($this->xml_model->delete_image($listing_id, $image['name_hash'])) {
                        $response = array(
                            'status' => 1,
                            'message' => lang('image_deleted')
                        );
                    }
                }
            }
        } else if ($type == 'document') {

            $documents = $this->xml_model->get_documents($listing_id);
            if (!empty($documents)) {
                foreach ($documents as $document) {
                    $document_path = '/upload/' . $listing_id . '/' . $document['name_hash'] . '.' . $document['extension'];
                    if (file_exists(FCPATH . $document_path)) {
                        if (unlink(FCPATH . $document_path)) {
                            if ($this->listing_model->delete_document($listing_id, $hash)) {
                                $response = array(
                                    'status' => 1,
                                    'message' => lang('document_deleted')
                                );
                            }
                        }
                    }
                }
            }
        }


        return json_encode($response);
    }

    function process_images($limit = 50) {
        $images = $this->db->from('import_images')->limit($limit)->order_by('id', 'asc')->get()->result_array();
        $valid = 0;
        if (!empty($images)) {
            foreach ($images as $i) {
                if ($this->process_image($i['item_id'], $i['image_url'])) {
                    $this->db->delete('import_images', array('id' => $i['id']));
                    $valid++;
                }
            }
        }
        echo 'Queued images: ' . sizeof($images) . '  Processed images: ' . $valid;
    }

    //IMAGES PROCESSING
    private function process_image($listing_id, $url) {
        $this->load->model('listing_model');
        $file = pathinfo($url);
        $subdir = (int) ($listing_id / 1000);

        $path = $this->check_folder('coll' . $subdir . '/' . $listing_id);
        //GENERATE INDEX.HTML TO PREVENT DIRECT ACCESS
        $security_index = $path . '/index.html';
        if (!file_exists($security_index)) {
            $msg = lang('upload_permission');
            file_put_contents($security_index, $msg);
        }
        $original_name = $file['basename'];
        $fn = $this->safeName($file['basename']);
        $file_path = $path . '/' . $fn;


        //FILE CHECK
        if (file_exists($file_path)) {
            $rand = rand(100, 999);
            $file_path = $path . '/' . $rand . $fn;
        }

        if (file_put_contents($file_path, file_get_contents($url))) {
            //ONLY READ PREMISSIONS
            chmod($file_path, 0644);
            //DISTINCT DOCUMENTS AND PHOTOS
            $file_info = pathinfo($file_path);
            $extension = $file_info['extension'];
            $photos = array(
                'jpeg',
                'jpg',
                'png',
                'JPG',
                'JPEG'
            );
            $documents = array(
                'doc',
                'docx',
                'xls',
                'xlsx',
                'pdf',
                'txt'
            );
            if (is_int(array_search($extension, $photos))) {

                //RESIZE
                //BASIC CONF
                $img_config = array(
                    'image_path' => $file_path,
                    'delete_orig' => true,
                    'quality' => 90,
                );
                //OUTPUT IMAGES
                $images = array(
                    'large' => array('w' => 1000),
                    'medium' => array(
                        'w' => 227,
                        'h' => 211
                    ),
                    'medium2' => array(
                        'w' => 450,
                        'h' => 338
                    ),
                    'small' => array(
                        'w' => 100,
                        'h' => 70
                    )
                );
                //OSTAVLJAMO ORGINAL
                $paths = $this->resize_image($img_config, $images);
                //SAVE AS PHOTO
                $img_data = array(
                    'item_id' => $listing_id,
                    'name_hash' => $file_info['filename'],
                    'paths' => json_encode($paths),
                    'extension' => $extension,
                    'upload_datetime' => date('Y-m-d H:i:s')
                );
                if ($this->db->insert('item_images', $img_data))
                    return true;
            } else if (is_int(array_search($extension, $documents))) {

                //SAVE AS DOCUMENT
                $doc_data = array(
                    'item_id' => $listing_id,
                    'name_hash' => $file_info['filename'],
                    'document_name' => $original_name,
                    'extension' => $extension,
                    'upload_datetime' => date('Y-m-d H:i:s')
                );
                $this->listing_model->insert_document($doc_data);
                //GENERAL RESPONSE
                $response = array(
                    'status' => 1,
                    'message' => lang('upload_success'),
                    'file_type' => 'document',
                    'listing_id' => $listing_id,
                    'file_path' => $file_path,
                    'file_info' => $file_info
                );
                return json_encode($response);
            }
            //IF NOT ALLOWED IMAGE OR DOCUMENT
            else {
                $response = array(
                    'status' => 0,
                    'message' => lang('upload_extension')
                );

                return json_encode($response);
            }
        } else {
            $response = array(
                'status' => 0,
                'message' => lang('upload_failed')
            );
            return json_encode($response);
        }
    }

    //UPLOAD
    private function check_folder($path) {
        $real_path = 'upload/' . $path;
        if (is_dir($real_path)) {
            return $real_path;
        } else {
            //ONLY WEB SERVER CAN ACCESS 0700
            if (mkdir($real_path, 0755, true))
                return $real_path;
            else
                return FALSE;
        }
    }

    private function safeName($string) {
        $path_info = pathinfo($string);
        $extension = $path_info['extension'];
        $name = $path_info['filename'];
        $not_allowed = array(
            'php',
            'html',
            'js',
            'jsp'
        );
        if (is_int(array_search($extension, $not_allowed))) {
            die('FILE TYPE NOT ALLOWED');
        }
        // $string = preg_replace('/[^\\pL\d]+/u', '_', $name);
        // $string = trim($string, '_');
        // $string = iconv('utf-8', 'us-ascii//TRANSLIT', $string);
        // $string = strtolower($string);
        // $string = preg_replace('/[^-\w]+/', '', $string);
        $stamp = time();
        $string = md5($name . $stamp);
        return $string . '.' . $extension;
    }

    private function resize_image($img_config = array(), $images = array()) {
        $this->load->library('image_moo');
        //DEFAULT CONFIG
        $image_path = $img_config['image_path'];
        unset($img_config['image_path']);

        if (empty($img_config)) {
            $img_config = array(
                'delete_orig' => true,
                'quality' => 90
            );
        }
        if (empty($images)) {
            $images = array(
                'large' => array('w' => 1000),
                'medium' => array('w' => 600),
                'small' => array('w' => 200)
            );
        }

        //GET IMAGE INFO
        $file_info = pathinfo($image_path);

        foreach ($images as $key => $image) {
            if (!isset($image['quality']))
                $quality = $img_config['quality'];
            else
                $quality = $image['quality'];

            //AKO JE POSTAVLJENA SAMO SIRINA SAMO RADI RESIZE
            if (isset($image['w']) && !isset($image['h']))
                $this->image_moo->set_jpeg_quality($quality)->load($image_path)->resize($image['w'])->save_pa('', '_' . $key, TRUE);
            //AKO SU POSTAVLJENI I SIRINA I VISINA RADI RESIZE CROP
            if (isset($image['w']) && isset($image['h']))
                $this->image_moo->set_jpeg_quality($quality)->load($image_path)->resize_crop($image['w'], $image['h'])->save_pa('', '_' . $key, TRUE);

            $paths[$key . '_image'] = $file_info['dirname'] . '/' . $file_info['filename'] . '_' . $key . '.' . $file_info['extension'];
        }


        return $paths;
    }

}
