<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class User extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model('main_model');
		$this->load->model('listing_model');
		$this->load->helper('language');
		$this->load->helper('text');
		$this->load->helper('url');
		$this->load->library('multilang', array('default_lang' => 'hr', 'multilang'=>true,'segment'=>3));
	}

	public function index() {
		
		
		

		if ($this->require_min_level(1)) {
		
		
		
        //POSTAVLJANJE JEZIKA
        $data['lang']=$this->multilang->get_current();
        //INICIJALIZIRAMO MENU LIB
        $this->load->library('menu',array('lang'=>$data['lang']));
		//DODAJ KREDITE
		$this->add_free_credits();
        //DOHVATIMO MENU ARRAY
        $data['menu_items']=$this->menu->generate_categories_paths();
		$data['notifications']=$this->main_model->get_notifications($this->auth_user_id);	
		$data['my_offers']=$this->listing_model->get_user_offers($this->auth_user_id);
		$data['my_listings']=$this->listing_model->get_user_items($this->auth_user_id); 
		$data['watched_items']=$this->listing_model->get_user_watchlist($this->auth_user_id);			   
		    
			//KORISNICI
			if ($this->_check_profile($this->auth_user_id)) {
				
					$data = array('content' => $this->load->view('user/my_listings_view', $data, TRUE), );

					$this->load->view($this->template, $data);
				} else {
					redirect('user/profile/update');
				}

			} 

		}
	
	public function credit() {
        
        

        if ($this->require_min_level(1)) {
            
			//POSTAVLJANJE JEZIKA
	        $data['lang']=$this->multilang->get_current();
	        //INICIJALIZIRAMO MENU LIB
	        $this->load->library('menu',array('lang'=>$data['lang']));
	        //DOHVATIMO MENU ARRAY
	        $data['menu_items']=$this->menu->generate_categories_paths();
	        $data['my_offers']=$this->listing_model->get_user_offers($this->auth_user_id);
			$data['my_listings']=$this->listing_model->get_user_items($this->auth_user_id); 	
			$data['watched_items']=$this->listing_model->get_user_watchlist($this->auth_user_id);		 	   
	        $data['notifications']=$this->main_model->get_notifications($this->auth_user_id);
			$data['user_credits']=$this->main_model->get_user_credits($this->auth_user_id);	
            $data = array('content' => $this->load->view('user/credits_view', $data, TRUE), );

            $this->load->view($this->template, $data);
        

            } 

        }
	
	
	private function add_free_credits(){
		if ($this->require_min_level(1)) {
			$add_value="5";
			$current_credits=$this->main_model->get_user_credits($this->auth_user_id);
			$this->load->model('credits_model');
			//FIRST TIME ADDING
			if(empty($current_credits)){
				$initial=array(
					'user_id'=>$this->auth_user_id,
					'credits'=>$add_value
				);
				if($this->credits_model->insert($initial)){
						$log_data=array(
							'event_type'=>1,
							'user_id'=>$this->auth_user_id,
							'data'=>json_encode(array(
								'status'=>'1',
								'amount_added'=>$add_value
							))
						);
						$this->main_model->add_credit_log($log_data);
				}
				else{
					$log_data=array(
							'event_type'=>1,
							'user_id'=>$this->auth_user_id,
							'data'=>json_encode(array(
								'status'=>'0',
							))
						);
						$this->main_model->add_credit_log($log_data);
				}
			}
			else{
				//CHECK IF ADDED TODAY
				if(date('Y-m-d',strtotime($current_credits['last_update_timestamp']))!=date('Y-m-d')){
					//IF NOT ADDED TODAY UPDATE
					$new_value=$current_credits['credits']+$add_value;
					$credit_data=array(
					'user_id'=>$this->auth_user_id,
					'credits'=>$new_value
					);
					if($this->credits_model->update($this->auth_user_id,$credit_data)){
						$log_data=array(
							'event_type'=>1,
							'user_id'=>$this->auth_user_id,
							'data'=>json_encode(array(
								'status'=>'1',
								'amount_added'=>$add_value
							))
						);
						$this->main_model->add_credit_log($log_data);
					}
					else{
						$log_data=array(
							'event_type'=>1,
							'user_id'=>$this->auth_user_id,
							'data'=>json_encode(array(
								'status'=>'0',
							))
						);
						$this->main_model->add_credit_log($log_data);
					}
				}
				
			}
		}
	}



    public function messages() {
        
        

        if ($this->require_min_level(1)) {
            
			//POSTAVLJANJE JEZIKA
	        $data['lang']=$this->multilang->get_current();
	        //INICIJALIZIRAMO MENU LIB
	        $this->load->library('menu',array('lang'=>$data['lang']));
	        //DOHVATIMO MENU ARRAY
	        $data['menu_items']=$this->menu->generate_categories_paths();
	        $data['my_offers']=$this->listing_model->get_user_offers($this->auth_user_id);
			$data['my_listings']=$this->listing_model->get_user_items($this->auth_user_id); 	
			$data['watched_items']=$this->listing_model->get_user_watchlist($this->auth_user_id);		 	   
	        $data['notifications']=$this->main_model->get_notifications($this->auth_user_id);
            $data = array('content' => $this->load->view('user/messages_view', $data, TRUE), );

            $this->load->view($this->template, $data);
        

            } 

        }
    
	public function remove_notiffication() {
        if ($this->require_min_level(1)) {
            $id=$this->input->get('id');
			if($this->main_model->delete_notification($id,$this->auth_user_id)){
				$response=array(
					'success'=>1,
					'msg'=>'Poruka je obrisana'
				);
			}
			else{
				$response=array(
					'success'=>0,
					'msg'=>'Poruka je obrisana'
				);
			}
			echo json_encode($response);
            } 

        }
    
        public function settings() {

        if ($this->require_min_level(1)) {
        	$this->load->model('user_model');
			//UPDATE
			if($this->input->post('update')){
		  		$settings_data=array(
				'user_languages'=>json_encode($this->input->post('user_lang',true)),
				'not_listing_publish'=>($this->input->post('not_listing_published'))?'1':'0',
				'not_listing_expired'=>($this->input->post('not_listing_expired'))?'1':'0',
				'not_new_offer'=>($this->input->post('not_new_offer'))?'1':'0',
				);
				if($this->user_model->has_settings($this->auth_user_id)){
					$this->user_model->update_settings($this->auth_user_id,$settings_data);
				}
				else{
					$settings_data['user_id']=$this->auth_user_id;
					$this->user_model->insert_settings($settings_data);
				}
			  }
            
	        //POSTAVLJANJE JEZIKA
	        $data['lang']=$this->multilang->get_current();
	        //INICIJALIZIRAMO MENU LIB
	        $this->load->library('menu',array('lang'=>$data['lang']));
	        //DOHVATIMO MENU ARRAY
	        $data['menu_items']=$this->menu->generate_categories_paths();
	        $data['my_offers']=$this->listing_model->get_user_offers($this->auth_user_id);
			$data['my_listings']=$this->listing_model->get_user_items($this->auth_user_id); 		   
	        $data['notifications']=$this->main_model->get_notifications($this->auth_user_id);    
	        $data['watched_items']=$this->listing_model->get_user_watchlist($this->auth_user_id);	
			$data['my_settings']=$this->user_model->get_user_settings($this->auth_user_id);
	        $data = array('content' => $this->load->view('user/user_settings_view', $data, TRUE), );
	        $this->load->view($this->template, $data);
        
			
            } 

        }
	


	function profile($var = '') {
		
		//POSTAVLJANJE JEZIKA
	        $data['lang']=$this->multilang->get_current();
	        //INICIJALIZIRAMO MENU LIB
	        $this->load->library('menu',array('lang'=>$data['lang']));
	        //DOHVATIMO MENU ARRAY
	        $data['menu_items']=$this->menu->generate_categories_paths();
			
		if ($this->require_min_level(1)) {
			$this->load->model('user_model');
			$user = $this->auth_user_id;
			if ($this->input->post('first_name')) {
				$this->load->library('form_validation');
				
				
				//RULES
				$this->form_validation->set_message('required', 'Polje <strong>%s</strong> je obavezno!');

				$this->form_validation->set_rules('first_name', 'Ime', 'trim|required|xss_clean');
				$this->form_validation->set_rules('last_name', 'Prezime', 'trim|required|xss_clean');
				$this->form_validation->set_rules('phone', 'Tel/mob', 'trim|xss_clean');
				$this->form_validation->set_rules('fax', 'Fax', 'trim|xss_clean');
				$this->form_validation->set_rules('address', 'Adresa', 'trim|required|xss_clean');
				$this->form_validation->set_rules('city', 'Grad', 'trim|required|xss_clean');
				$this->form_validation->set_rules('post_num', 'Poštanski broj', 'trim|required|xss_clean');
                $this->form_validation->set_rules('user_country', lang('auth_country'), 'trim|required|xss_clean');
                $this->form_validation->set_rules('oin', 'OIB', 'trim|required|xss_clean');

				if ($this->form_validation->run() == TRUE) {
					$custom_data=array(
						'user_phone' => $this->input->post('phone'),
						'user_fax' => $this->input->post('fax'),
						'user_address' => $this->input->post('address'),
						'user_city' => $this->input->post('city'),
						'user_post_num' => $this->input->post('post_num'),
						'user_country'=>$this->input->post('user_country'),
					);
					$this->load->library('encrypt');
					$profile_data = array(
						'first_name' => $this->input->post('first_name'),
						'last_name' => $this->input->post('last_name'),
						'user_data' => $this->encrypt->encode(json_encode($custom_data)),
						'oin'		=> $this->encrypt->encode($this->input->post('oin',true))
					);
					
					

					if ($this->user_model->update_user_raw_data($user, array(), $profile_data))
						$data['response']['message'] = lang('auth_user_acc_saved');
				} else {
					$data['validation_errors'] = validation_errors();
				}

			}
			if ($var == 'update')
				$data['response']['message'] = lang('auth_fill_profile');
			else
				$data['response']['message'] = lang('auth_user_acc_edit');
			if($this->input->get('msg')){
				$data['msg']=base64_decode($this->input->get('msg',true));
			}
			$data['user_data'] = $this->user_model->view_user_record($user);
			$data['all_countries']=$this->main_model->get_all_countries();
			$data['my_offers']=$this->listing_model->get_user_offers($this->auth_user_id);
			$data['my_listings']=$this->listing_model->get_user_items($this->auth_user_id); 
			$data['watched_items']=$this->listing_model->get_user_watchlist($this->auth_user_id);			   
	        $data['notifications']=$this->main_model->get_notifications($this->auth_user_id); 
			$data = array('content' => $this->load->view('user/profile_view', $data, TRUE), );

			$this->load->view($this->template, $data);
		}
	}

	function password() {
		$lang = 'hr';
		$this->lang->load('frontend', $lang);
		$data['lang'] = $lang;
		if ($this->require_min_level(1)) {
			$this->load->model('user_model');
			$user = $this->auth_user_id;
			if ($this->input->post('user_pass')) {
				$this->load->library('form_validation');
				//RULES
				$this->form_validation->set_message('required', 'Polje <strong>%s</strong> je obavezno!');
				$this->form_validation->set_message('matches', 'Lozinke se moraju poklapati!');

				$this->form_validation->set_rules('user_pass', 'Lozinka', 'trim|required|xss_clean|matches[conf_pass]');
				$this->form_validation->set_rules('conf_pass', 'Ponovljena lozinka', 'trim|required|xss_clean');

				if ($this->form_validation->run() == TRUE) {

					// Generate a new random user salt
					$new_salt = $this->authentication->random_salt();

					$data = array(
						'user_pass' => $this->authentication->hash_passwd($this->input->post('user_pass'), $new_salt),
						'user_salt' => $new_salt
					);

					if ($this->user_model->update_user_raw_data($user, $data))
						$data['notifications'] = '<p>Lozinka je uspješno promijenjena.</p>';
				} else {
					$data['validation_errors'] = validation_errors();
				}

			}
			$data['view_title'] = 'izmjena lozinke';
			$data = array('content' => $this->load->view('user/password_view', $data, TRUE), );

			$this->load->view($this->template, $data);
		}
	}



	public function register() {

		//POSTAVLJANJE JEZIKA
		$data['lang']=$this->multilang->get_current();
		//INICIJALIZIRAMO MENU LIB
		$this->load->library('menu',array('lang'=>$data['lang']));
		//DOHVATIMO MENU ARRAY
		$data['menu_items']=$this->menu->generate_categories_paths();
		$this->load->library('csrf');
		$data = array('content' => $this->load->view('user/register_view', $data, TRUE), );

		$this->load->view($this->template, $data);

	}
	
	public function process_registration(){
		
		//POSTAVLJANJE JEZIKA
		$data['lang']=$this->multilang->get_current();
		//INICIJALIZIRAMO MENU LIB
		$this->load->library('menu',array('lang'=>$data['lang']));
		//DOHVATIMO MENU ARRAY
		$data['menu_items']=$this->menu->generate_categories_paths();
		
		
		// Load resources
		$this->load->library('csrf');
		
		$this->load->model('registration_model');

		$reg_mode = $this->registration_model->get_reg_mode();
		
		// Check to see if there was a registration submission
		
		if($this->csrf->token_match )
		{
				
				// Store the data
				$attempt=$this->registration_model->set_pending();
				if($attempt && is_int($attempt))
				{
					$registration_id = $attempt;
					$this->load->library('email');
					$this->config->load('email');

					// Send email to registrant to confirm email address
					if( $reg_mode == 2 )
					{
						$sent=$this->email->quick_email( array(
							'subject'        => lang('mail_registration_title'),
							'email_template' => 'email_templates/registration-confirmation-registrant',
							'from_name'      => 'no_reply_email_config',
							'template_data'  => array( 'registration_id' => $registration_id ),
							'to'             => set_value('user_email')
						) );
                       
						
						if($sent){
							$response=array(
								'success'=> 1,
								'message'=> lang('mail_registration_link_message') . " " .set_value('user_email')
							);
						}
						else{
							$response=array(
								'success'=>0,
								'message'=> lang('mail_registration_link_message_error')
							);
						}
					}

					// Send email to admin to inform of pending registration
					else
					{
						$sent=$this->email->quick_email(
							// Sender's Email Address
							config_item('no_reply_email_address'),
							// Sender's Name
							'BuyBooy',
							// Recipient's Email Address
							config_item('registration_review_email_address'),
							// Subject of Email
							lang('mail_registration_title'),
							// Email Template
							'email_templates/registration-notification-admin'
						);
						if($sent){
							$response=array(
								'success'=>1,
								'message'=>'Zahtjev za registraciju je prosljeđen administratoru '
							);
						}
						else{
							$response=array(
								'success'=>0,
								'message'=> lang('mail_registration_link_message_error')
							);
						}
					}
				}
				else if(is_string($attempt)){
					
					$data['validation_errors']=$attempt;
					$response=array(
								'success'=>0,
								'message'=>$attempt
							);
				}
		}
		else{
			$response=array(
						'success'=>0,
						'message'=>'Form token not valid'
					);
		}
		$data['response']=$response;
		// If for some reason the user is already logged in
		//$this->is_logged_in();

		// Send registration mode to view
		$data['reg_mode'] = $reg_mode;

		// Ouput alert-bar message if cookies not enabled
		//$this->check_cookies_enabled();
		
		$data = array(
			'content' => $this->load->view('user/register_view', $data, TRUE)

		);
		$this->load->view( $this->template, $data );
		
		
		//redirect('/user/register', 'refresh');
	}



    public function email_confirmation( $email_conf='' )
    {
    	
		//POSTAVLJANJE JEZIKA
        $data['lang']=$this->multilang->get_current();
        //INICIJALIZIRAMO MENU LIB
        $this->load->library('menu',array('lang'=>$data['lang']));
        //DOHVATIMO MENU ARRAY
        $data['menu_items']=$this->menu->generate_categories_paths();
		
		
        // Load resources
        $this->load->model('registration_model');

        // Check that the registration mode is set to verify registrations by email
        if( $this->registration_model->get_reg_mode() == '2' && $email_conf != '' )
        {

            // If there is a pending registration associated with the registration ID in the URL
            if( $this->registration_model->approve_by_email( (int) $email_conf ) !== FALSE )
            {
                $confirmed_by_email = 1;
            }
            else
            {
                $registration_closed = 1;
            }
        }
        else
        {
            $registration_closed = 1;
        }

        // For whatever reason, show the user as logged in if they are
        $this->is_logged_in();

        // If an email confirmation was successful, show a message
        if( isset( $confirmed_by_email ) )
        {
			
            $data['content'] = '<p>'.lang('mail_confirmation_thanks').'</p>';
        }

        // If an email confirmation was not successful, or if the registration mode is not right, display message
        if( isset( $registration_closed ) )
        {
            $data['content'] = '<p>'.lang('mail_confirmation_error').'</p>';
        }

        $data = array(
           
            'content' => $this->load->view('user/conformation_view', $data, TRUE)

        );
        $this->load->view( $this->template, $data );
        
    }
	
	

        public function recover()
    {
        
        //POSTAVLJANJE JEZIKA
        $view_data['lang']=$this->multilang->get_current();
        //INICIJALIZIRAMO MENU LIB
        $this->load->library('menu',array('lang'=>$view_data['lang']));
        //DOHVATIMO MENU ARRAY
        $view_data['menu_items']=$this->menu->generate_categories_paths();
        
        
        // Load resources
        $this->load->model('user_model');

        // Ouput alert-bar message if cookies not enabled
        $this->check_cookies_enabled('Cookies are required for username/password recovery. Please enable cookies.');

        /// If IP or posted email is on hold, display message
        if( $on_hold = $this->authentication->current_hold_status( TRUE ) )
        {
            $view_data['disabled'] = 1;
        }
        else
        {
            /**
             * Waiting until hold status is confirmed to load CSRF,
             * because we don't want to give out a new token and set
             * the flashdata for nothing
             */
            $this->load->library('csrf');

            // If the form post looks good
            if( $this->csrf->token_match && $this->input->post('user_email') )
            {
                if( $user_data = $this->user_model->get_recovery_data( $this->input->post('user_email') ) )
                {
                    // Check if user is banned
                    if( $user_data->user_banned == '1' )
                    {
                        // Log an error if banned
                        $this->authentication->log_error( $this->input->post('user_email', TRUE ) );

                        // Show special message for banned user
                        $view_data['user_banned'] = 1;
                    }
                    else
                    {
                        /**
                         * Use the password generator to create a random string
                         * that will be hashed and stored as the password recovery key.
                         */
                        $this->load->library('generate_password');
                        $recovery_code = $this->generate_password->set_options( 
                            array( 'exclude' => array( 'char' ) ) 
                        )->random_string(64)->show();

                        $hashed_recovery_code = $this->_hash_recovery_code( $user_data->user_salt, $recovery_code );

                        // Update user record with recovery code and time
                        $this->user_model->update_user_raw_data(
                            $user_data->user_id,
                            array(
                                'passwd_recovery_code' => $hashed_recovery_code,
                                'passwd_recovery_date' => time()
                            )
                        );

                        $this->load->library('email');
                        $this->config->load('email');

                        $this->email->quick_email( array(
                            'subject'        => lang('mail_account_recovery_title'). " " . date("M j, Y"),
                            'email_template' => 'email_templates/user-recovery',
                            'from_name'      => 'no_reply_email_config',
                            'template_data'  => array( 'user_data' => $user_data, 'recovery_code' => $recovery_code ),
                            'to'             => $this->input->post('user_email')
                        ) );

                        $view_data['confirmation'] = 1;
                    }
                }

                // There was no match, log an error, and display a message
                else
                {
                    // Log the error
                    $this->authentication->log_error( $this->input->post('user_email', TRUE ) );

                    $view_data['no_match'] = 1;
                }
            }
        }

        $data = array(
            'content' => $this->load->view( 'user/recover_form', ( isset( $view_data ) ) ? $view_data : '', TRUE )
        );

        $this->load->view( $this->template, $data );
    }

	// --------------------------------------------------------------

	/**
	 * Verification of a user by email for recovery
	 * 
	 * @param  int     the user ID
	 * @param  string  the passwd recovery code
	 */
	public function recovery_verification()
	{
		 //POSTAVLJANJE JEZIKA
        $view_data['lang']=$this->multilang->get_current();
        //INICIJALIZIRAMO MENU LIB
        $this->load->library('menu',array('lang'=>$view_data['lang']));
        //DOHVATIMO MENU ARRAY
        $view_data['menu_items']=$this->menu->generate_categories_paths();
		
		
		//KRAJ JEZIKA
		 $user_id = $this->uri->segment(3, 0);
		 $recovery_code = $this->uri->segment(4, 0);
		/// If IP is on hold, display message
		if( $on_hold = $this->authentication->current_hold_status( TRUE ) )
		{
			$view_data['disabled'] = 1;
		}
		else
		{
			// Load resources
			$this->load->library('csrf');
			$this->load->model('user_model');

			if( 
				/**
				 * Make sure that $user_id is a number and less 
				 * than or equal to 10 characters long
				 */
				is_numeric( $user_id ) && strlen( $user_id ) <= 10 &&

				/**
				 * Make sure that $recovery code is exactly 64 characters long
				 */
				strlen( $recovery_code ) == 64 &&

				/**
				 * Try to get a hashed password recovery 
				 * code and user salt for the user.
				 */
				$recovery_data = $this->user_model->get_recovery_verification_data( $user_id ) )
			{
				
				/**
				 * Check that the recovery code from the 
				 * email matches the hashed recovery code.
				 */
				if( $recovery_data->passwd_recovery_code == $this->_hash_recovery_code( $recovery_data->user_salt, $recovery_code ) )
				{
					$view_data['user_id']       = $user_id;
					$view_data['user_name']     = $recovery_data->user_name;
					$view_data['recovery_code'] = $recovery_data->passwd_recovery_code;
				}

				// Link is bad so show message
				else
				{
					$view_data['recovery_error'] = 1;

					// Log an error
					$this->authentication->log_error('');
				}
			}

			// Link is bad so show message
			else
			{
				$view_data['recovery_error'] = 1;

				// Log an error
				$this->authentication->log_error('');
			}

			/**
			 * If form submission is attempting to change password 
			 * verify that the user_name was good, because there will only
			 * be a user_name if everything else was good.
			 */
			if( 
				$this->csrf->token_match && 
				isset( $view_data['user_name'] ) && 
				$view_data['user_name'] !== FALSE 
			)
			{
					
				$this->user_model->recovery_password_change();
			}
		}

		$data = array(
			'content' => $this->load->view( 'user/choose_password_form', $view_data, TRUE )
		);

		$this->load->view( $this->template, $data );
	}

	// --------------------------------------------------------------

	/**
	 * Hash the password recovery code (uses the authentication library's hash_passwd method)
	 */
	private function _hash_recovery_code( $user_salt, $recovery_code )
	{
		return $this->authentication->hash_passwd( $recovery_code, $user_salt );
	}

	// --------------------------------------------------------------
	

	// --------------------------------------------------------------

	/**
	 * Log out
	 */
	public function logout() {
		$lang = 'hr';
		$this->lang->load('frontend', $lang);
		$data['lang'] = $lang;
		$this->authentication->logout();

		redirect(secure_site_url('/user/'));
	}

	// --------------------------------------------------------------

	//CHECK IF ALL PROFILE IS FILLED
	private function _check_profile($user_id) {
		$this->load->model('user_model');
		$user_data=$this->user_model->view_user_record($user_id);
		if ($user_data->user_data == '')
			return FALSE;
		else
			return TRUE;
	}
    
    
    

}
?>