<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class U extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model('main_model');
		$this->load->model('listing_model');

		$this->load->model('user_model');
		$this->load->helper('language');
		$this->load->helper('url');
		$this->load->helper('links');
		$this->load->helper('text');
		$this->load->helper('cookie');
		$this->load->library('pagination');
		$this->load->library('currency');
		//$this->output->enable_profiler(TRUE);
		$this->load->library('multilang', array(
			'default_lang' => 'hr',
			'multilang' => true,
			'segment' => 3
		));

		session_start();
	}

	public function index() {
        $url=$this->uri->segment(2,null);
        $url=$this->db->escape_like_str($url);
		$this->is_logged_in();
        //POSTAVLJANJE JEZIKA
        $data['lang'] = $this->multilang->get_current();
        if(!isset($data['lang']['country_id']))
            $country_id=null;
        else
            $country_id=$data['lang']['country_id'];
        if($this->input->get('ending_soon'))
            $sort=array('item_expired_datetime'=>'asc');
        else
            $sort=array('item_publish_datetime'=>'desc');
        //INICIJALIZIRAMO MENU LIB
        $this->load->library('menu', array('lang' => $data['lang']));
        //DOHVATIMO MENU ARRAY
        $data['menu_items'] = $this->menu->generate_categories_paths(NULL);
       
		$store_view = 'user/user_listings_view';
		if(is_null($url))
            $url='all';
        else{
            //  $url=$this->db->escape_like_str($url);
           $user_id=$this->user_model->view_user_record_byusername($url,'user_id');
           
        }
        $category_id=$this->input->get('cid',true);

		//PAGINACIJA
		$config['base_url'] = base_url().'u/'.$url;
		$config['suffix'] = '?' . http_build_query($_GET, '', "&");
		$config['first_url'] = $config['base_url'].'?'.http_build_query($_GET);
		$config['uri_segment'] = 3;
		$config['per_page'] = 10; 
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['prev_tag_open'] = '<li class="prev">';
        $config['prev_tag_close'] = '</li>';
        $config['prev_link'] = lang('pagination_previous');
        $config['next_tag_open'] = '<li class="next">';
        $config['next_tag_close'] = '</li>';
        $config['next_link'] = lang('pagination_next');
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="current"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['first_link'] = lang('pagination_first');
        $config['first_tag_open'] = '<li class="first">';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = lang('pagination_last');
        $config['last_tag_open'] = '<li class="last">';
        $config['last_tag_close'] = '</li>';
		
        if ($category_id && $category_id != 'all') {
            $data['submenu_items'] = $this->main_model->get_subcats($category_id, $data['lang']['id']);
            //TRENUTNI ID
            $data['category_info'] = $this->main_model->get_cat_info($category_id, $data['lang']['id']);
            //PROVJERA BREADCRUMBSA
            $data['breadcrumbs'] = $this->menu->getkeypath($data['menu_items'], $category_id);
            $data['category_id'] = $category_id;
            
            //FILTRI
            
        } else {
            $data['category_id'] = 'all';
            $category_id='all';
           
           
        }
        	
        	$config['total_rows'] = $this->main_model->count_user_items($user_id,$country_id,$this->menu->children,null);

			$data['items'] = $this->main_model->get_user_items($user_id,$country_id,$this->menu->children,null,$sort,$config['per_page'],$this->uri->segment($config['uri_segment'],0));
		$this->pagination->initialize($config); 
		$data['pagination']=$this->pagination->create_links();
        //TRENUTNA POZICIJA
        $data['nav_item'] = array('path' => 'category');
        $data['content'] = $this->load->view($store_view, $data, TRUE);

        $this->load->view($this->template, $data);
	}

}
