<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Support extends MY_Controller {
	
	public $advertising_key='sa314n1hfjalfhhlgvu3';

    public function __construct() {
        parent::__construct();
        $this->load->model('main_model');
        $this->load->model('support_model');
		$this->load->model('listing_model');
        $this->load->model('user_model');
        $this->load->library('multilang', array('default_lang' => 'hr', 'multilang' => false));
        $this->load->helper('language');
		$this->load->helper('text');
		$this->load->helper('url');
    }

    public function index() {
        if ($this->require_min_level(1)) {
            $data['lang'] = $this->multilang->get_current();
			 //INICIJALIZIRAMO MENU LIB
        	$this->load->library('menu',array('lang'=>$data['lang']));
            //Active
            if ($this->input->get('active') != '')
                $active = $this->input->get('active', true);
            else
                $active = null;
			$count = $this->support_model->count_tickets($this->auth_user_id,$active);
            //DEFINIRAMO LISTU ATRIBUTA KOJE ŽELIMO, PONOVLJENI ATRIBUTI TREBAJU IMATI DRUGACIJI ALIAS, DEFAULT LANG 1
            $param_list = array('title', 'u.user_id','content','u.user_name','u.user_email','status','submit_datetime', 'c.name as country_name', '', 'spt.id as edit_id', 'spt.id as delete_id');
            $query = $this->support_model->get_tickets($param_list, $this->auth_user_id, $active);
            if (!empty($query)) {
                foreach ($query as $q) {
                    //OBLIKOVANJE PODATAKA ZA ISPIS
                    $q['title'] = htmlspecialchars($q['title']);
                    $q['submit_datetime'] = date('d.m.Y.', strtotime($q['submit_datetime']));
                }
            }
			$data['tickets']=$query;
			 $data['menu_items']=$this->menu->generate_categories_paths();
			$data['notifications']=$this->main_model->get_notifications($this->auth_user_id);	
			$data['my_offers']=$this->listing_model->get_user_offers($this->auth_user_id);
			$data['my_listings']=$this->listing_model->get_user_items($this->auth_user_id); 
			$data['watched_items']=$this->listing_model->get_user_watchlist($this->auth_user_id);
            //SET MENU AND GET CLIENTS
           $data = array('content' => $this->load->view('support/tickets_view', $data, TRUE));
           $this->load->view($this->template, $data);
        }
    }

    public function view_ticket() {
        if ($this->require_min_level(1)) {
            //GET LANG DATA AND SET MENU
            $data['lang'] = $this->multilang->get_current();
			 //INICIJALIZIRAMO MENU LIB
        	$this->load->library('menu',array('lang'=>$data['lang']));
			$id=$this->input->get('ticket_id');
			$data['query'] = $this->support_model->get_ticket($id);
			//USER DATA
			$data['user_data'] = $this->user_model->view_user_record($data['query']['user_id']);	
            if($this->auth_role =='manager'){
                $current_countries=$this->general_model->get_manager_countries($this->auth_user_id);
                if(!empty($current_countries)){
                    $country=array();
                    foreach($current_countries as $cc){
                        $country[]=$cc['country_id'];
                    }
                }
            }
                
            else 
                $country=null;
            
			$data['menu_items']=$this->menu->generate_categories_paths();
			$data['notifications']=$this->main_model->get_notifications($this->auth_user_id);	
			$data['my_offers']=$this->listing_model->get_user_offers($this->auth_user_id);
			$data['my_listings']=$this->listing_model->get_user_items($this->auth_user_id); 
			$data['watched_items']=$this->listing_model->get_user_watchlist($this->auth_user_id);
            //UTIL
            $data = array('content' => $this->load->view('support/ticket_view', $data, TRUE));
            $this->load->view($this->template, $data);
        }
    }

	public function new_ticket(){
		 if ($this->require_min_level(1)) {
            //GET LANG DATA AND SET MENU
            $data['lang'] = $this->multilang->get_current();
			 //INICIJALIZIRAMO MENU LIB
        	$this->load->library('menu',array('lang'=>$data['lang']));
			
			$data['menu_items']=$this->menu->generate_categories_paths();
			$data['notifications']=$this->main_model->get_notifications($this->auth_user_id);	
			$data['my_offers']=$this->listing_model->get_user_offers($this->auth_user_id);
			$data['my_listings']=$this->listing_model->get_user_items($this->auth_user_id); 
			$data['watched_items']=$this->listing_model->get_user_watchlist($this->auth_user_id);
            //UTIL
            $data = array('content' => $this->load->view('support/new_ticket_view', $data, TRUE));
            $this->load->view($this->template, $data);
		 }
	}


	/*
	 * TODO: složi email notifikaciu s linkom an ticket
	 */
	function process_new_ticket(){
		 if ($this->require_min_level(1)) {
		 	
		//GET LANG DATA AND SET MENU
            $data['lang'] = $this->multilang->get_current();
			 //INICIJALIZIRAMO MENU LIB
        	$this->load->library('menu',array('lang'=>$data['lang']));
			
			$data['menu_items']=$this->menu->generate_categories_paths();
			$data['notifications']=$this->main_model->get_notifications($this->auth_user_id);	
			$data['my_offers']=$this->listing_model->get_user_offers($this->auth_user_id);
			$data['my_listings']=$this->listing_model->get_user_items($this->auth_user_id); 
			$data['watched_items']=$this->listing_model->get_user_watchlist($this->auth_user_id);
		/**ADD NOTIFICATION AND SEND MAIL**/
    	$this->load->library('email');
		$this->config->load('email');
		$title=$this->input->post('title',true);
		$content=$this->input->post('content',true);
		$user_data = $this->user_model->view_user_record($this->auth_user_id);	
		$base_data=array(
				'user_id'=>$this->auth_user_id,
				'country_id'=>$user_data->country,
				'title'=>$title,
				'content'=>$content,
				'status'=>'0',
				'archive'=>'0'
			);
		if($id=$this->support_model->add_ticket($base_data)){
			
			$notif_data=array(
					'user_id'=>$this->auth_user_id,
					'type_id'=>5,
					'message'=>lang('supp_ticket_submited'),
					'ticket_id'=>$id
					);
					//SAVE NOTIFICATION
			$this->main_model->add_notification($notif_data);
			
			$ticket_link=base_url().'support/view_ticket?ticket_id='.$id;
			$message=str_replace('%link%',$ticket_link,lang('supp_email_text'));
			$sent=$this->email->quick_email( array(
							'subject'        => 'You have created new ticket',
							'email_template' => 'email_templates/supp_new_ticket',
							'from_name'      => 'no_reply_email_config',
							'template_data'  => array( 'message' => $message ),
							'to'             => $user_data->user_email
						) );
						
			//ADMIN MAIL
				$admin_emails=array_map(function($item) { return $item['user_email']; }, $this->main_model->manager_emails($data['lang']['country_id']));
				$admin_emails=array_merge($admin_emails,array('davor@emicca.com','aleksandar@emicca.com','malavilarebeka@gmail.com'));
				$admin_emails = implode(',',$admin_emails);
				$this->email->quick_email( array(
							'subject'        => 'New support ticket',
							'email_template' => 'email_templates/admin_supp_new_ticket',
							'from_name'      => 'no_reply_email_config',
							'template_data'  => array( 'message' => 'New ticket created.', 'ticket_data'=>$base_data ),
							'to'             => $admin_emails
						) );
			//
				if($sent){
					$response=array(
						'status'=>1,
						'response' => lang('supp_ticket_submited')
					);
				}
				else{
					$response=array(
						'status'=>0,
						'response' => lang('supp_ticket_submited_noemail')
					);
				}
		 }
		}
		else{
					$response=array(
						'status'=>0,
						'response' => lang('supp_ticket_notsubmited')
					);
				}
		$data['ticket_link'] = $ticket_link;
		$data['response']=$response;
		$data = array('content' => $this->load->view('support/ticket_created_view', $data, TRUE));
        $this->load->view($this->template, $data);
	}
 	

    public function process_ticket() {
        if ($this->require_min_level(1)) {
        	$data['lang'] = $this->multilang->get_current();
			$id=$this->input->post('ticket_id',true);
			$ticket = $this->support_model->get_ticket($id);
			if ($ticket['status']=='0'){
				$status = '1';
			}
			else{
				$status = '0';
			}
			$base_data=array(
				'status'=>$status,
			);
			if($thicket['user_id']=$this->auth_user_id){
				if($this->support_model->update_ticket($id,$base_data)){
				$response=array(
						'status'=>1,
						'ticket_status'=>$status,
						'response' => lang('supp_ticket_status_updated')
					);
				}
				else{
					$response=array(
							'status'=>0,
							'response' => lang('supp_ticket_status_notupdated')
						);
				}
			}
			else{
					$response=array(
							'status'=>0,
							'response' => 'Not your ticket'
						);
				}
			
		//OUTPUT RESULT
		echo json_encode($response);
		}
    }
	
	function get_ticket_msg($id){
		if ($this->require_min_level(1)) {
		$data['item_notifications']=$this->support_model->get_ticket_messages($id);
			//READ FLAGS
			if(!empty($data['item_notifications'])){
			foreach($data['item_notifications'] as $msg){
				if($msg['is_read']=='0'){
					$this->support_model->update_ticket_msg($msg['id'],array('is_read'=>'1'));
				}
			}
			}
		$this->load->view('support/ajax_list_ticket_msg',$data);
		}
	}
	
	/*SENDS CUSTOM MESSAGE*/
	/*
	 * TODO: složi admin mail i notifikaciju
	 */
	function ticket_respond() {
		if ($this->require_min_level(1)) {
			    $data['lang'] = $this->multilang->get_current();
				$ticket_id=$this->input->post('ticket_id',true);
				$notification=$this->input->post('resp_text',true);
				/**ADD NOTIFICATION AND SEND MAIL**/
            	$this->load->library('email');
				$this->config->load('email');
				//GENERATE LINK TO ITEM
				//$item_link=base_url().'item/'.url_title($item_name, 'dash', TRUE).'/'.$item_id;
				//GET USER DATA FOR EMAIL
				$this->load->model('user_model');
				$ticket_data=$this->support_model->get_ticket($ticket_id);
            	$user_data=$this->user_model->view_user_record($ticket_data['user_id']);
				//GET MESSAGE AND SET LINK
            	$notif_data=array(
					'user_id'=>$this->auth_user_id,
					'sent_by'=>'user',
					'message'=>$notification,
					'ticket_id'=>$ticket_id,
					'is_read'=>'0'
				);
				//SAVE NOTIFICATION
				
				
				if($this->support_model->add_ticket_msg($notif_data)){
					$response=array(
						'status'=>1,
						'response' => lang('sup_ticket_response_sent')
					);
					
					//ADMIN MAIL
						$admin_emails=array_map(function($item) { return $item['user_email']; }, $this->main_model->manager_emails($data['lang']['country_id']));
						$admin_emails=array_merge($admin_emails,array('davor@emicca.com','aleksandar@emicca.com','malavilarebeka@gmail.com'));
						$admin_emails = implode(',',$admin_emails);
						$this->email->quick_email( array(
									'subject'        => 'New support ticket response',
									'email_template' => 'email_templates/admin_supp_ticket_resp',
									'from_name'      => 'no_reply_email_config',
									'template_data'  => array( 'message' => 'New response for ticket - '.$ticket_id, 'ticket_data'=>$notif_data ),
									'to'             => $admin_emails
								) );
					//
				}
				else{
					$response=array(
						'status'=>0,
						'response' => lang('sup_ticket_response_notsent')
					);
				}
				//OUTPUT RESULT
				echo json_encode($response);
		}
	}


}
