<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Store extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model('main_model');
		$this->load->model('listing_model');

		$this->load->model('store_model');
		$this->load->model('user_model');
		$this->load->helper('language');
		$this->load->helper('url');
		$this->load->helper('links');
		$this->load->helper('text');
		$this->load->helper('cookie');
		$this->load->library('pagination');
		//$this->output->enable_profiler(TRUE);
		$this->load->library('multilang', array(
			'default_lang' => 'hr',
			'multilang' => true,
			'segment' => 3
		));

		session_start();
	}

	public function index() {
		$this->is_logged_in();
		//POSTAVLJANJE JEZIKA
		$data['lang'] = $this->multilang->get_current();
		if (!isset($data['lang']['country_id']))
			$country_id = null;
		else
			$country_id = $data['lang']['country_id'];

		if ($this->input->get('ending_soon'))
			$sort = array('item_expired_datetime' => 'asc');
		else
			$sort = array('item_publish_datetime' => 'desc');
		//INICIJALIZIRAMO MENU LIB
		$this->load->library('menu', array('lang' => $data['lang']));
		//DOHVATIMO MENU ARRAY
		$data['menu_items'] = $this->menu->generate_categories_paths(NULL);
		$category_id = $this->input->get('cid', true);
		if ($this->input->get('sid', true)) {

			$store_id = $this->input->get('sid', true);

			$data['store'] = $this->main_model->get_store($store_id);
			$user_id = $data['store']['user_id'];

			$store_view = 'store/basic_view';

		} else if (isset($this->auth_user_id)) {
			$user_id = $this->auth_user_id;
			$data['store'] = $this->main_model->get_store_byuser($user_id);
			if (empty($data['store'])) {

				$this->db->insert('stores', array('user_id' => $user_id));
				$id = $this->db->insert_id();

				$data['store'] = $this->main_model->get_store_byuser($user_id);
				redirect('store/update');

			} else {
				$store_view = 'store/basic_view';
			}
		} else {
			//PRIKAZI ERROR PAGE
			die();
		}

		//PAGINACIJA
		$config['base_url'] = base_url() . 'store/index';
		$config['suffix'] = '?' . http_build_query($_GET, '', "&");
		$config['first_url'] = $config['base_url'] . '?' . http_build_query($_GET);
		$config['uri_segment'] = 3;
		$config['per_page'] = 10;
		$config['full_tag_open'] = '<ul class="pagination">';
		$config['full_tag_close'] = '</ul>';
		$config['prev_tag_open'] = '<li class="prev">';
		$config['prev_tag_close'] = '</li>';
		$config['prev_link'] = lang('pagination_previous');
		$config['next_tag_open'] = '<li class="next">';
		$config['next_tag_close'] = '</li>';
		$config['next_link'] = lang('pagination_next');
		$config['num_tag_open'] = '<li>';
		$config['num_tag_close'] = '</li>';
		$config['cur_tag_open'] = '<li class="current"><a href="#">';
		$config['cur_tag_close'] = '</a></li>';
		$config['first_link'] = lang('pagination_first');
		$config['first_tag_open'] = '<li class="first">';
		$config['first_tag_close'] = '</li>';
		$config['last_link'] = lang('pagination_last');
		$config['last_tag_open'] = '<li class="last">';
		$config['last_tag_close'] = '</li>';

		if ($category_id && $category_id != 'all') {
			$data['submenu_items'] = $this->main_model->get_subcats($category_id, $data['lang']['id']);
			//TRENUTNI ID
			$data['category_info'] = $this->main_model->get_cat_info($category_id, $data['lang']['id']);
			//PROVJERA BREADCRUMBSA
			$data['breadcrumbs'] = $this->menu->getkeypath($data['menu_items'], $category_id);
			$data['category_id'] = $id;
			//FILTRI
			$data['filters'] = $this->main_model->get_category_properties_groups($data['breadcrumbs'], $data['lang']['id']);
		} else {
			$data['category_id'] = 'all';
		}
		//ITEMS IN CATEGORY
		if ($this->input->get('filter')) {
			$group_count = 0;
			$filter = array();
			$raw_filters = $this->input->get('filter', true);
			foreach ($raw_filters as $rf) {
				$group_count++;
				foreach ($rf as $key => $sf) {
					$filter[] = $key;
				}
			}
			$config['total_rows'] = $this->main_model->s_count_by_filter($country_id, $user_id, $filter, $group_count, null);
			$data['items'] = $this->main_model->s_get_by_filter($country_id, $user_id, $filter, $group_count, null, $sort, $config['per_page'], $this->uri->segment($config['uri_segment'], 0));
		} else {

			$config['total_rows'] = $this->main_model->s_count_items($country_id, $user_id, null);
			$data['items'] = $this->main_model->s_get_items($country_id, $user_id, null, $sort, $config['per_page'], $this->uri->segment($config['uri_segment'], 0));
		}
		$this->pagination->initialize($config);

		$data['pagination'] = $this->pagination->create_links();
		//TRENUTNA POZICIJA
		$data['nav_item'] = array('path' => 'category');
		$data['content'] = $this->load->view($store_view, $data, TRUE);

		$this->load->view($this->template, $data);
	}

	function update($var = null) {
		if ($this->require_min_level(1)) {
			$data['store'] = $this->main_model->get_store_byuser($this->auth_user_id);
			if (empty($data['store'])) {

				$this->db->insert('stores', array('user_id' => $this->auth_user_id));
				$id = $this->db->insert_id();

				$data['store'] = $this->main_model->get_store_byuser($this->auth_user_id);
				redirect('store/update/new');

			}
			if (is_null($var) && !is_null($data['store']['store_url']))
				$data['show_url_picker'] = false;
			else
				$data['show_url_picker'] = true;
			//POSTAVLJANJE JEZIKA
			$data['lang'] = $this->multilang->get_current();
			//INICIJALIZIRAMO MENU LIB
			$this->load->library('menu', array('lang' => $data['lang']));
			//DOHVATIMO MENU ARRAY
			$data['menu_items'] = $this->menu->generate_categories_paths();
			$data['store_categories'] = $this->store_model->get_categories($data['lang']['id']);
			$data['notifications'] = $this->main_model->get_notifications($this->auth_user_id);
			$data['my_offers'] = $this->listing_model->get_user_offers($this->auth_user_id);
			$data['my_listings'] = $this->listing_model->get_user_items($this->auth_user_id);
			$data['watched_items'] = $this->listing_model->get_user_watchlist($this->auth_user_id);

			//POST
			if ($this->input->post('name')) {
				$this->load->library('image_moo');
				//IMAGE FILE
				$allowedExts = array(
					"jpeg",
					"jpg",
					"png",
					"JPEG",
					"JPG"
				);
				//HEADER IMAGE UPLOAD
				$temp = explode(".", $_FILES["header_image"]["name"]);
				$h_extension = end($temp);
				if (isset($_FILES["header_image"]["type"]) && (($_FILES["header_image"]["type"] == "image/jpeg") || ($_FILES["header_image"]["type"] == "image/jpg") || ($_FILES["header_image"]["type"] == "image/pjpeg") || ($_FILES["header_image"]["type"] == "image/x-png") || ($_FILES["header_image"]["type"] == "image/png")) && ($_FILES["header_image"]["size"] < 2000000) && in_array($h_extension, $allowedExts)) {
					$h_path = $this->check_folder('stores/' . $data['store']['store_id']);
					$full_h_path = $h_path . '/header.' . $h_extension;
					move_uploaded_file($_FILES["header_image"]["tmp_name"], $full_h_path);
					$this->image_moo->set_jpeg_quality(100)->load($full_h_path)->resize_crop(1158, 346)->save($full_h_path, true);
				}
				//LOGO UPLOAD
				$temp = explode(".", $_FILES["logo_image"]["name"]);
				$l_extension = end($temp);
				if (isset($_FILES["logo_image"]["type"]) && (($_FILES["logo_image"]["type"] == "image/jpeg") || ($_FILES["logo_image"]["type"] == "image/jpg") || ($_FILES["logo_image"]["type"] == "image/pjpeg") || ($_FILES["logo_image"]["type"] == "image/x-png") || ($_FILES["logo_image"]["type"] == "image/png")) && ($_FILES["logo_image"]["size"] < 2000000) && in_array($l_extension, $allowedExts)) {
					$l_path = $this->check_folder('stores/' . $data['store']['store_id']);
					$full_l_path = $l_path . '/logo.' . $l_extension;
					move_uploaded_file($_FILES["logo_image"]["tmp_name"], $full_l_path);
					$this->image_moo->set_jpeg_quality(100)->load($full_l_path)->resize_crop(300, 300)->save($full_l_path, true);
				}

				$store_data = array(
					'name' => $this->input->post('name', true),
					'description' => $this->input->post('description', true),
					'contact_data' => json_encode($this->input->post('cdata')),
					'store_category' => $this->input->post('store_category', true),
				);
				//URL

				if ($this->input->post('store_url') || $this->input->post('custom_store_url')) {
					$url = url_title($this->input->post('custom_store_url', true),'-',true);
					if (strlen($url) == 0)
						$store_data['store_url'] = $this->input->post('store_url', true);
					else {
						if ($this->store_model->check_store_url($url, $data['store']['store_id']))
							$store_data['store_url'] = $url;
						else
							$data['url_check'] = "Please select other store URL";
						echo "test";
					}
				}

				if (isset($h_path))
					$store_data['header_image'] = $full_h_path;
				if (isset($l_path))
					$store_data['logo_image'] = $full_l_path;
				if ($this->db->update('stores', $store_data, array('store_id' => $data['store']['store_id']))) {
					$data['update'] = '<div role="alert" class="alert alert-success">Podaci su uspješno spremljeni.</div>';
					$data['store'] = $this->main_model->get_store_byuser($this->auth_user_id);
				} else
					$data['update'] = '<div role="alert" class="alert alert-danger">Desila se greška kod spremanja!</div>';
			}

			//
			$data = array('content' => $this->load->view('store/update_view', $data, TRUE), );
			$this->load->view($this->template, $data);
		}
	}

	//UPLOAD
	private function check_folder($path) {
		$real_path = 'upload/' . $path;
		if (is_dir($real_path)) {
			return $real_path;
		} else {
			//ONLY WEB SERVER CAN ACCESS 0700
			if (mkdir($real_path, 0755, true))
				return $real_path;
			else
				return FALSE;
		}

	}

}
