<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Search extends MY_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('main_model');
		$this->load->model('store_model');
        $this->load->helper('language');
        $this->load->helper('url');
        $this->load->helper('links');
        $this->load->helper('text');
        $this->load->helper('cookie');
		$this->load->library('currency');
        //$this->output->enable_profiler(TRUE);
        $this->load->library('multilang', array('default_lang' => 'hr', 'multilang' => true, 'segment' => 3));
        $this->load->library('pagination');
    }

    public function index() {
        
        $this->is_logged_in();
        
        //POSTAVLJANJE JEZIKA
        $data['lang'] = $this->multilang->get_current();
        if(!isset($data['lang']['country_id']))
			$country_id=null;
		else
			$country_id=$data['lang']['country_id'];
        //INICIJALIZIRAMO MENU LIB
        $this->load->library('menu', array('lang' => $data['lang']));
        
        //DOHVATIMO MENU ARRAY
        $data['menu_items'] = $this->menu->generate_categories_paths(NULL);
        $search_string = $this->input->get('search', true);
		$search_string=str_replace('"', "", $search_string);
		$search_string=str_replace("'", "", $search_string);
        $cid = $this->input->get('cid', true);

        //PAGINACIJA
        $config['base_url'] = base_url() . 'search/index';
        $config['suffix'] = '?' . http_build_query($_GET, '', "&");
        $config['first_url'] = $config['base_url'] . '?' . http_build_query($_GET);
        $config['uri_segment'] = 3;
        $config['per_page'] = 10;
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['prev_tag_open'] = '<li class="prev">';
        $config['prev_tag_close'] = '</li>';
        $config['prev_link'] = lang('pagination_previous');
        $config['next_tag_open'] = '<li class="next">';
        $config['next_tag_close'] = '</li>';
        $config['next_link'] = lang('pagination_next');
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="current"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['first_link'] = lang('pagination_first');
        $config['first_tag_open'] = '<li class="first">';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = lang('pagination_last');
        $config['last_tag_open'] = '<li class="last">';
        $config['last_tag_close'] = '</li>';
        
        if($cid!='all'){
        	$data['breadcrumbs'] = $this->menu->getkeypath($data['menu_items'], $cid);
			$cat_span=$this->menu->children;
        }
		else{
			$cat_span='all';
		}
		
        $config['total_rows'] = $this->main_model->simple_search_count_items($country_id,$search_string, $cat_span, $this->multilang->country_languages);
        $data['items'] = $this->main_model->simple_search_items($country_id,$search_string, $cat_span, null, $config['per_page'], $this->uri->segment($config['uri_segment'], 0));
		$data['ending_soon']=$this->main_model->simple_search_items($country_id,$search_string, $cat_span, null, 6, 0, array('attr'=>'i.item_expired_datetime','type'=>'desc'));
        $this->pagination->initialize($config);
        $data['pagination'] = $this->pagination->create_links();
        //TRENUTNA POZICIJA
        $data['nav_item'] = array('path' => 'search');
        
        $data['content'] = $this->load->view('main/simple_search_view', $data, TRUE);

        $this->load->view($this->template, $data);
    }

    public function live_search() {
    	
    	$data['lang'] = $this->multilang->get_current();
		
		if(!isset($data['lang']['country_id']))
			 $country_id=null;
		 else
			 $country_id=$data['lang']['country_id'];
		 
		 $response=array();
		 $response['query']='Unit';
		 $response['suggestions']=array();
		 
		$cid = $this->input->get('cid', true);
        $search_string = $this->input->get('query', true);
        $search_result = $this->main_model->live_search($country_id,$search_string, 'all', null);
        if (!empty($search_result)) {
            foreach ($search_result as $result) {
            	$response['suggestions'][]=array(
					'value'=>$result['item_name'],
					'data'=>$result['item_id']
				);
            }
        }
		
	echo json_encode($response);
    	
        // $data['lang'] = $this->multilang->get_current();
		// if(!isset($data['lang']['country_id']))
			// $country_id=null;
		// else
			// $country_id=$data['lang']['country_id'];
        // $cid = $this->input->post('cid', true);
        // $search_string = $this->input->post('search_query', true);
        // $search_result = $this->main_model->live_search($country_id,$search_string, $cid, null);
// 	
        // if (!empty($search_result)) {
            // foreach ($search_result as $result) {
                // echo '<p><a href="' . base_url() . 'search/index?search=' . htmlentities($result['item_name']) . '&cid=' . $cid . '">' . $result['item_name'] . '</a></p>';
            // }
        // }
    }

}
