<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class S extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model('main_model');
		$this->load->model('listing_model');

		$this->load->model('store_model');
		$this->load->model('user_model');
		$this->load->helper('language');
		$this->load->helper('url');
		$this->load->helper('links');
		$this->load->helper('text');
		$this->load->helper('cookie');
		$this->load->library('pagination');
		$this->load->library('currency');
		//$this->output->enable_profiler(TRUE);
		$this->load->library('multilang', array(
			'default_lang' => 'hr',
			'multilang' => true,
			'segment' => 3
		));

		session_start();
	}

	public function index() {
		
		$this->is_logged_in();
		
		
		$url = $this->uri->segment(2, null);
		$url = $this->db->escape_str($url);
		$this->is_logged_in();
		//POSTAVLJANJE JEZIKA
		$data['lang'] = $this->multilang->get_current();
		if (!isset($data['lang']['country_id']))
			$country_id = null;
		else
			$country_id = $data['lang']['country_id'];
		if ($this->input->get('ending_soon'))
			$sort = array('item_expired_datetime' => 'asc');
		else
			$sort = array('item_publish_datetime' => 'desc');
		//INICIJALIZIRAMO MENU LIB
		$this->load->library('menu', array('lang' => $data['lang']));
		//DOHVATIMO MENU ARRAY
		$data['menu_items'] = $this->menu->generate_categories_paths(NULL);

		$store_view = 'store/basic_view';
		if (is_null($url))
			$url = 'all';
		else {
			//  $url=$this->db->escape_like_str($url);
			$data['store'] = $this->store_model->get_store_byurl($url);
			$this->db->update('stores', array('view_count' => $data['store']['view_count']+ 1), array('store_id' => $data['store']['store_id']));
			
			
			//echo $this->db->last_query();
			$user_id = $data['store']['user_id'];
		}
		$category_id = $this->input->get('cid', true);

		//PAGINACIJA
		$config['base_url'] = base_url() . 's/' . $url;
		$config['suffix'] = '?' . http_build_query($_GET, '', "&");
		$config['first_url'] = $config['base_url'] . '?' . http_build_query($_GET);
		$config['uri_segment'] = 3;
		$config['per_page'] = 10;
		$config['full_tag_open'] = '<ul class="pagination">';
		$config['full_tag_close'] = '</ul>';
		$config['prev_tag_open'] = '<li class="prev">';
		$config['prev_tag_close'] = '</li>';
		$config['prev_link'] = lang('pagination_previous');
		$config['next_tag_open'] = '<li class="next">';
		$config['next_tag_close'] = '</li>';
		$config['next_link'] = lang('pagination_next');
		$config['num_tag_open'] = '<li>';
		$config['num_tag_close'] = '</li>';
		$config['cur_tag_open'] = '<li class="current"><a href="#">';
		$config['cur_tag_close'] = '</a></li>';
		$config['first_link'] = lang('pagination_first');
		$config['first_tag_open'] = '<li class="first">';
		$config['first_tag_close'] = '</li>';
		$config['last_link'] = lang('pagination_last');
		$config['last_tag_open'] = '<li class="last">';
		$config['last_tag_close'] = '</li>';

		if ($category_id && $category_id != 'all') {
			$data['submenu_items'] = $this->main_model->get_subcats($category_id, $data['lang']['id']);
			//TRENUTNI ID
			$data['category_info'] = $this->main_model->get_cat_info($category_id, $data['lang']['id']);
			//PROVJERA BREADCRUMBSA
			$data['breadcrumbs'] = $this->menu->getkeypath($data['menu_items'], $category_id);
			$data['category_id'] = $category_id;
			$data['sidemenu'] = $this->store_model->get_sidemenu($user_id, $category_id, $this->menu->children);
			//FILTRI
			$data['filters'] = $this->main_model->get_category_properties_groups($data['breadcrumbs'], $data['lang']['id']);
		} else {
			$data['category_id'] = 'all';

			$data['sidemenu'] = $this->store_model->get_sidemenu($user_id);

		}
		//ITEMS IN CATEGORY
		if ($this->input->get('filter')) {
			$group_count = 0;
			$filter = array();
			$raw_filters = $this->input->get('filter', true);
			foreach ($raw_filters as $rf) {
				$group_count++;
				foreach ($rf as $key => $sf) {
					$filter[] = $key;
				}
			}
			$config['total_rows'] = $this->main_model->s_count_by_filter($country_id, $user_id, $filter, $group_count, null);
			$data['items'] = $this->main_model->s_get_by_filter($country_id, $user_id, $filter, $group_count, null, $sort, $config['per_page'], $this->uri->segment($config['uri_segment'], 0));
			$data['item_count'] = $config['total_rows'];		
		} else {

			$config['total_rows'] = $this->main_model->s_count_items($country_id, $user_id, $this->menu->children, null);
			$data['items'] = $this->main_model->s_get_items($country_id, $user_id, $this->menu->children, null, $sort, $config['per_page'], $this->uri->segment($config['uri_segment'], 0));
			$data['item_count'] = $config['total_rows'];
		}
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		//TRENUTNA POZICIJA
		$data['nav_item'] = array('path' => 'category');
		$data['content'] = $this->load->view($store_view, $data, TRUE);

		$this->load->view($this->template, $data);
	}

	function all() {
		//POSTAVLJANJE JEZIKA
		$data['lang'] = $this->multilang->get_current();
		if (!isset($data['lang']['country_id']))
			$country_id = null;
		else
			$country_id = $data['lang']['country_id'];
		//INICIJALIZIRAMO MENU LIB
		$this->load->library('menu', array('lang' => $data['lang']));
		//DOHVATIMO MENU ARRAY
		$data['menu_items'] = $this->menu->generate_categories_paths(NULL);
		$data['category_id'] = 'all';
		//PAGINACIJA
		$config['base_url'] = base_url() . 's/all/';
		$config['uri_segment'] = 3;
		$config['per_page'] = 10;
		$config['full_tag_open'] = '<ul class="pagination">';
		$config['full_tag_close'] = '</ul>';
		$config['prev_tag_open'] = '<li class="prev">';
		$config['prev_tag_close'] = '</li>';
		$config['prev_link'] = lang('pagination_previous');
		$config['next_tag_open'] = '<li class="next">';
		$config['next_tag_close'] = '</li>';
		$config['next_link'] = lang('pagination_next');
		$config['num_tag_open'] = '<li>';
		$config['num_tag_close'] = '</li>';
		$config['cur_tag_open'] = '<li class="current"><a href="#">';
		$config['cur_tag_close'] = '</a></li>';
		$config['first_link'] = lang('pagination_first');
		$config['first_tag_open'] = '<li class="first">';
		$config['first_tag_close'] = '</li>';
		$config['last_link'] = lang('pagination_last');
		$config['last_tag_open'] = '<li class="last">';
		$config['last_tag_close'] = '</li>';

		$config['total_rows'] = $this->store_model->count_all($country_id);
		$data['items'] = $this->store_model->get_all($country_id, $config['per_page'], $this->uri->segment($config['uri_segment'], 0));
		//print_R($data['items']);

		$this->pagination->initialize($config);

		$data['pagination'] = $this->pagination->create_links();
		//TRENUTNA POZICIJA
		$data['nav_item'] = array('path' => 's');
		$data['content'] = $this->load->view('store/all_stores_view', $data, TRUE);

		$this->load->view($this->template, $data);
	}

}
