<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Page extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model('main_model');
		$this->load->helper('language');
		$this->load->helper('url');
		$this->load->helper('links');
		$this->load->helper('text');
		$this->load->helper('cookie');
		//$this->output->enable_profiler(TRUE);
		$this->load->library('multilang', array('default_lang' => 'hr', 'multilang'=>true,'segment'=>3));
	}
	
	public function index(){
	    
        $this->is_logged_in();
		
		//POSTAVLJANJE JEZIKA
		$data['lang']=$this->multilang->get_current();
		$data['sys_countries']=$this->main_model->get_sys_countries();
		if(!isset($data['lang']['country_id']))
			$country_id=null;
		else
			$country_id=$data['lang']['country_id'];
		
		$this->load->library('menu',array('lang'=>$data['lang']));
		
		$data['menu_items']=$this->menu->generate_categories_paths();
		
		$id=$this->uri->segment(3);
		if($id>0){
			$data['page']=$this->main_model->get_page($id,$data['lang']['country_id']);
			$data['sister_pages']=$this->main_model->get_pages($data['page']['parent_id'],$data['lang']['country_id']);
		}		
		$data['nav_item']=array('path'=>'page');
		if($this->input->get('ending_soon'))
			$data['frontend_items']=$this->main_model->get_expiring_items($country_id,null,6);
		else if($this->input->get('watching'))
			$data['frontend_items']=array();
		else
			$data['frontend_items']=$this->main_model->get_latest_items($country_id,null,6);
		
		
		$data['content'] = $this->load->view('pages/page_view', $data, TRUE);

		$this->load->view($this->template, $data);
	}

}