<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Messages extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model('main_model');
		$this->load->model('messages_model');
		$this->load->model('user_model');
		$this->load->model('offers_model');
		$this->load->model('listing_model');
		$this->load->helper('language');
		$this->load->helper('url');
		$this->load->helper('text');
		$this->load->helper('cookie');
		//$this->output->enable_profiler(TRUE);
		$this->load->library('multilang', array(
			'default_lang' => 'hr',
			'multilang' => true,
			'segment' => 3
		));
		
		session_start();
	}


	public function send() {
		//IF IS LOGGED IN
		$this->is_logged_in();
		$data['lang'] = $this->multilang->get_current();
		if (isset($this->auth_user_id)) {
			$offer_id=$this->input->post('offer_id',true);
			$user_id=$this->auth_user_id;
			$recipient_id=(int)trim($this->input->post('recipient_id',true));
			$message=$this->input->post('message',true);
			$msg_data=array(
				'offer_id'=>$offer_id,
				'user_id'=>$user_id,
				'recipient_id'=>$recipient_id,
				'content'=>$message,
			);
			
			if($msg_id=$this->messages_model->insert($msg_data)){
				//CONNECT ATTACHMENTS
				if(isset($_SESSION['attachments']) && !empty($_SESSION['attachments'])){
					foreach($_SESSION['attachments'] as $att){
						$att_data=array(
							'message_id'=>$msg_id
						);
						$this->messages_model->update_att($att,$att_data);
					}
					unset($_SESSION['attachments']);
				}
				
				/**ADD NOTIFICATION AND SEND MAIL**/
            	$this->load->library('email');
				$this->config->load('email');
            	//BASIC DATA ABOUT ITEM
	            $base_data=$this->offers_model->get_base_data($offer_id);
				
				//GET USER DATA FOR EMAIL
            	$user_data=$this->user_model->view_user_record($recipient_id);

            	$origin_data=$this->main_model->get_sys_country($user_data->country);
				//GENERATE LINK TO ITEM
				$item_link='http://www.'.$origin_data['domain'].'/item/'.url_title($base_data['item_name'], 'dash', TRUE).'/'.$base_data['item_id'].'?o_id='.$offer_id.'#offer_'.$offer_id;
				//GET MESSAGE AND SET LINK
				if($recipient_id==$base_data['offer_owner']){
					$message=str_replace('%link%',$item_link,lang('not_offer_message'));
					$message=str_replace('%listing_title%',$base_data['item_name'],$message);
					$message=str_replace('%offer_title%',$base_data['offer_title'],$message	);
				}
				else if($recipient_id==$base_data['item_owner']){
					$message=str_replace('%link%',$item_link,lang('not_item_message'));
					$message=str_replace('%listing_title%',$base_data['item_name'],$message);
					$message=str_replace('%offer_title%',$base_data['offer_title'],$message	);
				}
				
            	$notif_data=array(
					'user_id'=>$recipient_id,
					'type_id'=>4,
					'message'=>$message
				);
				//SAVE NOTIFICATION
				$this->main_model->add_notification($notif_data);
				//SEND MAIL
				$sent=$this->email->quick_email( array(
							'subject'        => lang('not_mail_title'),
							'email_template' => 'email_templates/notification',
							'from_name'      => 'no_reply_email_config',
							'template_data'  => array( 'message' => $message ),
							'to'             => $user_data->user_email
						) );
				/**END NOTIFICATION**/
				
				$response=array(
					'success'=>1,
					'msg'=>'Message sent'
				);
			}
			else{
				$response=array(
					'success'=>0,
					'msg'=>'Message not sent'
				);
			}
		}
		else{
			//IF NOT LOGGED IN
			$response=array(
					'success'=>0,
					'msg'=>'Log in to send messages'
				);
		}
		echo json_encode($response);
	}
	
	private function fetch_latest_messages(){
		if($offer_id=$this->input->post('offer_id')){
			$data['messages']=$this->messages_model->get_latest($offer_id,5);
			$this->load->view('messages/list_view',$data);
		}
	}
	
	public function fetch_all_messages(){
		$this->is_logged_in();
		if (isset($this->auth_user_id)) {
			//POSTAVLJANJE JEZIKA
			$data['lang'] = $this->multilang->get_current();
			$this->load->model('user_model');
			if($offer_id=$this->input->post('offer_id')){
				$owners=$this->offers_model->get_item_offer_owners($offer_id);
				if($this->auth_user_id==$owners['item_owner'] || $this->auth_user_id==$owners['offer_owner']){
					
					$data['messages']=$this->messages_model->get_all($offer_id);
					$data['offer_id']=$offer_id;
					$users=$this->messages_model->get_users($offer_id);
					$data['users']=array();
					if(!empty($users)){
						foreach($users as $u){
							$data['users'][$u['user_id']]=$this->user_model->view_user_record($u['user_id']);
						}
					}
					$this->load->view('messages/list_view',$data);
				}
				else{
							//IF NOT LOGGED IN
							$response=array(
									'success'=>0,
									'msg'=>'You cant view this messages'
								);
							echo json_encode($response);
						}
				
			}
		}
		else{
			//IF NOT LOGGED IN
			$response=array(
					'success'=>0,
					'msg'=>'Log in to send messages'
				);
			echo json_encode($response);
		}
	}

	function delete_message(){
		$this->is_logged_in();
		if (isset($this->auth_user_id)) {
			//POSTAVLJANJE JEZIKA
			$data['lang'] = $this->multilang->get_current();
			$this->load->model('user_model');
			if($message_id=$this->input->post('msg_id')){
				if($this->messages_model->is_owner($this->auth_user_id,$message_id)){
					
					$message_att=$this->messages_model->get_attachments($message_id);
					foreach($message_att as $att){
						$attachment=$this->messages_model->get_attachment($att['id']);
						//IMAGES
						if($attachment['type']==1){
							$files = json_decode($attachment['paths']);
							if (!empty($files)) {
								foreach ($files as $f) {
									if (file_exists(FCPATH . $f))
										unlink(FCPATH . $f);
								}
							}
						}
						//DOCUMENTS
						else if($attachment['type']==2){
							if (file_exists(FCPATH . $attachment['paths']))
										unlink(FCPATH . $attachment['paths']);
						}
						$this->messages_model->delete_attachment($att['id']);
					}
					$this->messages_model->delete($message_id);
					$response=array(
									'success'=>1,
									'msg'=> lang('message_deleted')
								);
							echo json_encode($response);
				}
				else{
							//IF NOT LOGGED IN
							$response=array(
									'success'=>0,
									'msg'=> lang('message_permission_delete')
								);
							echo json_encode($response);
						}
				
			}
		}
		else{
			//IF NOT LOGGED IN
			$response=array(
					'success'=>0,
					'msg'=> lang('message_login')
				);
			echo json_encode($response);
		}
	}

	function cancel_message(){
		//DELETE UPLOADED ATTACHMENTS
		if(isset($_SESSION['attachments']) && !empty($_SESSION['attachments'])){
			
					foreach($_SESSION['attachments'] as $att){
						$attachment=$this->messages_model->get_attachment($att);
						//IMAGES
						if($attachment['type']==1){
							$files = json_decode($attachment['paths']);
							if (!empty($files)) {
								foreach ($files as $f) {
									if (file_exists(FCPATH . $f))
										unlink(FCPATH . $f);
								}
							}
						}
						//DOCUMENTS
						else if($attachment['type']==2){
							if (file_exists(FCPATH . $attachment['paths']))
										unlink(FCPATH . $attachment['paths']);
						}
						$this->messages_model->delete_attachment($att);
					}
					unset($_SESSION['attachments']);
				}
	}

	public function attachment() {
		$data['lang'] = $this->multilang->get_current();
		if($id=$this->input->get('message_id')){
			//IMAGES AND DOCS
		$data['documents']=$this->messages_model->get_attachments($id,2);
		$data['message_id']=$id;
		$data['content'] = $this->load->view('include/msg_attachment_view', $data);
		}
		
	}

	public function download_attachment(){
		$this->load->helper('download');
		$id=$this->input->get('id',true);
		$att=$this->messages_model->get_attachment($id);
		if($file=file_get_contents($att['paths'])){
			$name=$att['file_name'];
			force_download($name,$file);
		}
		else{
			echo "File does not exist";
		}
	}

//UPLOAD
	function upload() {
    	//IF LOGGED IN
		if ($this->require_min_level(1)) {
		$listing_id=$this->input->get('listing_id',true);
		$offer_id=$this->input->get('offer_id',true);
		//IF OWNER OF LISTING OR OWNER OF OFFER
		 if ($this->listing_model->is_owner($this->auth_user_id, $listing_id) || $this->offers_model->is_owner($this->auth_user_id, $listing_id)){
	        if (!empty($_FILES)) {
	        	$file = $_FILES['file'];
	            $tempFile = $file['tmp_name'];
				
				$path = $this->check_folder($listing_id.'/'.$this->auth_user_id.'/att');
				//GENERATE INDEX.HTML TO PREVENT DIRECT ACCESS
				$security_index = $path.'/index.html';
				if (!file_exists($security_index)) {
					$msg="You don't have premissions to access this location.";
					file_put_contents($security_index, $msg);
				}
				$original_name=$file['name'];
				$fn = $this->safeName($file['name']);
				$file_path = $path . '/' . $fn;

				//FILE CHECK
				if (file_exists($file_path)) {
					$rand = rand(100, 999);
					$file_path = $path . '/' . $rand . $fn;
				}
				
				if(move_uploaded_file($file['tmp_name'], $file_path)){
					//ONLY READ PREMISSIONS
					chmod($file_path, 0644);
					//DISTINCT DOCUMENTS AND PHOTOS
					$file_info = pathinfo($file_path);
					$extension = $file_info['extension'];
					$photos = array(
						'jpeg',
						'jpg',
						'png',
						'JPG',
						'JPEG'
					);
					$documents=array(
						'doc',
						'docx',
						'xls',
						'xlsx',
						'pdf',
						'txt'
					);
					if (is_int(array_search($extension, $photos))) {
						
						//RESIZE
						//BASIC CONF
						$img_config = array(
						'image_path' => $file_path,
						'delete_orig' => true,
						'quality' => 90,
						);
						//OUTPUT IMAGES
						$images = array(
							'large'=>array(
										'w'=>1000
									),
							'medium'=>array(
										'w'=>227,
										'h'=>211
									),
							'medium2'=>array(
										'w'=>558,
										'h'=>393
									),
							'small'=>array(
										'w'=>86,
										'h'=>86
									)
						);
						//OSTAVLJAMO ORGINAL
						$paths = $this->resize_image($img_config,$images);
						//SAVE AS PHOTO
						$img_data=array(
							'paths'=>json_encode($paths),
							'file_name'=>$original_name,
							'extension'=>$extension,
							'type'=>1
						);
						$att_id=$this->messages_model->insert_attachment($img_data);
						//SET ATTACHMENTS INTO SESSION
						$_SESSION['attachments'][]=$att_id;
						//GENERAL RESPONSE
						$response = array(
							'status'=>1,
							// 'att_id'=>$att_id,
							// 'message' => 'File uploaded',
							// 'file_type'=>'image',
							// 'listing_id' => $listing_id,
							// 'file_path' => $paths,
							// 'file_info' => $file_info
						);
					}
					else if(is_int(array_search($extension, $documents))){
						
						//SAVE AS DOCUMENT
						$doc_data=array(
							'paths'=>$file_path,
							'file_name'=>$original_name,
							'extension'=>$extension,
							'type'=>2
						);
						$att_id=$this->messages_model->insert_attachment($doc_data);
						//SET ATTACHMENTS INTO SESSION
						$_SESSION['attachments'][]=$att_id;
						//GENERAL RESPONSE
						$response = array(
							'status'=>1,
							// 'att_id'=>$att_id,
							// 'message' => 'File uploaded',
							// 'file_type'=>'document',
							// 'listing_id' => $listing_id,
							// 'file_path' => $file_path,
							// 'file_info' => $file_info
						);
					}
					//IF NOT ALLOWED IMAGE OR DOCUMENT
					else{
						$response = array(
							'status'=>0,
							'message' => 'File type not allowed',
						);
						echo json_encode($response);
						die();
					}
					
				}
				else{
					$response=array(
						'status'=>0,
						'message'=>'Upload failed'
					);
				}
	        }
		 }
		 else{
			$response=array(
				'status'=>0,
				'message'=>"You don't have premission to upload"
			);
		}
		}
		else{
			$response=array(
				'status'=>0,
				'message'=>"You don't have premission to upload"
			);
		}
		
		echo json_encode($response);
    }

	private function check_folder($path) {
		$real_path = 'upload/' . $path;
		if (is_dir($real_path)) {
			return $real_path;
		} else {
			//ONLY WEB SERVER CAN ACCESS 0700
			if (mkdir($real_path, 0755, true))
				return $real_path;
			else
				return FALSE;
		}

	}

	private function safeName($string) {
		$path_info = pathinfo($string);
		$extension = $path_info['extension'];
		$name = $path_info['filename'];
		$not_allowed = array(
			'php',
			'html',
			'js',
			'jsp'
		);
		if (is_int(array_search($extension, $not_allowed))) {
			die('FILE TYPE NOT ALLOWED');
		}
			// $string = preg_replace('/[^\\pL\d]+/u', '_', $name);
			// $string = trim($string, '_');
			// $string = iconv('utf-8', 'us-ascii//TRANSLIT', $string);
			// $string = strtolower($string);
			// $string = preg_replace('/[^-\w]+/', '', $string);
		$stamp=time();
		$string=md5($name.$stamp);
		return $string . '.' . $extension;
	}


	private function resize_image($img_config=array(),$images=array()) {
		$this->load->library('image_moo');
		//DEFAULT CONFIG
		$image_path = $img_config['image_path'];
		unset($img_config['image_path']);

		if (empty($img_config)) {
			$img_config = array(
				'delete_orig' => true,
				'quality' => 90
			);
		}
		if(empty($images)){
			$images = array(
				'large'=>array(
							'w'=>1000
						),
				'medium'=>array(
							'w'=>600
						),
				'small'=>array(
							'w'=>200
						)
			);
		}

		//GET IMAGE INFO
		$file_info = pathinfo($image_path);
		
		foreach($images as $key=>$image){
			if(!isset($image['quality']))
				$quality=$img_config['quality'];
			else
				$quality=$image['quality'];
			
			//AKO JE POSTAVLJENA SAMO SIRINA SAMO RADI RESIZE
			if(isset($image['w']) && !isset($image['h']))
				$this->image_moo->set_jpeg_quality($quality)->load($image_path)->resize($image['w'])->save_pa('', '_'.$key, TRUE);
			//AKO SU POSTAVLJENI I SIRINA I VISINA RADI RESIZE CROP
			if(isset($image['w']) && isset($image['h']))
				$this->image_moo->set_jpeg_quality($quality)->load($image_path)->resize_crop($image['w'],$image['h'])->save_pa('', '_'.$key, TRUE);
			
			
			$paths[$key.'_image'] = $file_info['dirname'] . '/'. $file_info['filename'] . '_'.$key.'.' . $file_info['extension'];
		}

		//DELETE ORIGINAL IMAGE
		if ($img_config['delete_orig'])
			unlink($image_path);
		else
			$paths['original'] = $image_path;

		return $paths;
	}
}
