<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Item extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model('main_model');
		$this->load->model('listing_model');
		$this->load->model('offers_model');
		$this->load->model('user_model');
		$this->load->helper('language');
		$this->load->helper('url');
		$this->load->helper('links');
		$this->load->helper('text');
		$this->load->helper('cookie');
		$this->load->library('currency');
		//$this->output->enable_profiler(TRUE);
		$this->load->library('multilang', array(
			'default_lang' => 'hr',
			'multilang' => true,
			'segment' => 3
		));

		session_start();
	}

	public function index() {
		//FOR DIREKT LINK FROM LIST
		if($this->input->get('offer') || $this->input->post('login_string') || $this->input->get('login')){
			$this->require_min_level(1);
		}
		else{
			$this->is_logged_in();
		}

		//UNSET ATTACHMENTS SESSION FOR FIRST VISIT
		unset($_SESSION['attachments']);

		//POSTAVLJANJE JEZIKA
		$data['lang'] = $this->multilang->get_current();
		//INICIJALIZIRAMO MENU LIB
		$this->load->library('menu', array('lang' => $data['lang']));
		//DOHVATIMO MENU ARRAY
		$data['menu_items'] = $this->menu->generate_categories_paths(NULL);
	
		$id = $this->uri->segment(3);
		//TRENUTNI ID
		$data['item'] = $this->main_model->get_item($id);
		$item_properties=$this->main_model->get_item_properties($id,$data['lang']['id']);
		//MALO TUMBANJA
		$properties_bygroup=array();
		if(!empty($item_properties)){
		foreach($item_properties as $ip){
			$properties_bygroup[$ip['group_id']]['children'][]=$ip;
			$properties_bygroup[$ip['group_id']]['type']=$ip['group_type'];
			$properties_bygroup[$ip['group_id']]['group_name']=$ip['group_name'];
		}}
		$data['item_properties']=$properties_bygroup;
		
		unset($item_properties,$properties_bygroup);
		//
		//UPDATE COUNTER
		$this->main_model->add_view($id);
		//PROVJERA BREADCRUMBSA
		$data['breadcrumbs'] = $this->menu->getkeypath($data['menu_items'], $data['item']['item_category']);
		//CATEGORY INFO
		$data['category_info'] = $this->main_model->get_cat_info($data['item']['item_category'], $data['lang']['id']);
		//IMAGES
		$data['images'] = $this->listing_model->get_images($id);
		$data['document_count'] = $this->listing_model->count_documents($id);
		//TRENUTNA POZICIJA
		$data['nav_item'] = array('path' => 'item');

		$data['offer_count'] = $this->offers_model->count_offers($data['item']['item_id']);
		$data['item_user_data']=$this->main_model->get_user_data($data['item']['user_id']);
		
		//IF LOGGED IN
		if (isset($this->auth_user_id)) {
			//IF IS OWNER
			if ($this->listing_model->is_owner($this->auth_user_id, $data['item']['item_id'])) {
				//$data['offers'] = $this->offers_model->get_item_offers($id);
				$data['is_owner'] = true;
			}
			//IF ADMIN
			else if($this->auth_role =='admin'){
				//VIEW AS ITEM OWNER
				if($this->input->get('as_owner')){
					//$data['offers'] = $this->offers_model->get_item_offers($id);
					$data['is_owner'] = true;
				}
				/*
				//VIEW AS OFFER OWNER
				else if($offer_id=$this->input->get('offer_id')){
					$data['offers'] = $this->offers_model->get_single_offer($offer_id);
					$data['is_owner'] = false;
				}
				//IF NOT OWNER BUT HAS APPLIED
				else if ($my_offer = $this->offers_model->has_applied($this->auth_user_id, $data['item']['item_id'])) {
					$data['my_offer'] = $my_offer;
					$data['is_owner'] = false;
				}
				*/
			}
			//IF NOT OWNER BUT HAS APPLIED
			/*
			else if ($my_offer = $this->offers_model->has_applied($this->auth_user_id, $data['item']['item_id'])) {
				$data['my_offer'] = $my_offer;
				$data['is_owner'] = false;
			}
			*/
		}
		/*
		if($this->input->get('o_id'))
			$data['highlighted_offer']=$this->input->get('o_id');
		*/
		//STATISTICS
		$stat = $this->main_model->get_stat($id , date('Y-m-d'));
		
		if(empty($stat)){
			
			$stat_data = array(
			'item_id' => $id,
			'date' => date('Y-m-d'),
			'count' => '1'
			);
			$this->main_model->create_stat($stat_data);
		}
		else{
			
			$this->main_model->update_stat($id, date('Y-m-d'));
		}
		

		$data['content'] = $this->load->view('main/item_view', $data, TRUE);

		$this->load->view($this->template, $data);
	}

	function select_offer() {
		$this->is_logged_in();
		if (isset($this->auth_user_id)) {
			$listing_id = $this->input->get('listing_id');
			$offer_id = $this->input->get('offer_id');
			
			//POSTAVLJANJE JEZIKA
			$data['lang'] = $this->multilang->get_current();
			
			//CHECK IF USER IS LISTING OWNER
			if ($this->listing_model->is_owner($this->auth_user_id, $listing_id)) {
				
				//CHECK IF OFFER BELONGS TO LISTING
				$base_data = $this->offers_model->get_base_data($offer_id);
				if ($listing_id == $base_data['item_id']) {
					if ($this->listing_model->select_offer($listing_id, $offer_id)) {
						
						/**ADD NOTIFICATION AND SEND MAIL**/
						$this->load->library('email');
						$this->config->load('email');
						$user_data = $this->user_model->view_user_record($base_data['offer_owner']);
						$origin_data=$this->main_model->get_sys_country($user_data->country);
						//GENERATE LINK TO ITEM
						$item_link = 'http://www.'.$origin_data['domain'] . '/item/' . url_title($base_data['item_name'], 'dash', TRUE) . '/' . $base_data['item_id'];
						
						//GET USER DATA FOR EMAIL
						$this->load->model('user_model');
						
						
						//GET MESSAGE AND SET LINK
						$message = str_replace('%link%', $item_link, lang('not_offer_selected'));
						$notif_data = array(
							'user_id' => $base_data['offer_owner'],
							'type_id' => 3,
							'message' => $message,
							'item_id'=>$listing_id
						);
						//SAVE NOTIFICATION
						$this->main_model->add_notification($notif_data);
						
						//SEND MAIL
						$sent = $this->email->quick_email(array(
							'subject' => lang('not_mail_title'),
							'email_template' => 'email_templates/notification',
							'from_name' => 'no_reply_email_config',
							'template_data' => array('message' => $message),
							'to' => $user_data->user_email
						));
						
						/**END NOTIFICATION**/
						$response = array(
							'status' => 1,
							'message' => lang('offer_selected')
						);
					} else {
						$response = array(
							'status' => 0,
							'message' => lang('offer_not_selected')
						);
					}
				} else {
					$response = array(
						'status' => 0,
						'message' => lang('offer_not_in_item')
					);
				}
			} else {
				$response = array(
					'status' => 0,
					'message' => lang('offer_not_owner')
				);
			}

		} else {
			$response = array(
				'status' => 0,
				'message' => lang('offer_login')
			);
		}
		echo json_encode($response);
	}

	public function search() {

		$search_result = $this->main_model->live_search($this->input->post('search_query'));
		if (!empty($search_result)) {
			foreach ($search_result as $result) {
				echo "<p>" . $result['item_name'] . "</p>";
			}
		}
	}

	public function attachment() {

		//POSTAVLJANJE JEZIKA
		$data['lang'] = $this->multilang->get_current();
		//INICIJALIZIRAMO MENU LIB
		$this->load->library('menu', array('lang' => $data['lang']));

		if ($id = $this->input->get('listing_id')) {
			//IMAGES AND DOCS
			$data['documents'] = $this->listing_model->get_documents($id);
			$data['listing_id'] = $id;
			$data['content'] = $this->load->view('include/attachment_view', $data);
		} else if ($id = $this->input->get('offer_id')) {
			//IMAGES AND DOCS
			$data['documents'] = $this->offers_model->get_documents($id);
			$data['offer_id'] = $id;
			$data['content'] = $this->load->view('include/offer_attachment_view', $data);
		}

	}

	public function add_to_watchlist() {
		$this->is_logged_in();
		$data['lang'] = $this->multilang->get_current();
		if (isset($this->auth_user_id)) {
			if ($this->main_model->check_if_watched($this->auth_user_id, $this->input->get('id', true))) {
				$data = array(
					'user_id' => $this->auth_user_id,
					'item_id' => $this->input->get('id', true)
				);

				if ($this->main_model->add_to_watch_list($data)) {
					$response = array(
						'status' => 1,
						'message' => lang('offer_watchlist_added')
					);
				} else {
					$response = array(
						'status' => 0,
						'message' => lang('offer_watchlist_not_added')
					);
				}
			} else {
				$response = array(
					'status' => 0,
					'message' => lang('offer_watchlist_already_added')
				);
			}

		} else {
			$response = array(
				'status' => 0,
				'message' => lang('offer_watchlist_login')
			);
		}
		
		echo json_encode($response);
		
	}
	
	//ASK QUESTION DIALOG
	public function ask_question_dialog() {
		$this->is_logged_in();
		$data['lang'] = $this->multilang->get_current();
		if (isset($this->auth_user_id)) {
				$data['questions']=$this->listing_model->get_item_questions($data['lang']['id']);
				$data['listing_id']=$this->input->get('listing_id');
		} else {
			$data['message'] = lang('ask_question_login'); 
		}
		$this->load->view('listing/ask_question_dialog_view',$data);
	}
	//ASK QUESTION PROCESS
	public function ask_question_process(){
		$this->is_logged_in();
		$data['lang'] = $this->multilang->get_current();
		if (isset($this->auth_user_id)) {
			$item_id=$this->input->post('listing_id');
			$item_data=$this->main_model->get_item($item_id);
			
			if(!empty($item_data)){
				//GET OWNER DATA
				$user_data = $this->user_model->view_user_record($item_data['user_id']);
				$question_set=array();
				$not_string='';
				$questions=$this->input->post('question',true);
				if(!empty($questions)){
					foreach($questions as $q){
						$curret_question=$this->listing_model->get_single_questions($q,$data['lang']['id']);
						$question_set[]=$curret_question['question'];
					}
					//SET NOTIFICATION STRING
					foreach($question_set as $qs){
						$not_string.='<p>'.$qs.'</p>';
					}
					/**ADD NOTIFICATION AND SEND MAIL**/
						$this->load->library('email');
						$this->config->load('email');
						//GENERATE LINK TO ITEM
						$origin_data=$this->main_model->get_sys_country($user_data->country);
						$item_link = 'http://www.'.$origin_data['domain'] . '/item/' . url_title($item_data['item_name'], 'dash', TRUE) . '/' . $item_data['item_id'];
						$message = str_replace('%link%', $item_link, lang('not_ask_questions'));
						//GET MESSAGE AND SET LINK
						$message .= $not_string;
						$notif_data = array(
							'user_id' => $item_data['user_id'],
							'type_id' => 3,
							'message' => $message
						);
						//SAVE NOTIFICATION
						$this->main_model->add_notification($notif_data);
						
						//SEND MAIL
						$sent = $this->email->quick_email(array(
							'subject' => lang('not_mail_title'),
							'email_template' => 'email_templates/notification',
							'from_name' => 'no_reply_email_config',
							'template_data' => array('message' => $message),
							'to' => $user_data->user_email
						));
						
						/**END NOTIFICATION**/
				}
				unset($question_set);
				unset($not_string);
				$response = array(
				'status' => 1,
				'message' => lang('ask_question_send')
				);
			}
			

		} else {
			$response = array(
				'status' => 0,
				'message' => lang('ask_question_login')
			);
		}
		echo json_encode($response);
	}

	public function contact(){
		$guest['email']=$this->input->post('user_email',true);
		$guest['name']=$this->input->post('user_name',true);
		$guest['message']=$this->input->post('user_message',true);
		$item_id=$this->input->post('item_id',true);
		$item_data=$this->main_model->get_item($item_id);


		$user_data = $this->user_model->view_user_record($item_data['user_id']);
		$this->load->library('email');
		$this->config->load('email');
		//SEND MAIL
		$sent = $this->email->quick_email(array(
			'subject' => 'Upit: '.$item_data['item_name'],
			'email_template' => 'email_templates/item_contact',
			'from_name' => 'www.sellbooy.com',
			'from_email' => $this->input->post('user_email',true),
			'template_data' => array('guest' => $guest),
			'to' => $user_data->user_email
		));

		if($sent){
			$response = array(
				'status' => 1,
				'message' => 'Poruka je poslana'
				);
		}
		else{
			$response = array(
				'status' => 0,
				'message' => 'Slanje poruke nije uspjelo'
				);
		}
		echo json_encode($response);
	}

	public function download_attachment() {
		$this->load->helper('download');
		$id = $this->input->get('id', true);
		$hash = $this->input->get('hash', true);
		$att = $this->offers_model->get_document($id, $hash);
		$base_data = $this->offers_model->get_base_data($id);
		if ($file = file_get_contents('upload/' . $base_data['item_id'] . '/' . $base_data['offer_owner'] . '/of/' . $att['name_hash'] . '.' . $att['extension'])) {
			$name = $att['document_name'];
			force_download($name, $file);
		} else {
			echo "File does not exist";
		}
	}

}
