<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Ending extends MY_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('main_model');
        $this->load->helper('language');
        $this->load->helper('url');
        $this->load->helper('links');
        $this->load->helper('text');
        $this->load->library('multilang', array('default_lang' => 'hr', 'multilang' => true));
		$this->load->library('pagination');
		//$this->output->enable_profiler(TRUE);
    }

    public function index() {
        
        $this->is_logged_in();
        //POSTAVLJANJE JEZIKA
        $data['lang'] = $this->multilang->get_current();
		if(!isset($data['lang']['country_id']))
			$country_id=null;
		else
			$country_id=$data['lang']['country_id'];
		
			
        //INICIJALIZIRAMO MENU LIB
        $this->load->library('menu', array('lang' => $data['lang']));
        //DOHVATIMO MENU ARRAY
        $data['menu_items'] = $this->menu->generate_categories_paths(NULL);

        $id = $this->input->get('category_id');
		
		//PAGINACIJA
		$config['base_url'] = base_url().'ending';
		$config['uri_segment'] = 2;
		$config['per_page'] = 10; 
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['prev_tag_open'] = '<li class="prev">';
        $config['prev_tag_close'] = '</li>';
        $config['prev_link'] = lang('pagination_previous');
        $config['next_tag_open'] = '<li class="next">';
        $config['next_tag_close'] = '</li>';
        $config['next_link'] = lang('pagination_next');
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="current"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['first_link'] = lang('pagination_first');
        $config['first_tag_open'] = '<li class="first">';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = lang('pagination_last');
        $config['last_tag_open'] = '<li class="last">';
        $config['last_tag_close'] = '</li>';
		

        $sort=array('item_expired_datetime'=>'asc');
        $config['total_rows'] = $this->main_model->count_items($country_id,null,null);
		$data['items'] = $this->main_model->get_items($country_id,null,null,$sort,$config['per_page'],$this->uri->segment($config['uri_segment'],0));
       
		$this->pagination->initialize($config); 
		
		$data['pagination']=$this->pagination->create_links();
        //TRENUTNA POZICIJA
        $data['nav_item'] = array('path' => 'category');
        $data['content'] = $this->load->view('main/ending_soon_view', $data, TRUE);

        $this->load->view($this->template, $data);
    }


}
