<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Category extends MY_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('main_model');
        $this->load->model('store_model');
        $this->load->model('ext_model');
        $this->load->helper('language');
        $this->load->helper('url');
        $this->load->helper('links');
        $this->load->helper('text');
        $this->load->library('multilang', array('default_lang' => 'hr', 'multilang' => true));
		$this->load->library('pagination');
        $this->load->library('currency');
		//$this->output->enable_profiler(TRUE);
    }

    public function index() {
        $this->is_logged_in();
        //POSTAVLJANJE JEZIKA
        $data['lang'] = $this->multilang->get_current();
		if(!isset($data['lang']['country_id']))
			$country_id=null;
		else
			$country_id=$data['lang']['country_id'];
		
		if($this->input->get('ending_soon'))
			$sort=array('item_expired_datetime'=>'asc');
		else
			$sort=array('item_publish_datetime'=>'desc');
        //INICIJALIZIRAMO MENU LIB
        $this->load->library('menu', array('lang' => $data['lang']));
        //DOHVATIMO MENU ARRAY
        $data['menu_items'] = $this->menu->generate_categories_paths(NULL);
		
		

        $id =(int)$this->input->get('category_id');
		
		//PAGINACIJA
		$config['base_url'] = base_url().'category/index';
		$config['suffix'] = '?' . http_build_query($_GET, '', "&");
		$config['first_url'] = $config['base_url'].'?'.http_build_query($_GET);
		$config['uri_segment'] = 3;
		$config['per_page'] = 6; 
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['prev_tag_open'] = '<li class="prev">';
        $config['prev_tag_close'] = '</li>';
        $config['prev_link'] = lang('pagination_previous');
        $config['next_tag_open'] = '<li class="next">';
        $config['next_tag_close'] = '</li>';
        $config['next_link'] = lang('pagination_next');
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="current"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['first_link'] = lang('pagination_first');
        $config['first_tag_open'] = '<li class="first">';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = lang('pagination_last');
        $config['last_tag_open'] = '<li class="last">';
        $config['last_tag_close'] = '</li>';
		
        if ($id && $id != 'all') {
            $data['submenu_items'] = $this->main_model->get_subcats($id, $data['lang']['id']);

            //TRENUTNI ID
            $data['category_info'] = $this->main_model->get_cat_info($id, $data['lang']['id']);
          
            //PROVJERA BREADCRUMBSA
            $data['breadcrumbs'] = $this->menu->getkeypath($data['menu_items'], $id);
            $data['category_id'] = $id;
            //FILTRI
            $data['filters'] = $this->main_model->get_category_properties_groups($data['breadcrumbs'],$data['lang']['id'],true);
           

        } else {

            $data['category_id'] = 'all';
             $data['breadcrumbs'] =null;
        }
        $table=$this->_check_custom_view($data['breadcrumbs']);
        //ITEMS IN CATEGORY
        if ($this->input->get('f')) {
            $group_count = 0;
            $filter = array();
            $input_filter=array();
            $raw_filters = $this->input->get('f', true);
            $price_from=$raw_filters['price_from']>0?$raw_filters['price_from']:null;unset($raw_filters['price_from']);
            $price_to=$raw_filters['price_to']>0?$raw_filters['price_to']:null;unset($raw_filters['price_to']);
            $region=$raw_filters['region']>0?$raw_filters['region']:null;unset($raw_filters['region']);
            foreach ($raw_filters as $rf) {
                //SKIP 0 VALUES
                //IF CLASSIC FILTER
                if(!is_array($rf)){
                if($rf=='0' || empty($rf))
                        continue;
                $group_count++;
                
                    $filter[] = (int)$rf;
                
                }
                else{
                    foreach($rf as $key=>$srf){
                        if($srf=='0' || empty($srf))
                            continue;
                        $input_filter[$key] = (int)$srf;
                    }
                    
                }
            }

           
            if(empty($filter))
                    $filter=null;
           
            //JUST CLASSIC FILTER
            if(!$this->input->get('ext')){    
                $config['total_rows'] = $this->main_model->count_by_filter($country_id,$region,$this->menu->children,$filter, $group_count,$price_from,$price_to,null);
                $data['items'] = $this->main_model->get_by_filter($country_id,$region,$this->menu->children,$filter, $input_filter, $group_count,$price_from,$price_to, null,$sort,$config['per_page'],$this->uri->segment($config['uri_segment'],0));
            }
            else{
                $ex_group_count=0;
                $ex_input_filter=array();
                $ext_filters = $this->input->get('ext',true);

                foreach ($ext_filters as $key=>$ef) {
                    //SKIP 0 VALUES
                    //IF EXTENDED FILTER
                    if(!is_array($ef)){
                    if($ef=='0' || $ef=='-' || empty($ef))
                            continue;
                    $ex_group_count++;
                    
                        $ex_filter[$key] = $ef;
                    
                    }
                }
                if(empty($ex_filter))
                    $ex_filter=null;
                $this->ext_model->initialize($table);
                $config['total_rows'] = $this->ext_model->count_by_filter($country_id,$region,$this->menu->children,$filter, $group_count,$ex_filter, $ex_group_count,$price_from,$price_to,null);
                $data['items'] = $this->ext_model->get_by_filter($country_id,$region,$this->menu->children,$filter, $input_filter, $group_count,$ex_filter, $ex_group_count,$price_from,$price_to, null,$sort,$config['per_page'],$this->uri->segment($config['uri_segment'],0));
               
            }
        }
        else{
        	
        	$config['total_rows'] = $this->main_model->count_items($country_id,$this->menu->children,null);
			$data['items'] = $this->main_model->get_items($country_id,$this->menu->children,null,$sort,$config['per_page'],$this->uri->segment($config['uri_segment'],0));
        }
		$this->pagination->initialize($config); 
		
		$data['pagination']=$this->pagination->create_links();
		
		$data['promoted_items'] = $this->main_model->get_promoted_items($country_id,null,null,$sort,'3',$this->uri->segment($config['uri_segment'],0));
		
		
        //TRENUTNA POZICIJA
        $data['nav_item'] = array('path' => 'category');
        switch ($table) {
                        case 'ext_cars':
                             $data['ext_table']=$table;
                             $data['content'] = $this->load->view('main/custom/'.$table.'_view', $data, TRUE);
                            break;
                        
                        default:
                             $data['content'] = $this->load->view('main/category_view', $data, TRUE);
                            break;
                    }
		
	 	
       

        $this->load->view($this->template, $data);
    }

    //CUSTOM FORM CHECK
    private function _check_custom_view($breadcrumbs){
        $reverse=array_reverse ( $breadcrumbs );
        foreach((array)$reverse as $r){
            $this->db->select('exp_table');
            $this->db->from('item_categories');
            $this->db->where('category_id',$r);
            $query=$this->db->get();
            $result=$query->row_array();
            if(!empty($result['exp_table']))
                return $result['exp_table'];
        }
        return false;
    }

}
