<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Fb_api extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->helper('language');
		$this->load->model('api_model');
		$this->load->model('main_model');
		$this->load->library('encrypt');
		//$this->output->enable_profiler(TRUE);
		$this->load->library('multilang', array('default_lang' => 'hr', 'multilang'=>true,'segment'=>3));
	}
	
	
	function test(){
		$data['lang']=$this->multilang->get_current();
		$id=30;
		$item=$this->main_model->get_item($id);
		$key = 'super-secret-key';
		$data=array(
			'user_id'=>$item['user_id'],
			'item_id'=>$item['item_id']
		);
		$data=urlencode($this->encrypt->encode(json_encode($data), $key));
		echo base_url().'api/fb_api/check_owner'.url_title($item['item_name'], 'dash', TRUE).'/'.$item['id'].'?data='.$data;
	}
	
	function check_owner(){
		$data['lang']=$this->multilang->get_current();
	
		if(!isset($data['lang']['country_id']))
			$country_id=null;
		else
			$country_id=$data['lang']['country_id'];	
		$app_id=$this->input->get('appId');
		$user_id=$this->input->get('user_id',true);
		$item_id=$this->input->get('item_id',true);
		$result=$this->api_model->check_owner($item_id,$user_id);
		if($result){
			$image=$this->main_model->get_image($item_id);
			if(!empty($image))
				$image=$image['paths'];
			else
				$image=null;
			$output=array(
			'id'=>$result['item_id'],
			'url'=>base_url().'item/'.url_title($result['item_name'], 'dash', TRUE).'/'.$result['item_id'],
			'name'=>$result['item_name'],
			'content'=>$result['item_content'],
			'item_expired_time'=>$result['item_expired_datetime'],
			'image'=>$image
			
		);
		echo json_encode($output);
		}
		else {
			echo 0;
		}
		
	}
		

}