<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Basic extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->helper('language');
		$this->load->model('api_model');
		//$this->output->enable_profiler(TRUE);
		$this->load->library('multilang', array('default_lang' => 'hr', 'multilang'=>true,'segment'=>3));
	}
	
	function list_latest(){
		$data['lang']=$this->multilang->get_current();
	
		if(!isset($data['lang']['country_id']))
			$country_id=null;
		else
			$country_id=$data['lang']['country_id'];
		$num=$this->input->get('num',true);
		$data=$this->api_model->get_expiring_items('i.item_id as id,item_name as name, ict.category_name ',$country_id,null,$num);
		foreach($data as $key=>$d){
			$data[$key]['url']=base_url().'item/'.url_title($d['name'], 'dash', TRUE).'/'.$d['id'];
		}
		
		echo json_encode($data);
	}
	
	function search(){
		$this->load->model('main_model');
		 $data['lang'] = $this->multilang->get_current();
		 //INICIJALIZIRAMO MENU LIB
        $this->load->library('menu', array('lang' => $data['lang']));
		  //DOHVATIMO MENU ARRAY
        $data['menu_items'] = $this->menu->generate_categories_paths(NULL);
		
        if(!isset($data['lang']['country_id']))
			$country_id=null;
		else
			$country_id=$data['lang']['country_id'];
		if(empty($_GET)){
			echo "no data sent";
			die();
		}		
		$search_string=$this->input->get('keyword',true);
		$search_string=urldecode($search_string);
		$search_string=str_replace('"', "", $search_string);
		$search_string=str_replace("'", "", $search_string);
		
		$cid=$this->input->get('cid',true);
		$num=$this->input->get('num',true);
		$offset=$this->input->get('offset',true);
		
		if($cid!='all'){
        	$data['breadcrumbs'] = $this->menu->getkeypath($data['menu_items'], $cid);
			$cat_span=$this->menu->children;
        }
		else{
			$cat_span='all';
		}
		
		$result=$this->main_model->simple_search_items($country_id, $search_string, $cid, null, $num, $offset);
		echo json_encode($result);
	}
	
	function get_item(){
		$id=$this->input->get('id',true);
	}
	
	function check_owner(){
		$id=$this->input->get('id');
		$username=$this->input->get('user',true);
	}
		

}