<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Users extends MY_Controller {

	public function __construct() {
		parent::__construct();

		$this->load->library('session');
		$this->load->library('form_validation');
		$this->load->library('validation');
		$this->load->helper('text');
		$this->load->helper('breadcrumbs_helper');
		$this->load->model('admin/users_model');
		$this->load->library('csrf');
		$this->load->library('encrypt');

		//(filename,language)
		$this->lang->load('admin', $this->config->item('admin_lang'));
		$this->load->helper('language');
	}

	public function index() {

		if ($this->require_role_admin('Admin,Manager')) {
			
			$data['year'] = date("Y");
			$data['query'] = $this->users_model->list_users();
			$data['content'] = $this->load->view('admin/users/main_view', $data, TRUE);

			$this->load->view($this->admin_template, $data);
		}

	}

	public function view() {

		if ($this->require_role_admin('Admin,Manager')) {

			if (isset($_GET['uid'])) {
				$data['query_single'] = $this->users_model->get_user($_GET['uid']);
			}
            
            $data['year'] = date("Y");

			$data['content'] = $this->load->view('admin/users/single_view', $data, TRUE);
			$data['style_sheets'] = array('admin_assets/DT_bootstrap.css', );

			$this->load->view($this->admin_template, $data);
		}

	}

	public function process() {

		if ($this->require_role_admin('Admin,Manager')) {
			$this->load->library('csrf');

			if ($this->input->post('published') == 'checked') {
				$user_active = '0';
			} else {
				$user_active = '0';
			}

			if ($this->input->post('user_id') == 0) {

				//SENDING FORM DATA TO MODEL
				$files = array(
					'user_name' => $this->input->post('user_name'),
					'user_pass' => $this->input->post('user_pass'),
					'user_email' => $this->input->post('user_email'),
					'user_level' => $this->input->post('user_level'),
					'first_name' => $this->input->post('first_name'),
					'last_name' => $this->input->post('last_name'),
					'license_number' => rand(1000, 50000),
					'user_banned' => $user_active
				);

				$profile_files = array(
					'first_name' => $this->input->post('first_name'),
					'last_name' => $this->input->post('last_name')
				);

				if ($this->users_model->create_user($files)) {

					$response = array('response' => '<div class="alert alert-success"><a class="close" data-dismiss="alert" href="#">&times;</a>Korisnik je uspješno editiran!</div>', );
					echo json_encode($response);

				} else {
					$response = array('response' => "<div class='alert alert-error'><a class='close' data-dismiss='alert' href='#'>&times;</a>Desila se greška kod spremanja!</div>", );
					echo json_encode($response);
				}

			} else {

				$files = array(
					'user_name' => $this->input->post('user_name'),
					'user_pass' => $this->input->post('user_pass'),
					'user_email' => $this->input->post('user_email'),
					'user_level' => $this->input->post('user_level'),
					'user_banned' => $this->input->post('published'),
					'user_pass_confirm' => $this->input->post('user_pass_confirm'),
				);

				$profile_files = array(
					'first_name' => $this->input->post('first_name'),
					'last_name' => $this->input->post('last_name')
				);

				if ($this->users_model->update_user($this->input->post('user_id'), 'update_user', $files, $profile_files)) {

					$response = array('response' => '<div class="alert alert-success"><a class="close" data-dismiss="alert" href="#">&times;</a>Korisnik je uspješno editiran!</div>', );
					echo json_encode($response);

				} else {
					$response = array('response' => "<div class='alert alert-error'><a class='close' data-dismiss='alert' href='#'>&times;</a>Desila se greška kod spremanja!</div>", );
					echo json_encode($response);
				}

			}

		}

	}



	function delete($item_id) {
		if ($this->require_role_admin('Admin,Manager')) {

			if ($this->users_model->delete_user($item_id)) {
				$response = array('response' => '<div class="alert alert-success"><a class="close" data-dismiss="alert" href="#">&times;</a>Korisnik je uspješno obrisan!</div>', );
				echo json_encode($response);

			} else {

				$response = array('response' => "<div class='alert alert-error'><a class='close' data-dismiss='alert' href='#'>&times;</a>Desila se greška kod brisanja!</div>", );
				echo json_encode($response);
			}

		}

	}

}
