<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Support extends MY_Controller {
	
	public $advertising_key='sa314n1hfjalfhhlgvu3';

    public function __construct() {
        parent::__construct();
        $this->load->model('admin/general_model');
        $this->load->model('admin/support_model');
        $this->load->model('user_model');
        $this->load->library('multilang', array('default_lang' => 'hr', 'multilang' => false));
        $this->load->library('encrypt');
        $this->load->helper('language');
    }

    public function tickets() {
        if ($this->require_role_admin('admin,manager')) {
            $data['lang'] = $this->multilang->get_current();
            //Active
            if ($this->input->get('active') != '')
                $active = $this->input->get('active', true);
            else
                $active = null;
			//COUNTRIES
			$country=$this->general_model->user_countries($this->auth_role,$this->auth_user_id);
			//END COUNTRIES
			$count = $this->support_model->count_tickets($country,$active);
            //DEFINIRAMO LISTU ATRIBUTA KOJE ŽELIMO, PONOVLJENI ATRIBUTI TREBAJU IMATI DRUGACIJI ALIAS, DEFAULT LANG 1
            $param_list = array('title', 'u.user_id','u.user_name','u.user_email','status','submit_datetime', 'c.name as country_name', '', 'spt.id as edit_id', 'spt.id as delete_id');
            $query = $this->support_model->get_tickets_datagrid($param_list, $country, $active);
            if (!empty($query)) {
                foreach ($query as $q) {
                    //OBLIKOVANJE PODATAKA ZA ISPIS
                    $q['title'] = htmlspecialchars($q['title']);
                    $q['submit_datetime'] = date('d.m.Y.', strtotime($q['submit_datetime']));
                }
            }
			$data['tickets']=$query;
			
            //SET MENU AND GET CLIENTS
            $data['params']['country'] = $country;
            $data['params']['active'] = $active;
            $data = array('content' => $this->load->view('admin/support/tickets_main_view', $data, TRUE));
            $this->load->view($this->admin_template, $data);
        }
    }

    public function view_ticket() {
        if ($this->require_role_admin('admin,manager')) {
            //GET LANG DATA AND SET MENU
            $data['lang'] = $this->multilang->get_current();
			$id=$this->input->get('id');
			$data['query'] = $this->support_model->get_ticket($id);
			//USER DATA
			$data['user_data'] = $this->user_model->view_user_record($data['query']['user_id']);	
            if($this->auth_role =='manager'){
                $current_countries=$this->general_model->get_manager_countries($this->auth_user_id);
                if(!empty($current_countries)){
                    $country=array();
                    foreach($current_countries as $cc){
                        $country[]=$cc['country_id'];
                    }
                }
            }
                
            else 
                $country=null;
          
            
            //UTIL
            $data = array('content' => $this->load->view('admin/support/ticket_single_view', $data, TRUE));
            $this->load->view($this->admin_template, $data);
        }
    }
 	

    public function process_ticket() {
        if ($this->require_role_admin('admin,manager')) {
			$id=$this->input->post('ticket_id',true);
			$ticket_data=$this->support_model->get_ticket($id);
			$user_lang=$this->general_model->get_country_lang($ticket_data['country_id']);
			$this->lang->load('frontend', $user_lang['abbr']);
			if ($this->input->post('status')){
				$status = '1';
			}
			else{
				$status = '0';
			}
			$base_data=array(
				'status'=>$status,
			);
			
			if($this->support_model->update_ticket($id,$base_data)){
				if($ticket_data['status']!=$status){
					$notif_data=array(
					'user_id'=>$ticket_data['user_id'],
					'type_id'=>5,
					'message'=>lang('supp_adm_status_changed'),
					'ticket_id'=>$id
					);
					//SAVE NOTIFICATION
					$this->general_model->add_notification($notif_data);
				}
				
				
				$response=array(
						'main_data'=>1,
						'response' => 'Ticket status updated!'
					);
			}
			else{
				$response=array(
						'main_data'=>0,
						'response' => 'Ticket status not updated!'
					);
			}
		//OUTPUT RESULT
		echo json_encode($response);
		}
    }
	
	function get_ticket_msg($id){
		if ($this->require_role_admin('admin,manager')) {
		$data['item_notifications']=$this->support_model->get_ticket_messages($id);
		$this->load->view('admin/support/ajax_list_ticket_msg',$data);
		}
	}
	
	/*SENDS CUSTOM MESSAGE*/
	function ticket_respond() {
		if ($this->require_role_admin('admin,manager')) {
				$ticket_id=$this->input->post('ticket_id',true);
				$notification=$this->input->post('resp_text',true);
				/**ADD NOTIFICATION AND SEND MAIL**/
            	$this->load->library('email');
				$this->config->load('email');
				//GENERATE LINK TO ITEM
				//$item_link=base_url().'item/'.url_title($item_name, 'dash', TRUE).'/'.$item_id;
				//GET USER DATA FOR EMAIL
				$this->load->model('user_model');
				$ticket_data=$this->support_model->get_ticket($ticket_id);
            	$user_data=$this->user_model->view_user_record($ticket_data['user_id']);
				//GET MESSAGE AND SET LINK
            	$notif_data=array(
					'user_id'=>$this->auth_user_id,
					'sent_by'=>$this->auth_role,
					'message'=>$notification,
					'ticket_id'=>$ticket_id,
					'is_read'=>'0'
				);
				//SAVE NOTIFICATION
				$this->support_model->add_ticket_msg($notif_data);
				$notif_data=array(
					'user_id'=>$ticket_data['user_id'],
					'type_id'=>5,
					'message'=>$notification,
					'ticket_id'=>$ticket_id
				);
				//SAVE NOTIFICATION
				$this->general_model->add_notification($notif_data);
				//SEND MAIL
				$sent=$this->email->quick_email( array(
							'subject'        => 'Zaprimili ste odgovor na Vaš ticket',
							'email_template' => 'email_templates/notification',
							'from_name'      => 'no_reply_email_config',
							'template_data'  => array( 'message' => $notification ),
							'to'             => $user_data->user_email
						) );
				if($sent){
					$response=array(
						'status'=>1,
						'response' => 'Response sent'
					);
				}
				else{
					$response=array(
						'status'=>0,
						'response' => 'Response not sent'
					);
				}
				//OUTPUT RESULT
				echo json_encode($response);
		}
	}


}
