<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Stores extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model('admin/general_model');
		$this->load->model('admin/listings_model');
		$this->load->model('admin/stores_model');
		$this->load->model('admin/categories_model');
		$this->load->model('offers_model');
		$this->load->model('user_model');
		$this->load->library('multilang', array(
			'default_lang' => 'hr',
			'multilang' => false
		));
		$this->load->library('encrypt');
		$this->load->helper('language');
	}

	public function index() {
		if ($this->require_role_admin('admin,manager')) {

			$data['lang'] = $this->multilang->get_current();
			//COUNTRIES
			$country=$this->general_model->user_countries($this->auth_role,$this->auth_user_id);
			//END COUNTRIES
			
			$data['query'] = $this->stores_model->get_stores_datagrid($country);

			$data = array('content' => $this->load->view('admin/stores/main_view', $data, TRUE));
			//$data['lang']=$this->general_model->get_lang(1);
			$this->load->view($this->admin_template, $data);
		}
	}

	public function listings(){
		if ($this->require_role_admin('admin,manager')) {

			$data['lang'] = $this->multilang->get_current();
			//COUNTRIES
			$country=$this->general_model->user_countries($this->auth_role,$this->auth_user_id);
			//END COUNTRIES
			$store_id=$this->input->get('id',true);
			$store_data=$this->db->from('stores')->where('store_id',$store_id)->get()->row_array();
			//MAIN FILTER BY PUBLISH STATUS
			//PUBLISHED
			if ($this->input->get('f_published') !== FALSE) {
				$published = $this->input->get('f_published', true);
			} else {
				$published = 'all';
			}
			$data['published']=$published;
			//CATEGORY NAV
			
			$data['published'] = $published;
			$data['store']=$store_data;
			//PUBLISHED
			if ($this->input->get('f_published') != 'all') {
				$published_grid = $this->input->get('f_published', true);
			} else {
				$published_grid = null;
			}


			//DEFINIRAMO LISTU ATRIBUTA KOJE ŽELIMO, PONOVLJENI ATRIBUTI TREBAJU IMATI DRUGACIJI ALIAS, DEFAULT LANG 1
			$param_list = array(
				'item_id',
				'item_name',
				'item_publish_datetime',
				'item_expired_datetime',
				'item_published',
				'item_id as edit_id',
				'item_id as delete_id'
			);
			$data['query'] = $this->stores_model->get_listings_datagrid($param_list, $store_data['user_id'],null,$country);
			$data = array('content' => $this->load->view('admin/stores/listings_view', $data, TRUE));
			//$data['lang']=$this->general_model->get_lang(1);
			$this->load->view($this->admin_template, $data);
		}
	}




}
