<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Settings extends MY_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('form_validation');
        $this->load->library('validation');
        $this->load->model('admin/general_model');
        $this->load->model('admin/settings_model');
        $this->lang->load('admin', $this->config->item('admin_lang'));
        $this->load->helper('language');

    }

    function view() {

        if ($this->require_role_admin('Admin,Manager')) {

            $data['query_single'] = $this->settings_model->get_settings();

            $data['year'] = date("Y");
            $data['content'] = $this->load->view('admin/settings/single_view', $data, TRUE);

            $this->load->view($this->admin_template, $data);
        }

    }

    function process() {

        if ($this->require_role_admin('Admin,Manager')) {

            //FORM VALIDATION
            $this->form_validation->set_message('required', 'Polje <strong>%s</strong> je potrebno upisati.');

            $this->form_validation->set_rules('emails', 'Lista e-mail adresa na koju se šelju obvijesti', 'required');
            //$this->form_validation->set_rules('content_hr', 'Sadržaj (HR)', 'required');

            //CHECK IF FORM IS VALID
            if ($this->form_validation->run() == FALSE) {

                $response = array(
                    'response' => '<div class="alert alert-danger alert-dismissable margin-l-none"><a class="close" data-dismiss="alert" href="#">&times;</a>' . validation_errors() . '</div>',
                    'last_row_id' => '0'
                );
                echo json_encode($response);

            } else {

                // SENDING FORM DATA TO MODEL //////////////////////////////////////////////////////////////////////////
                $files = array(
                    'virman_left' => $this->input->post('virman_left'),
                    'virman_top' => $this->input->post('virman_top'),
                    'certificate_left' => $this->input->post('certificate_left'),
                    'certificate_top' => $this->input->post('certificate_top'),
                );


                if ($this->general_model->update_settings($files)) {

                    $response = array(
                            'response' => '<div class="alert alert-success alert-dismissable margin-l-none"><a class="close" data-dismiss="alert" href="#">&times;</a>Sadržaj je uspješno spremljen!</div>'
                        );
                        echo json_encode($response);

                } else {

                    $response = array(
                            'response' => "<div class='alert alert-danger alert-dismissable margin-l-none'><a class='close' data-dismiss='alert' href='#'>&times;</a>Desila se greška kod spremanja. Molimo kontaktirajte administratora.</div>"
                        );
                        echo json_encode($response);
                }

            }

        }
    }

    function view_menu() {

        if ($this->require_role_admin('Admin,Manager')) {

            $data['query_single'] = $this->general_model->get_settings(1);
            $data['last_edit_by'] = $this->general_model->user_information($data['query_single']['last_edit_by']);

            $categories = $this->settings_model->get_categories();
            $data['category_list'] = $categories;

            $data['title'] = WEBSITE_NAME;
            $data['content'] = $this->load->view('admin/settings/menu_view', $data, TRUE);
            $data['style_sheets'] = array(
                'admin_assets/css/colorbox.css',
                'admin_assets/css/datepicker.css'
            );
            $data['javascripts'] = array(
                'admin_assets/js/jquery.validate.js',
                'admin_assets/js/jquery.metadata.js',
                'admin_assets/js/jquery.colorbox.js">',
                'tiny_mce/tiny_mce.js'
            );

            $this->load->view($this->admin_template, $data);
        }

    }

    function process_menu() {

        if ($this->require_role_admin('Admin,Manager')) {

            $this->settings_model->delete_menu();

            $rand = $this->input->post('rand');
            $menu_id = $this->input->post('menu_id');
            $table_name = $this->input->post('table_name');
            $menu_name_hr = $this->input->post('menu_name_hr');
            $menu_name_en = $this->input->post('menu_name_en');
            $menu_name_de = $this->input->post('menu_name_de');

            $x = 0;

            foreach ($rand as $id_d => $row) {

                $x++;

                /*$menu_name_hr = $menu_name_hr[$id_d];
                 $menu_name_en = $menu_name_en[$id_d];
                 $menu_name_de = $menu_name_de[$id_d];*/

                $menu_options = array(
                    'edit_datetime' => date('Y-m-d H:i:s'),
                    'last_edit_by' => $this->auth_user_id,
                    'menu_id' => $row,
                    'table_name' => $table_name[$id_d],
                    'menu_name_hr' => $menu_name_hr[$id_d],
                    'menu_name_en' => $menu_name_en[$id_d],
                    'menu_name_de' => $menu_name_de[$id_d],

                    'position' => $x
                );

                if ($row != "") {

                    $this->settings_model->insert_menu($menu_options);

                }

            }

            $response = array('response' => '<div class="alert alert-success"><a class="close" data-dismiss="alert" href="#">&times;</a>Sadržaj je uspješno spremljen!</div>',
                //'last_row_id' => ''
            );
            echo json_encode($response);

        }

    }

    public function datagrid_hr() {

        if ($this->require_role_admin('Admin,Manager')) {

            echo '{
    "sProcessing":   "Procesiram...",
    "sLengthMenu":   "Prikaži _MENU_ rezultata po stranici",
    "sZeroRecords":  "Ništa nije pronađeno",
    "sInfo":         "Prikazano _START_ do _END_ od _TOTAL_ rezultata",
    "sInfoEmpty":    "Prikazano 0 do 0 od 0 rezultata",
    "sInfoFiltered": "(filtrirano iz _MAX_ ukupnih rezultata)",
    "sInfoPostFix":  "",
    "sSearch":       "Filter",
    "sUrl": "",
    "oPaginate": {
        "sFirst":    "Prva",
        "sPrevious": "Nazad",
        "sNext":     "Naprijed",
        "sLast":     "Zadnja"
    		}
				}';

        }

    }

    public function datagrid_en() {

        if ($this->require_role_admin('Admin,Manager')) {

            echo '{
    "sProcessing":   "Loading...",
    "sLengthMenu":   "Show _MENU_ entries",
    "sZeroRecords":  "No matching records found",
    "sInfo":         "Showing  _START_ to _END_ of _TOTAL_ entries",
    "sInfoEmpty":    "Showing 0 to 0 of 0 entries",
    "sInfoFiltered": "(filtrirano iz _MAX_ ukupnih rezultata)",
    "sInfoPostFix":  "",
    "sSearch":       "Search",
    "sUrl": "",
    "oPaginate": {
        "sFirst":    "First",
        "sPrevious": "Previous",
        "sNext":     "Next",
        "sLast":     "Last"
    }
}';

        }

    }

    public function datagrid_de() {

        if ($this->require_role_admin('Admin,Manager')) {

            echo '{
     "sProcessing":   "Bitte warten...",
    "sLengthMenu":   "_MENU_ Einträge anzeigen",
    "sZeroRecords":  "Keine Einträge vorhanden.",
    "sInfo":         "_START_ bis _END_ von _TOTAL_ Einträgen",
    "sInfoEmpty":    "0 bis 0 von 0 Einträgen",
    "sInfoFiltered": "(gefiltert von _MAX_  Einträgen)",
    "sInfoPostFix":  "",
    "sSearch":       "Suchen",
    "sUrl":          "",
    "oPaginate": {
        "sFirst":    "Erster",
        "sPrevious": "Zurück",
        "sNext":     "Nächster",
        "sLast":     "Letzter"
    }
}';

        }

    }

    public function help() {
        $this->load->view('admin/settings/help_view');
    }

}
